/***********************************************************************//**
	@file
	$Revision: 80 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:08:47 +0900#$
***************************************************************************/
#ifndef __OPENMJ_SERVER_PLAYER_H__
#define __OPENMJ_SERVER_PLAYER_H__

#include <boost/thread.hpp>
#include "common/Player.h"
#include "common/Socket.h"

namespace openmj {
namespace server {
class Receiver;
/***********************************************************************//**
	
***************************************************************************/
class Player : public openmj::Player {
    typedef openmj::Player super;

  private:
    Socket* socket_;
    unsigned int serial_;
    boost::thread thread_;
    boost::mutex mutex_;
    Receiver* receiver_;

  public:
    Player(Socket* socket);
    void close();

    void send(const char* command);
    void recv(Receiver* receiver);

  private:
    ~Player();
    void exec();
};
/***********************************************************************//**
	$Id: Player.h 80 2009-03-28 13:08:47Z yatsuhashi $
***************************************************************************/
}	/* namespace server */
}	/* namespace openmj */
#endif	/* __OPENMJ_SERVER_PLAYER_H__ */
