#ifndef CSAMPLE_SCENE_NODE_H_INCLUDE_GUARD
#define CSAMPLE_SCENE_NODE_H_INCLUDE_GUARD

#include "irrlicht.h"
#include "opennurbs.h"

class CONObjSceneNode : public irr::scene::ISceneNode{
	irr::core::aabbox3d<irr::f32> Box;

public:
	irr::video::SMaterial Material, WMaterial;
	bool IsSelectable;
	bool Selected;
	const ONX_Model *ONModel;
	ON_3dmObjectAttributes ONAttribute;

	irr::core::array<irr::video::S3DVertex> Vertices;
	irr::core::array<irr::u32> Indices;

	CONObjSceneNode(const ONX_Model *model, const ON_Mesh *mesh, ON_3dmObjectAttributes &attr, irr::scene::ISceneNode* parent, irr::scene::ISceneManager* mgr, irr::s32 id);
	CONObjSceneNode(const ONX_Model *model, const ON_Brep *brep, ON_3dmObjectAttributes &attr, irr::scene::ISceneNode* parent, irr::scene::ISceneManager* mgr, irr::s32 id);

	virtual void OnRegisterSceneNode();

	virtual void render();

	virtual const irr::core::aabbox3d<irr::f32>& getBoundingBox() const;

	virtual irr::u32 getMaterialCount() const;
	virtual irr::video::SMaterial& getMaterial(irr::u32 i);
};

#endif // CSAMPLE_SCENE_NODE_H_INCLUDE_GUARD
