//############################################################################//  
// Copyright (C) 2010 Friedrich Kastner-Masilko
// SC3Data.h
// Class headers for SC3 data encapsulation.
//############################################################################//
#pragma once
#include "Orbitersdk.h"
#include "UMmuSDK.h"  
#include "xves.h"
#include <vector>

using namespace std;

namespace SC3Data
{
	class Payload
	{
	public:
		Payload(VESSEL *owner);
		~Payload();
		bool Init(char *ini, int index);
		void clbkSetClassCaps (FILEHANDLE cfg);
		void Eject(void);
		void Clear(void);

	private:
		// mesh name of payload. You can define up to 5 meshes for one
		// payload, they must be declared in the same string, with each mesh name separated by a ;
		// (semi-colon). Ex: mesh1;mesh2
		vector<char *> meshname;

		// the name that will be given to the vessel at payload release time
		char *name;

		// (x,y,z) vector position of payload mesh offset in launcher (meters). If you
		// have declared more than one mesh for the payload, you must declare the same number of
		// offset in the same order. Offset positions are separated by ; (semi-columns). Ex: (0,0,25);
		// (0,0,27)
		vector<VECTOR3> off;

		// payload mass in kg
		double mass;

		// module name to be called at vessel create. This is the config file name
		// of the vessel type of the payload.
		char *module;

		// translation speed for payload jettison relative to spacecraft (in m/s)
		VECTOR3 speed;

		// rotation speed for payload jettison relative to spacecraft (in rad/s)
		VECTOR3 rotation;

		VESSEL *owner;

		vector<int> meshIndex;
	};

	class UMmu
	{
	public:
		UMmu(VESSEL *owner);
		~UMmu();
		bool Init(char *ini);
		bool clbkLoadStateEx (char *line);
		void clbkSaveState(FILEHANDLE scn);
		void clbkPostStep(double simt,double simdt,double mjd);
		void EVA(int slot);
		void RenderHUD(oapi::Sketchpad *skp);

	private:
		VESSEL *owner;
		int ummuSdKInitReturnCode;
		int maxSeatsAvailable;
		UMMUCREWMANAGMENT crew;
	};

	class Vessel
	{
	public:
		Vessel(){};
		~Vessel();
		void Init(VESSEL *owner, char *filename, void (__stdcall *make_vessel)(DWORD,DWORD,char*,char*));
		void clbkSetClassCaps (FILEHANDLE cfg);
		bool clbkLoadStateEx (char *line);
		void clbkSaveState(FILEHANDLE scn);
		void clbkPostStep(double simt,double simdt,double mjd);
		void Jettison();
		void EVA(int slot);
		void RenderHUD(oapi::Sketchpad *skp);

		//XVES Parser data
		genericvessel_config	Config;
		genericvessel_data		Data;

	private:
		vector<Payload *>		payloads;
		UMmu					*crew;
		int currentPayload;
	};
}