//############################################################################//  
//Made in 2005-2013 by Artyom Litvinovich
//Modified 2013-02-10 by Friedrich Kastner-Masilko
//Dynamic vessel parser DLL h
//############################################################################//

struct crgba{
 byte r,g,b,a;
};
//############################################################################//
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
//=================IMMUTABLE! Don't change without sync up with xves!=========//
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
//############################################################################//
//Configuration block
struct genericvessel_config{
 DWORD id;                                                  //Irrelevant for us
 char vesnam[255],dllnam[255];                              //Vessel name and DLL name
 double size,mass;                                          //Size and empty mass
 VECTOR3 pmi,cross,rdrag;                                   //PMI, cross section, rotation drag
 int tdp_anim;                                              //Touchdown points animation number
 VECTOR3 defcamera;                                         //Default camera position
 double frc1,frc2,cw1,cw2,cw3,cw4,pitchms,bankms;
 int transponder,navrcnt,use_pm,sorted_anims,needs_pilot;
 double time_spent;                                         //Time spent making the vessel (Orbiter Shipyard lagacy)

 crgba albedo;                                              //Vesssel albedo
 double gravgrad,wingasp,wingeff,maxbrakef,vislim1,vislim2; 
 int vcon;                                                  //Presence of VC

 //Sizes of data block structures
 int propcnt;
 int thcnt,thgcnt;
 int exhcnt;
 int mshcnt;
 int anicnt;
 int vccnt;
 int tdcnt;
 int beaccnt;
 int dockcnt;
 int crewcnt;
 int aircnt;
 int attcnt;
 int armcnt;
 int paycnt;
};
//############################################################################//
//Fuel tank
struct genericvessel_propinfo{
 double mass;
};   
//############################################################################//
//Thruster
struct genericvessel_thinfo{
 VECTOR3 pos,dir;
 double maxthr,isp,ispref,pref;
 int phid,grp[8];                 //Propellant tank #, thruster group #
};      
//############################################################################//
//Exhaust stream
struct genericvessel_exhinfo{
 int th,tex,tp;              //Thruster, texture, type
 double lscl,wscl;           //Length and width
 VECTOR3 pos,rot;
};   
//############################################################################//
//Mesh info
struct genericvessel_mshinfo{
 char nam[255];
 int typ;
 DWORD id;
 int vis;
 VECTOR3 off;
};  
//############################################################################//
//Animation info
#pragma pack(push)
#pragma pack(1)
struct genericvessel_animcompinfo{
 int msh,id,tp,grp,parent;
 VECTOR3 ref,axshsc;
 float angle;
 double st0,st1;
 MGROUP_TRANSFORM *cmpdef;
 ANIMATIONCOMPONENT_HANDLE cmpt;
};
struct genericvessel_animinfo{
 UINT id;
 DWORD tp,repeat,pause;
 DWORD trigkey;
 int status;
 double spd,proc,init;
 int grpcnt;
 int compcnt;
 unsigned int **grp;
 genericvessel_animcompinfo *comp;
}; 
//############################################################################//
//Virtual cockpit descriptions
struct genericvessel_vcmfdinfo{
 DWORD nmesh,ngroup,tp;          //Put MFD #tp at the mesh #, group #
};
struct genericvessel_vcinfo{
 VECTOR3 camoff,camdir;
 VECTOR3 camrng[3];              //Camera range
 int nbhs[4];
 
 int hudmsh,hudgrp;              //Group and mesh for HUD
 VECTOR3 hudoff;
 double hudsiz;

 //MFDs in VC
 int mfdcnt; 
 genericvessel_vcmfdinfo* mfds; 
};   
//############################################################################//
//Touchdown points set  
struct genericvessel_tdinfo{
 VECTOR3 pta,ptb,ptc;
};        
//############################################################################//
//Light beacon
struct genericvessel_beacinfo{
 BEACONLIGHTSPEC bl;
 VECTOR3 pos,col;
};   
//############################################################################//
//Docking port
struct genericvessel_dockinfo{
 VECTOR3 pos,dir,rot;
};      
//############################################################################//
//Attachment point
struct genericvessel_attachinfo{
 int ischild,loose;
 double range;
 VECTOR3 pos,dir,rot; 
 char name[255],id[255];
};   
//############################################################################//
//Robotic arm description
struct genericvessel_arminfo{
 double range_low,range_high;
 int seq,grap_seq,grap_attach;
 VECTOR3 tip[3];
 char name[255];
};  
//############################################################################//
//Payload description
struct genericvessel_payinfo{
 int mesh,mesh_cnt;
 double mass;
 VECTOR3 speed,rot_speed;
 char module[255],name[255];   
};  
//############################################################################//
//Crew info
struct genericvessel_crewinfo{
 VECTOR3 air_pos,air_siz,eva_pos,eva_rot;        //Airlock position, rotation, ...
 int maxcrew;
};      
//############################################################################//
//Airfoil description
struct genericvessel_airinfo{
 int tp,anim,align,axis;
 double c,s,a;
 VECTOR3 v;
};
//############################################################################//
//Data block
struct genericvessel_data{
 genericvessel_propinfo   *prop;
 genericvessel_thinfo     *th;
 genericvessel_exhinfo    *exh;
 genericvessel_mshinfo    *msh;
 genericvessel_animinfo   *anim;
 genericvessel_vcinfo     *vc;
 genericvessel_tdinfo     *td;
 genericvessel_beacinfo   *beac;
 genericvessel_dockinfo   *dock;
 genericvessel_crewinfo   *crew;
 genericvessel_airinfo    *air;
 genericvessel_attachinfo *att;
 genericvessel_arminfo    *arm;
 genericvessel_payinfo    *pay;
};                 
//############################################################################//
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
//============================END OF IMMUTABLE================================//
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
//############################################################################//