//############################################################################//  
//Made in 2005-2013 by Artyom Litvinovich
//Orbiter API constants
//############################################################################// 
unit oapi;
interface
uses sysutils,os_var;
//############################################################################//
const
OAPI_KEY_ESCAPE  =$01;
OAPI_KEY_1    =$02;
OAPI_KEY_2    =$03;
OAPI_KEY_3    =$04;
OAPI_KEY_4    =$05;
OAPI_KEY_5    =$06;
OAPI_KEY_6    =$07;
OAPI_KEY_7    =$08;
OAPI_KEY_8    =$09;
OAPI_KEY_9    =$0A;
OAPI_KEY_0    =$0B;
OAPI_KEY_MINUS  =$0C;  // on main keyboard
OAPI_KEY_EQUALS  =$0D;
OAPI_KEY_BACK   =$0E;  // backspace
OAPI_KEY_TAB   =$0F;
OAPI_KEY_Q    =$10;
OAPI_KEY_W    =$11;
OAPI_KEY_E    =$12;
OAPI_KEY_R    =$13;
OAPI_KEY_T    =$14;
OAPI_KEY_Y    =$15;
OAPI_KEY_U    =$16;
OAPI_KEY_I    =$17;
OAPI_KEY_O    =$18;
OAPI_KEY_P    =$19;
OAPI_KEY_LBRACKET  =$1A;
OAPI_KEY_RBRACKET  =$1B;
OAPI_KEY_RETURN   =$1C;  // Enter on main keyboard
OAPI_KEY_LCONTROL  =$1D;
OAPI_KEY_A    =$1E;
OAPI_KEY_S    =$1F;
OAPI_KEY_D    =$20;
OAPI_KEY_F    =$21;
OAPI_KEY_G    =$22;
OAPI_KEY_H    =$23;
OAPI_KEY_J    =$24;
OAPI_KEY_K    =$25;
OAPI_KEY_L    =$26;
OAPI_KEY_SEMICOLON  =$27;
OAPI_KEY_APOSTROPHE  =$28;
OAPI_KEY_GRAVE   =$29;  // accent grave
OAPI_KEY_LSHIFT   =$2A;
OAPI_KEY_BACKSLASH  =$2B;
OAPI_KEY_Z    =$2C;
OAPI_KEY_X    =$2D;
OAPI_KEY_C    =$2E;
OAPI_KEY_V    =$2F;
OAPI_KEY_B    =$30;
OAPI_KEY_N    =$31;
OAPI_KEY_M    =$32;
OAPI_KEY_COMMA   =$33;
OAPI_KEY_PERIOD   =$34;  // . on main keyboard
OAPI_KEY_SLASH   =$35;  // / on main keyboard
OAPI_KEY_RSHIFT   =$36;
OAPI_KEY_MULTIPLY  =$37;  // * on numeric keypad
OAPI_KEY_LALT   =$38;  // left Alt
OAPI_KEY_SPACE   =$39;
OAPI_KEY_CAPITAL  =$3A;  // caps lock key
OAPI_KEY_F1    =$3B;
OAPI_KEY_F2    =$3C;
OAPI_KEY_F3    =$3D;
OAPI_KEY_F4    =$3E;
OAPI_KEY_F5    =$3F;
OAPI_KEY_F6    =$40;
OAPI_KEY_F7    =$41;
OAPI_KEY_F8    =$42;
OAPI_KEY_F9    =$43;
OAPI_KEY_F10   =$44;
OAPI_KEY_NUMLOCK  =$45;
OAPI_KEY_SCROLL   =$46;  // Scroll lock
OAPI_KEY_NUMPAD7  =$47;
OAPI_KEY_NUMPAD8  =$48;
OAPI_KEY_NUMPAD9  =$49;
OAPI_KEY_SUBTRACT  =$4A;  // - on numeric keypad
OAPI_KEY_NUMPAD4  =$4B;
OAPI_KEY_NUMPAD5  =$4C;
OAPI_KEY_NUMPAD6  =$4D;
OAPI_KEY_ADD   =$4E; // + on numeric keypad
OAPI_KEY_NUMPAD1  =$4F;
OAPI_KEY_NUMPAD2  =$50;
OAPI_KEY_NUMPAD3  =$51;
OAPI_KEY_NUMPAD0  =$52;
OAPI_KEY_DECIMAL  =$53;  // . on numeric keypad
OAPI_KEY_OEM_102  =$56;  // | < > on UK/German keyboards
OAPI_KEY_F11   =$57;
OAPI_KEY_F12   =$58;
OAPI_KEY_NUMPADENTER =$9C;  // Enter on numeric keypad
OAPI_KEY_RCONTROL  =$9D;  // right Control key
OAPI_KEY_DIVIDE   =$B5;  // / on numeric keypad
OAPI_KEY_RALT           =$B8;  // right Alt
OAPI_KEY_HOME           =$C7;  // Home on cursor keypad
OAPI_KEY_UP             =$C8;  // up-arrow on cursor keypad
OAPI_KEY_PRIOR          =$C9;  // PgUp on cursor keypad
OAPI_KEY_LEFT           =$CB;  // left-arrow on cursor keypad
OAPI_KEY_RIGHT          =$CD;  // right-arrow on cursor keypad
OAPI_KEY_END            =$CF;  // End on cursor keypad
OAPI_KEY_DOWN           =$D0;  // down-arrow on cursor keypad
OAPI_KEY_NEXT           =$D1;  // PgDn on cursor keypad
OAPI_KEY_INSERT         =$D2;  // Insert on cursor keypad
OAPI_KEY_DELETE         =$D3;  // Delete on cursor keypad

THGROUP_MAIN=$0;
THGROUP_RETRO=$1;
THGROUP_HOVER=$2;
THGROUP_ATT_PITCHUP=$3;
THGROUP_ATT_PITCHDOWN=$4;
THGROUP_ATT_YAWLEFT=$5;
THGROUP_ATT_YAWRIGHT=$6;
THGROUP_ATT_BANKLEFT=$7;
THGROUP_ATT_BANKRIGHT=$8;
THGROUP_ATT_RIGHT=$9;
THGROUP_ATT_LEFT=$A;
THGROUP_ATT_UP=$B;
THGROUP_ATT_DOWN=$C;
THGROUP_ATT_FORWARD=$D;
THGROUP_ATT_BACK=$E;
THGROUP_USER=$F;

LIFT_VERTICAL=$0;
LIFT_HORIZONTAL=$1;

AIRCTRL_AXIS_AUTO=$0;
AIRCTRL_AXIS_YPOS=$1;
AIRCTRL_AXIS_YNEG=$2;
AIRCTRL_AXIS_XPOS=$3;
AIRCTRL_AXIS_XNEG=$4;

AIRCTRL_ELEVATOR=$0;
AIRCTRL_RUDDER=$1;
AIRCTRL_AILERON=$2;
AIRCTRL_FLAP=$3;
AIRCTRL_ELEVATORTRIM=$4;
AIRCTRL_RUDDERTRIM=$5;
         
COCKPIT_GENERIC=1;
COCKPIT_PANELS =2;
COCKPIT_VIRTUAL=3;

MESHVIS_NEVER   =$00;
MESHVIS_EXTERNAL=$01;
MESHVIS_COCKPIT =$02;
MESHVIS_ALWAYS  =MESHVIS_EXTERNAL+MESHVIS_COCKPIT;
MESHVIS_VC      =$04;
MESHVIS_EXTPASS =$10;

MAXMFD=10;
MFD_LEFT=0;
MFD_RIGHT=  1;
MFD_USER1=  2;
MFD_USER2=  3;
MFD_USER3=  4;
MFD_USER4=  5;
MFD_USER5=  6;
MFD_USER6=  7;
MFD_USER7=  8;
MFD_USER8=  9;

PANEL_LEFT= 0;
PANEL_RIGHT=1;
PANEL_UP=   2;
PANEL_DOWN= 3;
//############################################################################//
//str2okey returns the specified key together with its modifier overlayed in
//the second Byte of the DWORD.
function str2okey(s:string):dword;   
//############################################################################//
implementation
//############################################################################//
function str2okey(s:string):dword;
begin
 result:=0;
 s:=lowercase(trim(s));
 if s='k' then result:=OAPI_KEY_K;
 if s='g' then result:=OAPI_KEY_G;
 if s='0' then result:=(OAPI_KEY_LSHIFT shl 8) or OAPI_KEY_NUMPAD0;
 if s='1' then result:=(OAPI_KEY_LSHIFT shl 8) or OAPI_KEY_NUMPAD1;
 if s='2' then result:=(OAPI_KEY_LSHIFT shl 8) or OAPI_KEY_NUMPAD2;
 if s='3' then result:=(OAPI_KEY_LSHIFT shl 8) or OAPI_KEY_NUMPAD3;
 if s='4' then result:=(OAPI_KEY_LSHIFT shl 8) or OAPI_KEY_NUMPAD4;
 if s='5' then result:=(OAPI_KEY_LSHIFT shl 8) or OAPI_KEY_NUMPAD5;
 if s='6' then result:=(OAPI_KEY_LSHIFT shl 8) or OAPI_KEY_NUMPAD6;
 if s='7' then result:=(OAPI_KEY_LSHIFT shl 8) or OAPI_KEY_NUMPAD7;
 if s='8' then result:=(OAPI_KEY_LSHIFT shl 8) or OAPI_KEY_NUMPAD8;
 if s='9' then result:=(OAPI_KEY_LSHIFT shl 8) or OAPI_KEY_NUMPAD9;
end;
//############################################################################//
begin
end.  
//############################################################################//