//############################################################################//  
//Made in 2005-2013 by Artyom Litvinovich
//OSH vessel generation
//############################################################################// 
unit os_gen;
interface  
uses oapi,os_var;
//############################################################################// 
procedure os_zerodata; 
procedure os_makecleanvess;     
procedure os_copy_xconfig(d_oc:poshdll_config;d_od:pxoshdll_data;s_oc:poshdll_config;s_od:poshdll_data);    
         
function  os_addengine(pos,dir:vec;maxthr:double;phid:integer;isp:double;grp:array of integer):integer; 
    
function  os_addexhaust(th:integer;lscl,wscl:double;pos,rot:vec):integer;

function  os_addfuel(mass:double):integer;

function  os_addmsh(nam:string;vis:dword;off:vec):integer;

function  os_addanim(key:dword;tp:integer;spd,init:double):integer; 
function  os_addanimgrp(n:integer;grs:array of integer):integer;  
function  os_addanimcomp(n,parent:integer;tp,msh,grp:integer;st0,st1,ang:double;ref,axshsc:vec):integer;     
function  os_addvcmode(coff,cdir,cr1,cr2,cr3:vec;n1,n2,n3,n4:integer;hmsh,hgrp:integer;hoff:vec;hsiz:double):integer;  
function  os_addvcmfd(n,tp,nmesh,ngroup:integer):integer;

function  os_addbeacon(shape:dword;pos,col:vec;size,falloff,period,duration,tofs:double;active:boolean):integer;
function  os_adddock(pos,dir,rot:vec):integer;
function  os_addtd(pta,ptb,ptc:vec):integer;
function  os_addair(tp,anim,align,axis:integer;cc,s,a:double;v:vec):integer;   
function  os_addatt(child,loose:integer;range:double;pos,dir,rot:vec;name,id:string):integer;   
function  os_addarm(range_low,range_high:double;seq,grap_seq,grap_attach:integer):integer;  
function  os_addpay(msh,msh_cnt:integer;mass:double;nam,md:string;spd,rot:vec):integer;
                        
function  os_setdefatt(thr:double;phid:integer;isp:double):integer; 
//############################################################################//
implementation  
//############################################################################//
procedure os_copy_xconfig(d_oc:poshdll_config;d_od:pxoshdll_data;s_oc:poshdll_config;s_od:poshdll_data);
var i,j:integer;
begin
 move(s_oc^,d_oc^,sizeof(oshdll_config));
 
 getmem(d_od.prop,s_oc.propcnt*sizeof(oshdll_propinfo));
 getmem(d_od.th,s_oc.thcnt*sizeof(oshdll_thinfo));
 getmem(d_od.msh,s_oc.mshcnt*sizeof(oshdll_mshinfo));
 getmem(d_od.anim,s_oc.anicnt*sizeof(oshdll_animinfo));
 getmem(d_od.exh,s_oc.exhcnt*sizeof(oshdll_exhinfo));
 getmem(d_od.vc,s_oc.vccnt*sizeof(oshdll_vcinfo));
 getmem(d_od.td,s_oc.tdcnt*sizeof(oshdll_tdinfo));
 getmem(d_od.air,s_oc.aircnt*sizeof(oshdll_airinfo));
 getmem(d_od.att,s_oc.attcnt*sizeof(oshdll_attachinfo));
 getmem(d_od.arm,s_oc.armcnt*sizeof(oshdll_arminfo));
 getmem(d_od.beac,s_oc.beaccnt*sizeof(oshdll_beacinfo));
 getmem(d_od.dock,s_oc.dockcnt*sizeof(oshdll_dockinfo));
 getmem(d_od.crew,s_oc.crewcnt*sizeof(oshdll_crewinfo));
 getmem(d_od.pay,s_oc.paycnt*sizeof(oshdll_payinfo));
   
 for i:=0 to s_oc.paycnt-1  do d_od.pay[i] :=s_od.pay[i];
 for i:=0 to s_oc.crewcnt-1 do d_od.crew[i]:=s_od.crew[i];
 for i:=0 to s_oc.dockcnt-1 do d_od.dock[i]:=s_od.dock[i];
 for i:=0 to s_oc.beaccnt-1 do d_od.beac[i]:=s_od.beac[i];
 for i:=0 to s_oc.tdcnt-1   do d_od.td[i]  :=s_od.td[i];
 for i:=0 to s_oc.mshcnt-1  do d_od.msh[i] :=s_od.msh[i];
 for i:=0 to s_oc.exhcnt-1  do d_od.exh[i] :=s_od.exh[i];
 for i:=0 to s_oc.thcnt-1   do d_od.th[i]  :=s_od.th[i];
 for i:=0 to s_oc.aircnt-1  do d_od.air[i] :=s_od.air[i]; 
 for i:=0 to s_oc.attcnt-1  do d_od.att[i] :=s_od.att[i];
 for i:=0 to s_oc.armcnt-1  do d_od.arm[i] :=s_od.arm[i];
 for i:=0 to s_oc.propcnt-1 do d_od.prop[i]:=s_od.prop[i];
 
 for i:=0 to s_oc.vccnt-1 do begin
  d_od.vc[i]:=s_od.vc[i];   
  getmem(d_od.vc[i].mfds,d_od.vc[i].mfdcnt*sizeof(oshdll_vcmfdinfo));
  move(s_od.vc[i].mfds^,d_od.vc[i].mfds^,d_od.vc[i].mfdcnt*sizeof(oshdll_vcmfdinfo));
 end; 
 
 for i:=0 to s_oc.anicnt-1 do begin
  d_od.anim[i]:=s_od.anim[i];

  getmem(d_od.anim[i].comp,s_od.anim[i].compcnt*sizeof(oshdll_animcompinfo));
  move(s_od.anim[i].comp^,d_od.anim[i].comp^,s_od.anim[i].compcnt*sizeof(oshdll_animcompinfo));

  getmem(d_od.anim[i].grp,s_od.anim[i].grpcnt*4);
  for j:=0 to s_od.anim[i].grpcnt-1 do begin
   getmem(d_od.anim[i].grp[j],(s_od.anim[i].grp[j][0]+1)*4);    
   move(s_od.anim[i].grp[j][0],d_od.anim[i].grp[j][0],(s_od.anim[i].grp[j][0]+1)*4);
  end;
 end;
end;
//############################################################################//
procedure os_zerodata;  
begin
 main_cfg.exhcnt:=0;main_cfg.propcnt:=0;main_cfg.thcnt:=0;main_cfg.thgcnt:=0;
 main_cfg.mshcnt:=0;main_cfg.anicnt:=0;main_cfg.vccnt:=0;main_cfg.beaccnt:=0;
 main_cfg.dockcnt:=0;main_cfg.crewcnt:=0;main_cfg.tdcnt:=0;main_cfg.aircnt:=0;
 main_cfg.attcnt:=0;main_cfg.armcnt:=0;main_cfg.paycnt:=0;                
 setlength(main_dat.prop,0);setlength(main_dat.th,0);setlength(main_dat.msh,0);
 setlength(main_dat.anim,0);setlength(main_dat.exh,0);setlength(main_dat.vc,0); 
 setlength(main_dat.beac,0);setlength(main_dat.dock,0);setlength(main_dat.crew,0);
 setlength(main_dat.td,0);setlength(main_dat.air,0);setlength(main_dat.att,0);setlength(main_dat.arm,0);
 setlength(main_dat.pay,0);
 
 main_cfg.crewcnt:=1;
 setlength(main_dat.crew,1);
 main_dat.crew[0].maxcrew:=0;       
 maxcrew:=main_dat.crew[0].maxcrew; 
 main_dat.crew[0].air_pos:=zvec;
 main_dat.crew[0].air_siz:=evec;
 main_dat.crew[0].eva_rot:=tvec(1,0,0);
 main_dat.crew[0].eva_pos:=zvec;
end;
//############################################################################//
procedure os_makecleanvess;  
var i:integer;
begin
 main_cfg.dllnam:='vessel';
 main_cfg.vesnam:='The vessel';

 main_cfg.id:=0;
 main_cfg.size:=1;
 main_cfg.mass:=1000;
 main_cfg.time_spent:=0;
 main_cfg.use_pm:=0;   
 main_cfg.needs_pilot:=0;
 main_cfg.sorted_anims:=0;
 main_cfg.tdp_anim:=-1;

 main_cfg.pmi:=tvec(1,1,1);
 main_cfg.cross:=evec;
 main_cfg.rdrag:=evec;
 main_cfg.defcamera:=zvec;

 main_cfg.frc1:=0.07;main_cfg.frc2:=0.3;main_cfg.cw1:=0.09;main_cfg.cw2:=0.09;
 main_cfg.cw3:=2;main_cfg.cw4:=1.4;main_cfg.transponder:=1;main_cfg.navrcnt:=4;
 main_cfg.albedo:=tdcrgba(1,1,1,1);main_cfg.gravgrad:=0;main_cfg.wingasp:=0;
 main_cfg.wingeff:=0;main_cfg.maxbrakef:=2e5; main_cfg.vislim1:=7.5e-4;
 main_cfg.vislim2:=1.5e-3;main_cfg.vcon:=0;main_cfg.pitchms:=1e-5;main_cfg.bankms:=2e-5;


 for i:=0 to main_cfg.anicnt-1 do begin 
  freemem(main_dat.anim[i].comp);
  freemem(main_dat.anim[i].grp);
 end;  
 for i:=0 to main_cfg.vccnt-1 do freemem(main_dat.vc[i].mfds);
  
 os_zerodata;
end;
//############################################################################//
function os_addengine(pos,dir:vec;maxthr:double;phid:integer;isp:double;grp:array of integer):integer;
var c,i:integer;
begin        
 c:=length(main_dat.th);   
 setlength(main_dat.th,c+1);
                          
 for i:=0 to 7 do main_dat.th[c].grp[i]:=9999;  
 main_dat.th[c].pos:=pos;
 main_dat.th[c].dir:=dir;   
 //main_dat.th[c].lv:=1;   
 main_dat.th[c].maxthr:=maxthr;  
 main_dat.th[c].phid:=phid;
 main_dat.th[c].isp:=isp;
 for i:=0 to min2i(length(grp),8)-1 do begin
  main_dat.th[c].grp[i]:=grp[i];
  if grp[i]+1>main_cfg.thgcnt then main_cfg.thgcnt:=grp[i]+1;
 end;
 main_dat.th[c].ispref:=0;
 main_dat.th[c].pref:=101.4e3;  
 
 main_cfg.thcnt:=c+1;  
 result:=c;
end;                                                        
//############################################################################//
function os_addfuel(mass:double):integer;
var c:integer;
begin        
 c:=length(main_dat.prop);   
 setlength(main_dat.prop,c+1);
 main_dat.prop[c].mass:=mass;  
 
 main_cfg.propcnt:=c+1;  
 result:=c;
end;                                                       
//############################################################################//
function os_addexhaust(th:integer;lscl,wscl:double;pos,rot:vec):integer;overload;
var c:integer;
begin   
 c:=length(main_dat.exh);   
 setlength(main_dat.exh,c+1);
                   
 main_dat.exh[c].tp:=1;
 main_dat.exh[c].th:=th;
 main_dat.exh[c].lscl:=lscl;
 main_dat.exh[c].wscl:=wscl;
 main_dat.exh[c].pos:=pos;
 main_dat.exh[c].rot:=rot;
 
 main_cfg.exhcnt:=c+1;  
 result:=c;       
end;   
//############################################################################//
function os_addmsh(nam:string;vis:dword;off:vec):integer;
var c,i:integer;
begin        
 c:=length(main_dat.msh);   
 setlength(main_dat.msh,c+1);
 for i:=0 to length(nam)-1 do main_dat.msh[c].nam[i]:=nam[i+1];
 main_dat.msh[c].nam[length(nam)]:=#0;
 main_dat.msh[c].vis:=vis; 
 main_dat.msh[c].typ:=0;  
 main_dat.msh[c].off:=off;  
 main_cfg.mshcnt:=c+1;  
 result:=c;
end;  
//############################################################################//
function os_addanim(key:dword;tp:integer;spd,init:double):integer;
var c:integer; 
begin   
 c:=length(main_dat.anim);   
 setlength(main_dat.anim,c+1);
 setlength(anim_st,c+1);

 anim_st[c]:=0;
 
 main_dat.anim[c].rept:=0;
 main_dat.anim[c].trigkey:=key;
 main_dat.anim[c].tp:=tp;
 main_dat.anim[c].status:=-2;
 main_dat.anim[c].spd:=spd;
 main_dat.anim[c].proc:=init;
 main_dat.anim[c].init:=init;  
 main_dat.anim[c].compcnt:=0; 
 main_dat.anim[c].grpcnt:=0;
 main_cfg.anicnt:=c+1;
 result:=c;
end;
//############################################################################//
function os_addanimgrp(n:integer;grs:array of integer):integer;
var c,k,i:integer;
p:pointer;
begin
 k:=length(grs);
 c:=main_dat.anim[n].grpcnt;

 getmem(p,(c+1)*4);
 if main_dat.anim[n].grp<>nil then begin
  move(main_dat.anim[n].grp^,p^,c*4);
  freemem(main_dat.anim[n].grp);
 end;
 main_dat.anim[n].grp:=p;

 
 getmem(main_dat.anim[n].grp[c],(1+k)*4);
 main_dat.anim[n].grp[c][0]:=k;
 for i:=0 to k-1 do main_dat.anim[n].grp[c][1+i]:=grs[i];

 main_dat.anim[n].grpcnt:=c+1;
 result:=c;
end;                                                               
//############################################################################//
function os_addvcmode(coff,cdir,cr1,cr2,cr3:vec;n1,n2,n3,n4:integer;hmsh,hgrp:integer;hoff:vec;hsiz:double):integer;
var c:integer;
begin        
 c:=length(main_dat.vc);   
 setlength(main_dat.vc,c+1);
 main_dat.vc[c].camoff:=coff;
 main_dat.vc[c].camdir:=cdir;
 main_dat.vc[c].camrng[0]:=cr1;
 main_dat.vc[c].camrng[1]:=cr2;
 main_dat.vc[c].camrng[2]:=cr3;
 main_dat.vc[c].nbhs[0]:=n1;
 main_dat.vc[c].nbhs[1]:=n2;
 main_dat.vc[c].nbhs[2]:=n3;
 main_dat.vc[c].nbhs[3]:=n4;
 
 main_dat.vc[c].hudmsh:=hmsh;
 main_dat.vc[c].hudgrp:=hgrp;
 main_dat.vc[c].hudoff:=hoff;
 main_dat.vc[c].hudsiz:=hsiz;

 main_dat.vc[c].mfdcnt:=0;
 
 main_cfg.vccnt:=c+1;  
 result:=c;
end;                                                              
//############################################################################//
function os_addvcmfd(n,tp,nmesh,ngroup:integer):integer;
var c:integer; 
p:pointer;
begin        
 c:=main_dat.vc[n].mfdcnt;

 getmem(p,(c+1)*sizeof(oshdll_vcmfdinfo));
 if main_dat.vc[n].mfds<>nil then begin
  move(main_dat.vc[n].mfds^,p^,c*sizeof(oshdll_vcmfdinfo));
  freemem(main_dat.vc[n].mfds);
 end;
 main_dat.vc[n].mfds:=p;
 
 main_dat.vc[n].mfds[c].tp:=tp;
 main_dat.vc[n].mfds[c].nmesh:=nmesh;
 main_dat.vc[n].mfds[c].ngroup:=ngroup;

 main_dat.vc[n].mfdcnt:=c+1;  
 result:=c;
end;                                                             
//############################################################################//
function os_addbeacon(shape:dword;pos,col:vec;size,falloff,period,duration,tofs:double;active:boolean):integer;
var c:integer;
begin        
 c:=length(main_dat.beac);   
 setlength(main_dat.beac,c+1);
 main_dat.beac[c].bl.shape:=shape; 
 main_dat.beac[c].bl.size:=size; 
 main_dat.beac[c].bl.falloff:=falloff; 
 main_dat.beac[c].bl.period:=period; 
 main_dat.beac[c].bl.duration:=duration; 
 main_dat.beac[c].bl.tofs:=tofs;  
 main_dat.beac[c].bl.active:=active;  
 new(main_dat.beac[c].bl.pos);  
 new(main_dat.beac[c].bl.col);  
 main_dat.beac[c].pos:=pos;  
 main_dat.beac[c].col:=col;  
 
 main_cfg.beaccnt:=c+1;  
 result:=c;
end;                                                               
//############################################################################//
function os_addarm(range_low,range_high:double;seq,grap_seq,grap_attach:integer):integer;
var c:integer;
begin        
 c:=length(main_dat.arm);   
 setlength(main_dat.arm,c+1);
 main_dat.arm[c].range_low:=range_low;
 main_dat.arm[c].range_high:=range_high;
 main_dat.arm[c].seq:=seq;
 main_dat.arm[c].grap_seq:=grap_seq;
 main_dat.arm[c].grap_attach:=grap_attach;
 main_dat.arm[c].tip[0]:=zvec;
 main_dat.arm[c].tip[1]:=zvec;
 main_dat.arm[c].tip[2]:=zvec;
 
 main_cfg.armcnt:=c+1;  
 result:=c;
end;                                                             
//############################################################################//
function os_adddock(pos,dir,rot:vec):integer;
var c:integer;
begin        
 c:=length(main_dat.dock);   
 setlength(main_dat.dock,c+1);
 main_dat.dock[c].pos:=pos;  
 main_dat.dock[c].dir:=dir;  
 main_dat.dock[c].rot:=rot;  
 
 main_cfg.dockcnt:=c+1;  
 result:=c;
end;                                                         
//############################################################################//
function os_addpay(msh,msh_cnt:integer;mass:double;nam,md:string;spd,rot:vec):integer;
var c,i:integer;
begin        
 c:=length(main_dat.pay);   
 setlength(main_dat.pay,c+1);
 main_dat.pay[c].mesh:=msh;
 main_dat.pay[c].mesh_cnt:=msh_cnt;
 main_dat.pay[c].mass:=mass;  
 for i:=0 to length(nam)-1 do main_dat.pay[c].name[i]:=nam[i+1];
 main_dat.pay[c].name[length(nam)]:=#0;
 for i:=0 to length(md)-1 do main_dat.pay[c].module[i]:=md[i+1];
 main_dat.pay[c].module[length(md)]:=#0;
 main_dat.pay[c].speed:=spd;
 main_dat.pay[c].rot_speed:=rot;
 
 main_cfg.paycnt:=c+1;  
 result:=c;
end;                                                           
//############################################################################//
function os_addair(tp,anim,align,axis:integer;cc,s,a:double;v:vec):integer;
var c:integer;
begin         
 c:=length(main_dat.air);   
 setlength(main_dat.air,c+1);
 main_dat.air[c].tp:=tp;  
 main_dat.air[c].anim:=anim;  
 main_dat.air[c].align:=align;  
 main_dat.air[c].axis:=axis;  
 main_dat.air[c].c:=cc;  
 main_dat.air[c].s:=s;  
 main_dat.air[c].a:=a;  
 main_dat.air[c].v:=v;  
 
 main_cfg.aircnt:=c+1;  
 result:=c;
end;                                                     
//############################################################################//
function os_addatt(child,loose:integer;range:double;pos,dir,rot:vec;name,id:string):integer;
var c,i:integer;
begin        
 c:=length(main_dat.att);   
 setlength(main_dat.att,c+1); 
 for i:=0 to length(id)-1 do main_dat.att[c].id[i]:=id[i+1];
 main_dat.att[c].id[length(id)]:=#0;
 for i:=0 to length(name)-1 do main_dat.att[c].name[i]:=name[i+1];
 main_dat.att[c].name[length(name)]:=#0;
 main_dat.att[c].ischild:=child; 
 main_dat.att[c].loose:=loose;  
 main_dat.att[c].range:=range;  
 main_dat.att[c].pos:=pos;  
 main_dat.att[c].dir:=dir;  
 main_dat.att[c].rot:=rot;  
 
 main_cfg.attcnt:=c+1;  
 result:=c;
end;                                                   
//############################################################################//
function os_addtd(pta,ptb,ptc:vec):integer;
var c:integer;
begin        
 c:=length(main_dat.td);   
 setlength(main_dat.td,c+1);
 main_dat.td[c].pta:=pta;  
 main_dat.td[c].ptb:=ptb;  
 main_dat.td[c].ptc:=ptc;  
 
 main_cfg.tdcnt:=c+1;  
 result:=c;
end;      
//############################################################################//
function os_addanimcomp(n,parent:integer;tp,msh,grp:integer;st0,st1,ang:double;ref,axshsc:vec):integer;
var c:integer;
p:pointer;    
begin
 //tp: 0=rotate 1=Translate 2=Scale
 c:=main_dat.anim[n].compcnt;

 getmem(p,(c+1)*sizeof(oshdll_animcompinfo));
 if main_dat.anim[n].comp<>nil then begin
  move(main_dat.anim[n].comp^,p^,c*sizeof(oshdll_animcompinfo));
  freemem(main_dat.anim[n].comp);
 end;
 main_dat.anim[n].comp:=p;
 
 main_dat.anim[n].comp[c].tp:=tp;
 main_dat.anim[n].comp[c].id:=c;
 main_dat.anim[n].comp[c].parent:=parent;
 main_dat.anim[n].comp[c].grp:=grp;
 main_dat.anim[n].comp[c].msh:=msh;
 main_dat.anim[n].comp[c].angle:=ang;
 main_dat.anim[n].comp[c].axshsc:=axshsc;
 main_dat.anim[n].comp[c].ref:=ref;
 main_dat.anim[n].comp[c].st0:=st0;
 main_dat.anim[n].comp[c].st1:=st1;
 main_dat.anim[n].compcnt:=c+1;
 result:=c;
end;
//############################################################################// 
function os_setdefatt(thr:double;phid:integer;isp:double):integer;
begin
 result:=
 os_addengine(tvec(-6, 0.7,-0.4),tvec(0,-1,0),thr,phid,isp,[THGROUP_ATT_BANKLEFT]);
 os_addengine(tvec( 6,-0.7,-0.4),tvec(0, 1,0),thr,phid,isp,[THGROUP_ATT_BANKLEFT]);
 os_addengine(tvec(-6,-0.7,-0.4),tvec(0, 1,0),thr,phid,isp,[THGROUP_ATT_BANKRIGHT]);
 os_addengine(tvec( 6, 0.7,-0.4),tvec(0,-1,0),thr,phid,isp,[THGROUP_ATT_BANKRIGHT]);
 
 os_addengine(tvec(0,0, 15),tvec(0, 1,0),thr,phid,isp,[THGROUP_ATT_PITCHUP  ,THGROUP_ATT_UP]);
 os_addengine(tvec(0,0,-15),tvec(0,-1,0),thr,phid,isp,[THGROUP_ATT_PITCHUP  ,THGROUP_ATT_DOWN]);
 os_addengine(tvec(0,0, 15),tvec(0,-1,0),thr,phid,isp,[THGROUP_ATT_PITCHDOWN,THGROUP_ATT_DOWN]);
 os_addengine(tvec(0,0,-15),tvec(0, 1,0),thr,phid,isp,[THGROUP_ATT_PITCHDOWN,THGROUP_ATT_UP]);
 
 os_addengine(tvec(0,0, 15),tvec( 1,0,0),thr,phid,isp,[THGROUP_ATT_YAWRIGHT,THGROUP_ATT_RIGHT]);
 os_addengine(tvec(0,0,-15),tvec(-1,0,0),thr,phid,isp,[THGROUP_ATT_YAWRIGHT,THGROUP_ATT_LEFT]);
 os_addengine(tvec(0,0, 15),tvec(-1,0,0),thr,phid,isp,[THGROUP_ATT_YAWLEFT ,THGROUP_ATT_LEFT]);
 os_addengine(tvec(0,0,-15),tvec( 1,0,0),thr,phid,isp,[THGROUP_ATT_YAWLEFT ,THGROUP_ATT_RIGHT]);

 os_addengine(tvec( 0,0,0),tvec(0,0,-1),2*thr,phid,isp,[THGROUP_ATT_BACK]);
 os_addengine(tvec( 0,0,0),tvec(0,0, 1),2*thr,phid,isp,[THGROUP_ATT_FORWARD]);
end;     
//############################################################################// 
begin      
end. 
//############################################################################//
