//############################################################################//  
//Made in 2005-2013 by Artyom Litvinovich
//SC3 vessel parser
//############################################################################// 
unit os_sc3_reader;
interface  
uses sysutils,strutils,oapi,os_gen,os_var;
//############################################################################//
function os_readvess_os3(fn,nm:string):boolean;
//############################################################################//
implementation           
//############################################################################//   
const SEC_COUNT=1000; //Max number of [] sections in an ini
//############################################################################//   
type astr=array of string;
type parse_info_rec=record    
 one_str:array[0..255]of char;
 spc:array[0..SEC_COUNT-1]of array[0..255]of char;
 spcs:array[0..SEC_COUNT-1]of integer;
 remains:string;

 w0,w1:boolean;

 meshname,vc_meshname,etc_meshname:string;
 visible,mn,vcmn:integer;
 fuel_mass,isp,main_thrust,retro_thrust,hover_thrust,att_thrust:double;

 men,hen,ren,aen:integer;  
 mfd_l,mfd_r,hud:integer;
 hud_siz:double;
 hud_center:vec;

 off:array[0..4]of vec;
 dir:vec;
 ex_length,ex_width:double;   

 anim_seq_key:string;
 anim_seq_duration,anim_seq_init_pos:double;
 anim_seq_repeat,anim_seq_pause:integer;

 anim_comp_grp:array of integer;
 anim_comp_seq,anim_comp_parent:integer;
 anim_comp_r1,anim_comp_r2,anim_comp_ang:double;                                                     
 anim_comp_typ:string;
 anim_comp_rotp,anim_comp_rotaxis,anim_comp_shift,anim_comp_scale,anim_comp_ref:vec;

 airfoils:array[0..7]of integer;

 cur_dock,cur_pay,cur_att,last_arm:integer;  
 rot_axis,rot_cw,lin_axis,lin_cw:integer;
end;   
pparse_info_rec=^parse_info_rec;  
//############################################################################//   
function vali(par:string):integer;var n:integer;begin val(trim(par),result,n);end;
function vale(par:string):double; var n:integer;begin val(trim(par),result,n);end; 
function strsinsym(s:string;c:char):string;
var i:integer;
b:boolean;
begin
 b:=false;
 result:='';
 for i:=1 to length(s) do if s[i]=c then begin 
  if not b then begin 
   result:=result+c; 
   b:=true;
  end; 
 end else begin 
  b:=false; 
  result:=result+s[i];
 end;
end;       
function getfsymp(st:string;sb:char):integer;
var i:integer;
begin
 result:=0;
 if st<>'' then for i:=1 to length(st) do if (st[i]=sb)or((sb=' ')and(st[i]=#9)) then begin result:=i; exit; end;
end; 
function getnsymp(st:string;sb:char;n:integer):integer;
var i:integer;
begin
 result:=0;
 if st<>'' then for i:=1 to length(st) do if (st[i]=sb)or((sb=' ')and(st[i]=#9)) then begin n:=n-1; if n=0 then begin result:=i; exit; end else continue; end;
end;
function valvec(st:string):vec;
var i,j:integer;
str1,str2,str3:string;
begin    
 st:=strsinsym(st,' ');
 i:=getfsymp(st,',');
 j:=getnsymp(st,',',2);
 if i=0 then i:=getfsymp(st,' ');
 if j=0 then j:=getnsymp(st,' ',2);
 str1:=copy(st,1,i-1);
 str2:=copy(st,i+1,j-i-1);
 str3:=copy(st,j+1,length(st)-j);
 result.x:=vale(trim(str1));
 result.y:=vale(trim(str2));
 result.z:=vale(trim(str3));
end;    
//############################################################################// 
function break_str(s:string):astr;  
var ss:string;
n,pr,c:integer;
begin
 c:=0;
 while c<10 do begin
  pr:=getnsymp(s,';',c);   
  n:=getnsymp(s,';',c+1);   
  if n<=pr then n:=length(s)+1;
  ss:=copy(s,pr+1,n-pr-1);  
  setlength(result,c+1);
  result[c]:=ss;
  c:=c+1;
  if n=length(s)+1 then break;
 end;
end;
//############################################################################// 
//############################################################################// 
procedure applysec(sec:string;p:pparse_info_rec);
var n:integer;
a:astr;
begin 
 a:=nil;  
 if sec='config' then begin
  p.meshname:=trim(AnsiReplaceStr(AnsiReplaceStr(p.meshname,'''',' '),'"',' '));
  p.mn:=os_addmsh(p.meshname,(1-p.visible)*MESHVIS_EXTERNAL+p.visible*MESHVIS_ALWAYS,zvec);
  if(p.fuel_mass<>0)and(p.isp<>0)then begin    
   os_addfuel(p.fuel_mass);
   if p.main_thrust<>0  then p.men:=os_addengine(tvec(0,0,0),tvec(0,0 , 1),p.main_thrust ,0,p.isp,[THGROUP_MAIN]);
   if p.retro_thrust<>0 then p.ren:=os_addengine(tvec(0,0,0),tvec(0,0 ,-1),p.retro_thrust,0,p.isp,[THGROUP_RETRO]);
   if p.hover_thrust<>0 then p.hen:=os_addengine(tvec(0,0,0),tvec(0, 1, 0),p.hover_thrust,0,p.isp,[THGROUP_HOVER]);
   if p.att_thrust<>0   then p.aen:=os_setdefatt(p.att_thrust,0,p.isp);
  end;
 end;
 if sec='vc' then begin
  main_cfg.vcon:=1;     
  p.vc_meshname:=trim(AnsiReplaceStr(AnsiReplaceStr(p.vc_meshname,'''',' '),'"',' '));
  if p.meshname<>p.vc_meshname then p.vcmn:=os_addmsh(p.vc_meshname,MESHVIS_VC,zvec) else p.vcmn:=p.mn;
   
  n:=os_addvcmode(main_cfg.defcamera,tvec(0,0,1),tvec(0,0,0.1),tvec(-0.2,0,0),tvec(0.2,0,0),-1,-1,-1,-1,p.vcmn,p.hud,p.hud_center,p.hud_siz);
  if p.mfd_l<>-1 then os_addvcmfd(n,MFD_LEFT,p.vcmn,p.mfd_l);
  if p.mfd_r<>-1 then os_addvcmfd(n,MFD_RIGHT,p.vcmn,p.mfd_r);
 end;
 if copy(sec,1,8)='ex_main_' then if p.men<>-1 then os_addexhaust(p.men,p.ex_length,p.ex_width,p.off[0],p.dir);
 if copy(sec,1,9)='ex_retro_' then if p.ren<>-1 then os_addexhaust(p.ren,p.ex_length,p.ex_width,p.off[0],p.dir);
 if copy(sec,1,9)='ex_hover_' then if p.hen<>-1 then os_addexhaust(p.hen,p.ex_length,p.ex_width,p.off[0],p.dir);
 if copy(sec,1,7)='ex_att_' then if p.aen<>-1 then begin
  n:=-1;
  if p.rot_axis<>-1 then case p.rot_axis of
   0:case p.rot_cw of
    0:case p.lin_cw of
     -1,0:n:=4;
        1:n:=5;
    end;
    1:case p.lin_cw of
     -1,0:n:=7;
        1:n:=6;
    end;
   end;
   1:case p.rot_cw of
    0:case p.lin_cw of
     -1,0:n:=11;
        1:n:=10;
    end;
    1:case p.lin_cw of
     -1,0:n:=8;
        1:n:=9;
    end;
   end;
   2:case p.rot_cw of
    0:n:=2;
    1:n:=0;
   end;
  end else case p.lin_axis of
   0:case p.lin_cw of
    0:case p.rot_cw of
     -1,0:n:=4;
        1:n:=7;
    end;
    1:case p.rot_cw of
     -1,0:n:=5;
        1:n:=6;
    end;
   end;
   1:case p.lin_cw of
    0:case p.rot_cw of
     -1,0:n:=11;
        1:n:=8;
    end;
    1:case p.rot_cw of
     -1,0:n:=10;
        1:n:=9;
    end;
   end;
   2:case p.lin_cw of
    0:n:=13;
    1:n:=12;
   end; 
  end;
  if n<>-1 then os_addexhaust(p.aen+n,p.ex_length,p.ex_width,p.off[0],p.dir);
 end;
 
 if copy(sec,1,9)='anim_seq_' then begin
  n:=vali(copy(sec,10,length(sec)-1));  
  if n<>main_cfg.anicnt then exit;  
  os_addanim(str2okey(p.anim_seq_key),0,1/max2(1,p.anim_seq_duration),p.anim_seq_init_pos);
  main_dat.anim[n].pause:=p.anim_seq_pause;
  main_dat.anim[n].status:=1;
  main_dat.anim[n].rept:=p.anim_seq_repeat;
 end;
 
 if copy(sec,1,10)='anim_comp_' then begin
  if p.anim_comp_seq>=main_cfg.anicnt then exit;
  n:=-1;
  if p.anim_comp_typ='rotate'      then n:=os_addanimcomp(p.anim_comp_seq,p.anim_comp_parent,0,0,os_addanimgrp(p.anim_comp_seq,p.anim_comp_grp),p.anim_comp_r1,p.anim_comp_r2,p.anim_comp_ang*pi/180,p.anim_comp_rotp,p.anim_comp_rotaxis); 
  if p.anim_comp_typ='rotation'    then n:=os_addanimcomp(p.anim_comp_seq,p.anim_comp_parent,0,0,os_addanimgrp(p.anim_comp_seq,p.anim_comp_grp),p.anim_comp_r1,p.anim_comp_r2,p.anim_comp_ang*pi/180,p.anim_comp_rotp,p.anim_comp_rotaxis); 
  if p.anim_comp_typ='translate'   then n:=os_addanimcomp(p.anim_comp_seq,p.anim_comp_parent,1,0,os_addanimgrp(p.anim_comp_seq,p.anim_comp_grp),p.anim_comp_r1,p.anim_comp_r2,0,zvec,p.anim_comp_shift); 
  if p.anim_comp_typ='translation' then n:=os_addanimcomp(p.anim_comp_seq,p.anim_comp_parent,1,0,os_addanimgrp(p.anim_comp_seq,p.anim_comp_grp),p.anim_comp_r1,p.anim_comp_r2,0,zvec,p.anim_comp_shift); 
  if p.anim_comp_typ='scale'       then n:=os_addanimcomp(p.anim_comp_seq,p.anim_comp_parent,2,0,os_addanimgrp(p.anim_comp_seq,p.anim_comp_grp),p.anim_comp_r1,p.anim_comp_r2,0,p.anim_comp_ref,p.anim_comp_scale); 
  if n<>-1 then begin
   main_dat.anim[p.anim_comp_seq].comp[n].id:=vali(copy(sec,11,1000));
  end;
 end;
 
 if copy(sec,1,8)='payload_' then begin
  if p.etc_meshname<>'' then begin
   p.etc_meshname:=trim(AnsiReplaceStr(AnsiReplaceStr(p.etc_meshname,'''',' '),'"',' '));
   a:=break_str(p.etc_meshname);
   main_dat.pay[p.cur_pay].mesh:=os_addmsh(a[0],MESHVIS_ALWAYS,p.off[0]);
   for n:=1 to length(a)-1 do os_addmsh(a[n],MESHVIS_ALWAYS,p.off[n]);
   main_dat.pay[p.cur_pay].mesh_cnt:=length(a);
  end;
 end;
end; 
//############################################################################// 
procedure ck_airf(p:pparse_info_rec;c:integer);
begin
 if p.airfoils[c]=-1 then case c of                             
  0:p.airfoils[c]:=os_addair(0,-1,LIFT_VERTICAL,0,0,0,0,zvec);  
  1:p.airfoils[c]:=os_addair(0,-1,LIFT_HORIZONTAL,0,0,0,0,zvec);  
  2:p.airfoils[c]:=os_addair(1,-1,AIRCTRL_AILERON,0,0,0,0,zvec); 
  3:p.airfoils[c]:=os_addair(1,-1,AIRCTRL_AILERON,0,0,0,0,zvec); 
  4:p.airfoils[c]:=os_addair(1,-1,AIRCTRL_ELEVATOR,0,0,0,0,zvec);  
  5:p.airfoils[c]:=os_addair(1,-1,AIRCTRL_RUDDER,0,0,0,0,zvec); 
  6:p.airfoils[c]:=os_addair(2,-1,0,0,0,0,0,zvec);       
  7:p.airfoils[c]:=os_addair(1,-1,AIRCTRL_ELEVATORTRIM ,0,0,0,0,zvec); 
 end;
end;
//############################################################################// 
procedure parse_config(p:pparse_info_rec;par:string);
var cog:double;
begin
 if par='meshname' then p.meshname:=p.spc[1];
 if par='size' then main_cfg.size:=vale(p.spc[1]);
 //if par='focus=1
 if par='visible' then p.visible:=vali(p.spc[1]);
 if par='camera' then main_cfg.defcamera:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='empty_mass' then main_cfg.mass:=vale(p.spc[1]);
 if par='fuel_mass' then p.fuel_mass:=vale(p.spc[1]);
 if par='main_thrust' then p.main_thrust:=vale(p.spc[1]);
 if par='retro_thrust' then p.retro_thrust:=vale(p.spc[1]);
 if par='hover_thrust' then p.hover_thrust:=vale(p.spc[1]);
 if par='attitude_thrust' then p.att_thrust:=vale(p.spc[1]);
 if par='isp' then p.isp:=vale(p.spc[1]);
 //if par='trim=2
 if par='pmi' then main_cfg.pmi:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='cw_z_pos' then main_cfg.cw1:=vale(p.spc[1]);
 if par='cw_z_neg' then main_cfg.cw2:=vale(p.spc[1]);
 if par='cw_x' then main_cfg.cw3:=vale(p.spc[1]);
 if par='cw_y' then main_cfg.cw4:=vale(p.spc[1]);
 if par='cross_section' then main_cfg.cross:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='cog' then begin 
  cog:=vale(p.spc[1]);
  main_dat.td[0].pta:=tvec( 0,cog, 1);
  main_dat.td[0].ptb:=tvec(-1,cog,-1);
  main_dat.td[0].ptc:=tvec( 1,cog,-1);
 end;
 if par='pitch_moment_scale' then main_cfg.pitchms:=vale(p.spc[1]);
 if par='bank_moment_scale' then main_cfg.bankms:=vale(p.spc[1]);
 if par='rot_drag' then main_cfg.rdrag:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='wingeffectiveness' then main_cfg.wingeff:=vale(p.spc[1]);

 //if par='att_tex=Exhaust_atrcs
 //if par='main_pstream1=engine
 //if par='hover_pstream1=engine
     
 if par='launch_pt1' then begin p.w0:=true;main_dat.td[0].pta:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='launch_pt2' then begin p.w0:=true;main_dat.td[0].ptb:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='launch_pt3' then begin p.w0:=true;main_dat.td[0].ptc:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
     
 if par='land_pt1' then begin p.w1:=true;main_dat.td[1].pta:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='land_pt2' then begin p.w1:=true;main_dat.td[1].ptb:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='land_pt3' then begin p.w1:=true;main_dat.td[1].ptc:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
end;   
//############################################################################// 
procedure parse_ummu(p:pparse_info_rec;par:string);
begin
 if par='maxseats' then main_dat.crew[0].maxcrew:=vali(p.spc[1]);
 if par='airlock_position' then begin
  main_dat.crew[0].air_pos:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
  main_dat.crew[0].eva_pos:=main_dat.crew[0].air_pos;
 end;
 if par='airlock_size' then main_dat.crew[0].air_siz:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='eva_pos' then main_dat.crew[0].eva_pos:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='eva_rot' then main_dat.crew[0].eva_rot:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
end;   
//############################################################################// 
procedure parse_payload(p:pparse_info_rec;par:string);
var ss:string;
a:astr;
j,i:integer;
begin
 a:=nil;
 if par='meshname' then p.etc_meshname:=p.remains;    
 if par='off' then begin
  a:=break_str(p.remains);
  for i:=0 to length(a)-1 do 
   p.off[i]:=valvec(copy(a[i],2,length(a[i])-2));  
 end;
 if par='name' then begin  
  ss:=trim(AnsiReplaceStr(AnsiReplaceStr(p.spc[1],'''',' '),'"',' '));
  for j:=0 to length(ss)-1 do main_dat.pay[p.cur_pay].name[j]:=ss[j+1];
  main_dat.pay[p.cur_pay].name[length(ss)]:=#0;
 end; 
 if par='module' then begin  
  ss:=trim(AnsiReplaceStr(AnsiReplaceStr(p.spc[1],'''',' '),'"',' '));
  for j:=0 to length(ss)-1 do main_dat.pay[p.cur_pay].module[j]:=ss[j+1];
  main_dat.pay[p.cur_pay].module[length(ss)]:=#0;
 end;
 if par='mass' then main_dat.pay[p.cur_pay].mass:=vale(p.spc[1]);
 if par='speed' then main_dat.pay[p.cur_pay].speed:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='rot_speed' then main_dat.pay[p.cur_pay].rot_speed:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
end;   
//############################################################################// 
procedure parse_vc(p:pparse_info_rec;par:string); 
begin 
 if par='meshname' then p.vc_meshname:=p.spc[1];
 if par='mfd_left' then p.mfd_l:=vali(p.spc[1]);
 if par='mfd_right' then p.mfd_r:=vali(p.spc[1]);
 if par='hud' then p.hud:=vali(p.spc[1]);
 if par='hud_size' then p.hud_siz:=vale(p.spc[1]);
 if par='hud_center' then p.hud_center:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
end;  
//############################################################################// 
procedure parse_aerodynamics(p:pparse_info_rec;par:string);
begin 
 if par='vairfoil_attack' then begin ck_airf(p,0);main_dat.air[p.airfoils[0]].v:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='vairfoil_CHORD'  then begin ck_airf(p,0);main_dat.air[p.airfoils[0]].c:=vale(p.spc[1]);end;
 if par='vairfoil_area'   then begin ck_airf(p,0);main_dat.air[p.airfoils[0]].s:=vale(p.spc[1]);end;
 if par='vairfoil_aspect' then begin ck_airf(p,0);main_dat.air[p.airfoils[0]].a:=vale(p.spc[1]);end;
          
 if par='hairfoil_attack' then begin ck_airf(p,1);main_dat.air[p.airfoils[1]].v:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='hairfoil_CHORD'  then begin ck_airf(p,1);main_dat.air[p.airfoils[1]].c:=vale(p.spc[1]);end;
 if par='hairfoil_area'   then begin ck_airf(p,1);main_dat.air[p.airfoils[1]].s:=vale(p.spc[1]);end;
 if par='hairfoil_aspect' then begin ck_airf(p,1);main_dat.air[p.airfoils[1]].a:=vale(p.spc[1]);end;
     
 if par='aileron_area'   then begin ck_airf(p,2);ck_airf(p,3);main_dat.air[p.airfoils[2]].s:=vale(p.spc[1]);main_dat.air[p.airfoils[3]].s:=main_dat.air[p.airfoils[2]].s;end;
 if par='aileron_lift'   then begin ck_airf(p,2);ck_airf(p,3);main_dat.air[p.airfoils[2]].c:=vale(p.spc[1]);main_dat.air[p.airfoils[3]].c:=main_dat.air[p.airfoils[2]].c;end;
 if par='aileron_attack' then begin ck_airf(p,2);ck_airf(p,3);main_dat.air[p.airfoils[2]].v:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));main_dat.air[p.airfoils[3]].v:=tvec(-vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='aileron_left_anim'   then begin ck_airf(p,2);main_dat.air[p.airfoils[2]].anim:=vali(p.spc[1]);end;
 if par='aileron_right_anim'  then begin ck_airf(p,3);main_dat.air[p.airfoils[3]].anim:=vali(p.spc[1]);end;
     
 if par='elevator_area'   then begin ck_airf(p,4);main_dat.air[p.airfoils[4]].s:=vale(p.spc[1]);end;
 if par='elevator_lift'   then begin ck_airf(p,4);main_dat.air[p.airfoils[4]].c:=vale(p.spc[1]);end;
 if par='elevator_attack' then begin ck_airf(p,4);main_dat.air[p.airfoils[4]].v:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='elevator_anim'   then begin ck_airf(p,4);main_dat.air[p.airfoils[4]].anim:=vali(p.spc[1]);end;
     
 if par='rudder_area'   then begin ck_airf(p,5);main_dat.air[p.airfoils[5]].s:=vale(p.spc[1]);end;
 if par='rudder_lift'   then begin ck_airf(p,5);main_dat.air[p.airfoils[5]].c:=vale(p.spc[1]);end;
 if par='rudder_attack' then begin ck_airf(p,5);main_dat.air[p.airfoils[5]].v:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='rudder_anim'   then begin ck_airf(p,5);main_dat.air[p.airfoils[5]].anim:=vali(p.spc[1]);end;
     
 if par='speedbrake_DRAG'   then begin ck_airf(p,6);main_dat.air[p.airfoils[6]].c:=vale(p.spc[1]);end;
 if par='speedbrake_attack' then begin ck_airf(p,6);main_dat.air[p.airfoils[6]].v:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='speedbrake_anim'   then begin ck_airf(p,6);main_dat.air[p.airfoils[6]].anim:=vali(p.spc[1]);end;

 if par='elevator_trim_area'   then begin ck_airf(p,7);main_dat.air[p.airfoils[7]].s:=vale(p.spc[1]);end;
 if par='elevator_trim_lift'   then begin ck_airf(p,7);main_dat.air[p.airfoils[7]].c:=vale(p.spc[1]);end;
 if par='elevator_trim_attack' then begin ck_airf(p,7);main_dat.air[p.airfoils[7]].v:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='elevator_trim_anim'   then begin ck_airf(p,7);main_dat.air[p.airfoils[7]].anim:=vali(p.spc[1]);end;
end;    
//############################################################################// 
procedure parse_exhaust(p:pparse_info_rec;par:string);
begin 
 if par='off' then p.off[0]:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='dir' then p.dir:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='length' then p.ex_length:=vale(p.spc[1]);
 if par='width' then p.ex_width:=vale(p.spc[1]);
 if par='rot_axis' then begin 
  if lowercase(p.spc[1])='x' then p.rot_axis:=0;
  if lowercase(p.spc[1])='y' then p.rot_axis:=1;
  if lowercase(p.spc[1])='z' then p.rot_axis:=2;
 end;  
 if par='lin_axis' then begin 
  if lowercase(p.spc[1])='x' then p.lin_axis:=0;
  if lowercase(p.spc[1])='y' then p.lin_axis:=1;
  if lowercase(p.spc[1])='z' then p.lin_axis:=2;
 end;
 if par='rot_cw' then p.rot_cw:=vali(p.spc[1]);
 if par='lin_cw' then p.lin_cw:=vali(p.spc[1]);
end;   
//############################################################################// 
procedure parse_dock(p:pparse_info_rec;par:string);
begin 
 if par='pos' then main_dat.dock[p.cur_dock].pos:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='dir' then main_dat.dock[p.cur_dock].dir:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='rot' then main_dat.dock[p.cur_dock].rot:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
end;    
//############################################################################// 
procedure parse_arm(p:pparse_info_rec;par:string);
var j,i:integer;
ss:string;
begin 
 //if par='pos' then begin main_dat.dock[cur_dock].pos:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));continue;end;
 //if par='dir' then begin main_dat.dock[cur_dock].dir:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));continue;end;
 //if par='rot' then begin main_dat.dock[cur_dock].rot:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));continue;end;
 if copy(par,1,6)='joint_' then begin
  i:=vali(copy(par,7,1));
  if i>p.last_arm then begin
   for j:=p.last_arm to i-1 do os_addarm(0,180,0,-1,-1);
   p.last_arm:=i;
  end;
  if copy(par,8,1000)='_name' then begin  
   ss:=trim(AnsiReplaceStr(AnsiReplaceStr(p.spc[1],'''',' '),'"',' '));
   for j:=0 to length(ss)-1 do main_dat.arm[i].name[j]:=ss[j+1];
   main_dat.arm[i].name[length(ss)]:=#0;
  end;
  if copy(par,8,1000)='_seq' then main_dat.arm[i].seq:=vali(p.spc[1]);
  if copy(par,8,1000)='_range' then begin main_dat.arm[i].range_low:=vale(p.spc[1]);main_dat.arm[i].range_high:=vale(p.spc[2]);end;
 end; 
 if par='grap_seq' then begin if main_cfg.armcnt=0 then exit; main_dat.arm[0].grap_seq:=vali(p.spc[1]);end;
 if par='grap_attach' then begin 
  if main_cfg.armcnt=0 then exit; 
  main_dat.arm[0].grap_attach:=vali(p.spc[1]);
  i:=-1;
  for j:=0 to main_cfg.attcnt-1 do if main_dat.att[j].ischild=0 then begin
   i:=i+1;
   if main_dat.arm[0].grap_attach=i then begin main_dat.arm[0].grap_attach:=j;break;end;
  end;
 end;
end;     
//############################################################################// 
procedure parse_attach(p:pparse_info_rec;par:string);
var i,j:integer;
ss:string;
begin 
 if par='pos'   then main_dat.att[p.cur_att].pos:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='dir'   then main_dat.att[p.cur_att].dir:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='rot'   then main_dat.att[p.cur_att].rot:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 if par='id'    then begin  
  ss:=trim(AnsiReplaceStr(AnsiReplaceStr(p.spc[1],'''',' '),'"',' '));
  i:=length(ss);
  for j:=0 to i-1 do main_dat.att[p.cur_att].id[j]:=ss[j+1];
  main_dat.att[p.cur_att].id[i]:=#0;
 end;
 if par='name'    then begin  
  ss:=trim(AnsiReplaceStr(AnsiReplaceStr(p.spc[1],'''',' '),'"',' '));
  i:=length(ss);
  for j:=0 to i-1 do main_dat.att[p.cur_att].name[j]:=ss[j+1];
  main_dat.att[p.cur_att].name[i]:=#0;
 end;
 if par='loose' then main_dat.att[p.cur_att].loose:=vali(p.spc[1]);
 if par='range' then main_dat.att[p.cur_att].range:=vale(p.spc[1]);
end;     
//############################################################################// 
procedure parse_anim_comp(p:pparse_info_rec;par:string);
var i,n:integer;
begin 
 if copy(par,1,4)='tip_' then begin
  if p.last_arm=-1 then exit;     
  i:=vali(copy(par,5,1));
  if(i<1)or(i>3)then exit;
  main_dat.arm[0].tip[i-1]:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));
 end;
 if par='seq' then p.anim_comp_seq:=vali(p.spc[1]);
 if par='groups' then begin
  n:=0;
  for i:=1 to 50 do if p.spcs[i]<>0 then n:=n+1;
  setlength(p.anim_comp_grp,n);
  for i:=0 to n-1 do p.anim_comp_grp[i]:=vali(p.spc[i+1]);
 end;
 if par='range'    then begin p.anim_comp_r1:=vale(p.spc[1]);p.anim_comp_r2:=vale(p.spc[2]);end;
 if par='rot_pnt'  then begin p.anim_comp_rotp:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='rot_axis' then begin p.anim_comp_rotaxis:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='angle'    then begin p.anim_comp_ang:=vale(p.spc[1]);end;
 if par='type'     then begin p.anim_comp_typ:=lowercase(p.spc[1]);end;
 if par='shift'    then begin p.anim_comp_shift:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='scale'    then begin p.anim_comp_scale:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='ref'      then begin p.anim_comp_ref:=tvec(vale(p.spc[1]),vale(p.spc[2]),vale(p.spc[3]));end;
 if par='parent'   then begin p.anim_comp_parent:=vali(p.spc[1]);end;
end;      
//############################################################################// 
procedure parse_anim_seq(p:pparse_info_rec;par:string);
begin 
 if par='key'      then p.anim_seq_key:=p.spc[1];
 if par='duration' then p.anim_seq_duration:=vale(p.spc[1]);
 if par='init_pos' then p.anim_seq_init_pos:=vale(p.spc[1]);
 if par='repeat'   then p.anim_seq_repeat:=vali(p.spc[1]);
 if par='pause'    then p.anim_seq_pause:=vali(p.spc[1]);
end;    
//############################################################################// 
procedure start_section(p:pparse_info_rec;var sec:string);
var s:string;
i:integer;
begin
 s:=trim(p.one_str);
 s:=copy(s,2,length(s)-2);
 applysec(sec,p);
 sec:=lowercase(s);   
    
 p.cur_dock:=-1;  
 p.cur_pay:=-1;    
 if copy(sec,1,5)='dock_' then p.cur_dock:=os_adddock(zvec,zvec,zvec);
 if copy(sec,1,8)='payload_' then  p.cur_pay:=os_addpay(0,0,1,'','',zvec,zvec);
 p.cur_att:=-1;
 if(copy(sec,1,13)='child_attach_') then p.cur_att:=os_addatt(1,0,0,zvec,zvec,zvec,'','');
 if(copy(sec,1,14)='parent_attach_')then p.cur_att:=os_addatt(0,0,0,zvec,zvec,zvec,'','');
 if sec='ummu' then begin
  main_cfg.crewcnt:=1;
  setlength(main_dat.crew,1);
 end;
    
 p.visible:=0;p.mfd_l:=-1;p.mfd_r:=-1;p.hud:=-1;
 p.hud_siz:=0;
 p.hud_center:=tvec(0,0,0);
 for i:=0 to length(p.off)-1 do p.off[i]:=zvec;
 p.dir:=tvec(0,0,0);
 p.fuel_mass:=0;p.isp:=0;p.main_thrust:=0;p.retro_thrust:=0;p.hover_thrust:=0;p.att_thrust:=0;p.ex_width:=0;p.ex_length:=0;    
 p.anim_seq_key:='';
 p.anim_seq_duration:=0;p.anim_seq_init_pos:=0;
    
 setlength(p.anim_comp_grp,0);
 p.anim_comp_seq:=0;
 p.anim_comp_r1:=0;p.anim_comp_r2:=1;p.anim_comp_ang:=0;    
 p.anim_seq_pause:=0; 
 p.anim_seq_repeat:=0;
 p.anim_comp_parent:=-1;                                        
 p.anim_comp_typ:='rotation';
 p.anim_comp_rotp:=tvec(0,0,0);p.anim_comp_rotaxis:=tvec(0,0,0);p.anim_comp_shift:=tvec(0,0,0);p.anim_comp_scale:=tvec(0,0,0);p.anim_comp_ref:=tvec(0,0,0);
 p.lin_axis:=-1;
 p.rot_axis:=-1;
 p.rot_cw:=-1;
 p.lin_cw:=-1;

 p.etc_meshname:=''; 
end;
//############################################################################// 
function readtlnc(p:pparse_info_rec;buf:pchara;bs:integer;var bp:integer):integer;
var c:char;
begin
 p.one_str[0]:=#0;
 result:=0;
 while bp<bs do begin
  c:=buf[bp];                
  bp:=bp+1;
  if c=#10 then exit;
  if c<>#13 then begin p.one_str[result]:=c;p.one_str[result+1]:=#0;result:=result+1;end;
 end;
end;
//############################################################################// 
procedure break_section(p:pparse_info_rec;cs:integer);
var j,k:integer;  
l:boolean;    
c:char;  
begin
 k:=0;
 l:=true; 
 for j:=0 to SEC_COUNT-1 do p.spcs[j]:=0;
 for j:=0 to cs-1 do begin
  c:=p.one_str[j];
  if(c='=')or(c=',')or(c=')')then begin
   if c='=' then p.remains:=copy(trim(p.one_str),j+2,1000);
   if not l then begin p.spc[k][p.spcs[k]]:=#0;k:=k+1;end;
   l:=true;
   continue;
  end; 
  if c=';' then break; 
  if(c<>'(')and(c<>')')then begin
   p.spc[k][p.spcs[k]]:=c;
   p.spcs[k]:=p.spcs[k]+1;
   p.spc[k][p.spcs[k]]:=#0;
  end;      
  l:=false;
 end;  
end;
//############################################################################//     
//Clean up the data block, fill it with blank vessel, clean parse record
procedure start_vess(p:pparse_info_rec;nm:string);
var i:integer;
begin
 //Clean up the data block, fill it with blank vessel
 os_makecleanvess; 
 
 for i:=0 to length(p.airfoils)-1 do p.airfoils[i]:=-1;
 main_cfg.sorted_anims:=1;
 
 //Touchdown points
 os_addtd(tvec(0,0,1),tvec(-1,0,-1),tvec(1,0,-1));
 os_addtd(tvec(0,0,1),tvec(-1,0,-1),tvec(1,0,-1));
 p.w0:=false;
 p.w1:=false;
 
 move(nm[1],main_cfg.dllnam[0],length(nm));
 move(nm[1],main_cfg.vesnam[0],length(nm));
 main_cfg.vesnam[length(nm)]:=#0;
 main_cfg.dllnam[length(nm)]:=#0;   
                    
 p.meshname:='';p.vc_meshname:='';p.etc_meshname:='';
 p.men:=-1;p.hen:=-1;p.ren:=-1;p.aen:=-1;
 
 p.cur_dock:=0;
 p.cur_pay:=0;
 p.cur_att:=0;  
 p.last_arm:=-1;
end;
//############################################################################// 
function os_readvess_os3(fn,nm:string):boolean;
var f:vfile;
buf:pchara;
bs,bp:integer;

sec,par,prop:string; 
sec_count:integer;  

p:parse_info_rec;
begin
 result:=false;
 //Clean up the data block, fill it with blank vessel, clean parse record
 start_vess(@p,nm); 
 sec:='';
 par:='';
 prop:='';   

 //Read the file
 if vfopen(f,fn,1)<>VFERR_OK then exit; 
 bs:=vffilesize(f);
 bp:=0;
 getmem(buf,bs);
 vfread(f,buf,bs);
 vfclose(f);
 
 repeat
  sec_count:=readtlnc(@p,buf,bs,bp);  
  case p.one_str[0] of
   '[':start_section(@p,sec);
   ';':continue;
   #0:continue;
   else begin   
    break_section(@p,sec_count);
    par:=trim(lowercase(p.spc[0]));
   
    if sec='config' then begin parse_config(@p,par);continue;end;
    if sec='vc' then begin parse_vc(@p,par);continue;end;             
    if sec='ummu' then begin parse_ummu(@p,par);continue;end;
    if sec='aerodynamics' then begin parse_aerodynamics(@p,par);continue;end;
    if(copy(sec,1,8)='ex_main_')or(copy(sec,1,9)='ex_retro_')or(copy(sec,1,9)='ex_hover_')or(copy(sec,1,7)='ex_att_') then begin parse_exhaust(@p,par);continue;end;     
    if copy(sec,1,5)='dock_' then begin parse_dock(@p,par);continue;end;
    if copy(sec,1,11)='robotic_arm' then begin parse_arm(@p,par);continue;end;      
    if copy(sec,1,9)='anim_seq_' then begin parse_anim_seq(@p,par);continue;end;
    if(copy(sec,1,13)='child_attach_')or(copy(sec,1,14)='parent_attach_')then begin parse_attach(@p,par);continue;end;      
    if copy(sec,1,10)='anim_comp_' then begin parse_anim_comp(@p,par);continue;end;           
    if copy(sec,1,8)='payload_' then begin parse_payload(@p,par);continue;end;     
   end;
  end;
 until bp>=bs; 

 //Touchdown points:  
 if p.w0 and not p.w1 then begin
  main_dat.td[1].pta:=main_dat.td[0].pta;
  main_dat.td[1].ptb:=main_dat.td[0].ptb;
  main_dat.td[1].ptc:=main_dat.td[0].ptc;
 end;  
 if p.w1 and not p.w0 then begin
  main_dat.td[0].pta:=main_dat.td[1].pta;
  main_dat.td[0].ptb:=main_dat.td[1].ptb;
  main_dat.td[0].ptc:=main_dat.td[1].ptc;
 end;
 
 //Apply incomplete last section
 applysec(sec,@p);

 freemem(buf);
 result:=true;
end;
//############################################################################// 
begin      
end. 
//############################################################################//
