package portablesimulator;

import portablesimulator.skillset.SkillSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import portablesimulator.csv.PSSession;

public final class PSArmorSet implements Comparable {

    public PSArmorSet() {
    }

    public PSArmorSet makeSetCopy() {
        PSArmorSet obj = new PSArmorSet();
        obj.listItems.addAll(listItems);
        obj.mysetNumber = mysetNumber;
        obj.mysetName = mysetName;
        obj.weaponSlotCount = weaponSlotCount;
        obj.session = this.session.makeCopy();
        obj.calculateUseList(null, false);
        obj.targetSkills = new SkillSet();
        obj.targetSkills.set_all(this.targetSkills);

        return obj;
    }

    public void calculateUseList(SkillSet skills, boolean useMaskedSkill) {
        bodyCopieCount = 0;
        defMax = 0;
        defInitial = 0;
        totalSlotCount = 0;
        shellFire = 0; //Αϐ
        shellWater = 0; //ϐ
        shellIce = 0; //Xϐ
        shellThunder = 0; //ϐ
        shellDragon = 0; //
        if (skills != null) {
            if (useMaskedSkill) {
                skills.initWithColumn(listItems.get(0).maskedSkills);
            }else {
                skills.clear();
            }
        }

        PSWrap body = listItems.get(PSItemType.TYPE_BODY);
        if (body.item.isVirtual && body.virtualList != null) {
            PSWrap seek = null;
            for (int x = 0; x < body.virtualList.size(); ++ x) {
                PSWrap internal = body.virtualList.get(x);
                if (seek == null || internal.item.defMax > seek.item.defMax) {
                    seek = internal;
                }
            }
            if (seek != null) {
                body = seek;
                if (body.maskedSkills == null) {
                    body.maskedSkills = new SkillSet();
                }
            }
        }

        for (int i = 0; i < listItems.size(); ++i) {
            PSWrap wrap = listItems.get(i);
            boolean fromVirtual = false;
            if (wrap.item.isVirtual && wrap.virtualList != null) {
                PSWrap seek = null;
                for (int x = 0; x < wrap.virtualList.size(); ++ x) {
                    PSWrap internal = wrap.virtualList.get(x);
                    if (seek == null || internal.item.defMax > seek.item.defMax) {
                        seek = internal;
                    }
                }
                if (seek != null) {
                    wrap = seek;
                    fromVirtual = true;
                    if (wrap.maskedSkills == null) {
                        wrap.maskedSkills = new SkillSet();
                    }
                }
            }
            PSItem item = wrap.item;

            //System.out.println("PART " + armor.maskedSkills);

            defMax += item.defMax;
            defInitial += item.defInitial;
            if (fromVirtual == false) {
                shellFire += item.shellFire; //Αϐ
                shellWater += item.shellWater; //ϐ
                shellIce += item.shellIce; //Xϐ
                shellThunder += item.shellThunder; //ϐ
                shellDragon += item.shellDragon; //
            }
            totalSlotCount += item.slotCount;

            if (item.isCopieSkill) {
                wrap = body;
                item = wrap.item;
                bodyCopieCount++;
            }

            if (skills != null && fromVirtual == false) {
                if (useMaskedSkill && wrap != null && wrap.maskedSkills != null) {
                    skills.sum_fixed(wrap.maskedSkills);
                } else {
                    skills.sum_all(item.skills);
                }
            }
        }
    }

    public int createChildSet(boolean onlyCharm, TreeSet<PSArmorSet> already, Collection<PSArmorSet> list) {
        int count = 0;
        ArrayList<PSWrap> newSet = new ArrayList<PSWrap>(listItems.size());

        for (int i = 0; i < listItems.size(); ++i) {
            if (onlyCharm) {
                if (i != PSItemType.TYPE_CHARM) {
                    continue;
                }
            }
            newSet.clear();
            newSet.addAll(listItems);

            List<PSWrap> childI = listItems.get(i).childArmors;
            for (int n = 0; n < childI.size(); ++n) {
                newSet.set(i, childI.get(n));
                PSArmorSet newSetObj = makeSetCopy();
                newSetObj.listItems.clear();
                newSetObj.listItems.addAll(newSet);
                newSetObj.calculateUseList(null, true);
                if (already.contains(newSetObj)) {
                    continue;
                }
                list.add(newSetObj);
                already.add(newSetObj);
                count++;
            }
        }
        return count;
    }

    public void drawArmorSets(List<PSArmorSet> listList, boolean searchMatome, boolean searchCharmMatome) {
        MatrixBuilder matrix = new MatrixBuilder();
        for (PSWrap item : listItems) {
            ArrayList<PSWrap> list = new ArrayList<PSWrap>();
            if (item.item.itemType == PSItemType.TYPE_CHARM) {
                if (searchCharmMatome) {
                    /* if (item.charmGroup != null) {
                        for (PSWrap same : item.charmGroup) {
                            list.add(same);
                        }
                    }else*/ {
                        list.add(item);
                    }
                    if (item.sameArmors != null) {
                        for (PSWrap same : item.sameArmors) {
                            list.add(same);
                        }
                    }
                }else {
                    if (item.charmGroup != null) {
                        for (PSWrap same : item.charmGroup) {
                            list.add(same);
                        }
                    }else {
                        list.add(item);
                    }
                    if (item.sameArmors != null) {
                        for (PSWrap same : item.sameArmors) {
                            list.add(same);
                        }
                    }
                }
            } else if(searchMatome) {
                list.add(item);
                for (PSWrap same : item.sameArmors) {
                    list.add(same);
                }
            } else if (item.item.isVirtual == false) {
                list.add(item);
                for (PSWrap same : item.sameArmors) {
                    list.add(same);
                }
            } else {
                if (item.item.isVirtualNone) {
                    list.add(item);
                }
                if (item.virtualList != null) {
                    list.addAll(item.virtualList);
                }
                for (PSWrap same : item.sameArmors) {
                    list.add(same);
                }
            }
            matrix.addColumn(list);
        }
        matrix.start();

        //TODO cache to class field ?
        List<PSWrap> fetch = new ArrayList<PSWrap>(listItems.size());

        while (matrix.hasNext()) {
            fetch.clear();
            matrix.next(fetch);

            PSArmorSet set = makeSetCopy();
            set.listItems.clear();
            for (PSWrap item : fetch) {
                set.listItems.add(item);
            }
            set.calculateUseList(null, false);
            listList.add(set);
        }
    }

    public String getShellValuesAsText() {
        int shellTotal = shellFire + shellWater + shellIce + shellThunder + shellDragon;
        return "[" + shellFire + "] "
                + "[" + shellWater + "] "
                + "X[" + shellIce + "] "
                + "[" + shellThunder + "] "
                + "[" + shellDragon + "] "
                + "v[" + shellTotal + "]";
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(String.valueOf(defMax));
        str.append("[");
        str.append(String.valueOf(weaponSlotCount));
        str.append("]");
        for (int i = 0; i < listItems.size(); ++i) {
            str.append(",");
            str.append(listItems.get(i).item.getArmorNameAndSlot());
        }
        str.append(",");
        str.append(getShellValuesAsText());
        return str.toString();
    }
    public int weaponSlotCount = 0;
    public int totalSlotCount = 0;
    public int shellFire = 0; //Αϐ
    public int shellWater = 0; //ϐ
    public int shellIce = 0; //Xϐ
    public int shellThunder = 0; //ϐ
    public int shellDragon = 0; //
    public int bodyCopieCount;
    public final ArrayList<PSWrap> listItems = new ArrayList<PSWrap>();
    public SkillSet targetSkills;
    public int defMax;
    public int defInitial;
    public int mysetNumber = -1;
    public String mysetName = null;
    public String mysetPicturePath = null;
    public PSSession session = new PSSession();

    public int hashCode() {
        int x = 0;
        for(int i = 0; i < listItems.size(); ++ i) {
            x += listItems.get(i).hashCode();
        }
        return x;
    }

    public int compareTo(Object o) {
        PSArmorSet set = (PSArmorSet) o;
        int x,y ;
        PSWrap a1;
        PSWrap a2;

        if (set == this) {
            return 0;
        }

        if (set.defMax == this.defMax) {
            for (int i = 0; i < this.listItems.size(); ++i) {
                a1 = this.listItems.get(i);
                a2 = set.listItems.get(i);

                if (a1 == a2) {
                    continue;
                }

                x = a1.compareTo(a2);

                if (x != 0) {
                    return x;
                }
            }
            return 0;
        }else if (set.defMax > this.defMax) {
            return 1;
        }else {
            return -1;
        }
    }

    public boolean equals(Object o) {
        if (compareTo(o) == 0) {
            return true;
        }
        return false;
    }
}
