package portablesimulator.charm;

import java.util.ArrayList;
import portablesimulator.csv.Repository;
import portablesimulator.skillset.SkillKind;
import portablesimulator.skillset.SkillSet;

public class Charm {
    public Charm(int stone, int tableNumber, String type, int slotCount, SkillKind kind1, int point1, SkillKind kind2, int point2) {
        this.stone = stone;
        this.tableNumber = tableNumber;
        this.name = type.intern();
        this.slotCount = slotCount;
        this.skills = new SkillSet(2);
        if (kind1 != null) {
            skills.set(kind1, point1, true);
        }
        if (kind2 != null) {
            skills.set(kind2, point2, true);
        }
    }

    public String toString() {
        String strStone = stoneName.get(stone);
        return name + " T" + tableNumber + "[" + slotCount + "]" + skills + "(" + strStone + ")";
    }

    public static final int STONE_NAZO = 0;
    public static final int STONE_HIKAR = 1;
    public static final int STONE_FURUI = 2;
   
    static final ArrayList<String> stoneName = new ArrayList<String>();

    static void init() {
        stoneName.add("Ȃ̂");
        stoneName.add("邨");
        stoneName.add("Âт");
        if (Repository.getResource().existCharmG()) {
            stoneName.add("");
        }
    };

    public final int stone;
    public final int tableNumber;
    public final String name;
    public final int slotCount;
    public final SkillSet skills;
}
