package portablesimulator.csv;

import java.io.FileNotFoundException;
import portablesimulator.skillset.SkillPoint;
import portablesimulator.skillset.SkillKind;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import portablesimulator.PSItem;
import portablesimulator.PSItemMaterial;
import portablesimulator.PSItemType;
import portablesimulator.skillset.SkillCategories;
import portablesimulator.skillset.SkillSet;

class MH3GDataIO {

    public MH3GDataIO() {
    }

    public void writeUserData() throws IOException {
        PSBaseItems base = Repository.getBaseItems();

        writeUserEquipmentCSV(PSItemType.TYPE_HEAD, "data_mh3g/MH3EQUIP_USER_HEAD.csv", base.listUserEquipHead);
        writeUserEquipmentCSV(PSItemType.TYPE_BODY, "data_mh3g/MH3EQUIP_USER_BODY.csv", base.listUserEquipBody);
        writeUserEquipmentCSV(PSItemType.TYPE_ARM,  "data_mh3g/MH3EQUIP_USER_ARM.csv", base.listUserEquipArm);
        writeUserEquipmentCSV(PSItemType.TYPE_WEIST,"data_mh3g/MH3EQUIP_USER_WEIST.csv", base.listUserEquipWeist);
        writeUserEquipmentCSV(PSItemType.TYPE_LEG,  "data_mh3g/MH3EQUIP_USER_LEG.csv", base.listUserEquipLeg);
        writeUserDecorationCSV(PSItemType.TYPE_DECORATION, "data_mh3g/MH3DECO_USER.csv", base.listUserDecoration);

        writeUserEquipmentCSV(PSItemType.TYPE_HEAD, "data_mh3g/MH3EQUIP_TRASH_HEAD.csv", base.listTrashEquipHead);
        writeUserEquipmentCSV(PSItemType.TYPE_BODY, "data_mh3g/MH3EQUIP_TRASH_BODY.csv", base.listTrashEquipBody);
        writeUserEquipmentCSV(PSItemType.TYPE_ARM,  "data_mh3g/MH3EQUIP_TRASH_ARM.csv", base.listTrashEquipArm);
        writeUserEquipmentCSV(PSItemType.TYPE_WEIST,"data_mh3g/MH3EQUIP_TRASH_WEIST.csv", base.listTrashEquipWeist);
        writeUserEquipmentCSV(PSItemType.TYPE_LEG,  "data_mh3g/MH3EQUIP_TRASH_LEG.csv", base.listTrashEquipLeg);
        writeUserDecorationCSV(PSItemType.TYPE_DECORATION, "data_mh3g/MH3DECO_TRASH.csv", base.listTrashDecoration);

        writeUserEquipmentCSV(PSItemType.TYPE_HEAD, "data_mh3g/MH3EQUIP_HEAD_MERGE.csv", base.listEquipHead);
        writeUserEquipmentCSV(PSItemType.TYPE_BODY, "data_mh3g/MH3EQUIP_BODY_MERGE.csv", base.listEquipBody);
        writeUserEquipmentCSV(PSItemType.TYPE_ARM,  "data_mh3g/MH3EQUIP_ARM_MERGE.csv", base.listEquipArm);
        writeUserEquipmentCSV(PSItemType.TYPE_WEIST,"data_mh3g/MH3EQUIP_WEIST_MERGE.csv", base.listEquipWeist);
        writeUserEquipmentCSV(PSItemType.TYPE_LEG,  "data_mh3g/MH3EQUIP_LEG_MERGE.csv", base.listEquipLeg);
        writeUserDecorationCSV(PSItemType.TYPE_DECORATION, "data_mh3g/MH3DECO_MERGE.csv", base.listDecoration);

        writeCharmCSVFile(PSItemType.TYPE_CHARM, "data_mh3g/CHARM.csv", Repository.getBaseItems().listCharm);
    }

    public void readAll() throws IOException {
        readSkillsCSV("data_mh3g/MH3SKILL.csv");
        readSkillCategories("data_mh3g/conf/CATEGORY.txt");
        readSkillFukugo("data_mh3g/conf/FUKUGO.txt");

        ArrayList<PSItem> listEquipHead = new ArrayList<PSItem>();
        ArrayList<PSItem> listEquipBody = new ArrayList<PSItem>();
        ArrayList<PSItem> listEquipArm = new ArrayList<PSItem>();
        ArrayList<PSItem> listEquipWeist = new ArrayList<PSItem>();
        ArrayList<PSItem> listEquipLeg = new ArrayList<PSItem>();

        ArrayList<PSItem> listUserEquipHead = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipBody = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipArm = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipWeist = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserEquipLeg = new ArrayList<PSItem>();

        ArrayList<PSItem> listTrashEquipHead = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipBody = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipArm = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipWeist = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashEquipLeg = new ArrayList<PSItem>();

        readEquipmentCSV(PSItemType.TYPE_HEAD, "data_mh3g/MH3EQUIP_HEAD.csv", listEquipHead);
        readEquipmentCSV(PSItemType.TYPE_BODY, "data_mh3g/MH3EQUIP_BODY.csv", listEquipBody);
        readEquipmentCSV(PSItemType.TYPE_ARM, "data_mh3g/MH3EQUIP_ARM.csv", listEquipArm);
        readEquipmentCSV(PSItemType.TYPE_WEIST, "data_mh3g/MH3EQUIP_WST.csv", listEquipWeist);
        readEquipmentCSV(PSItemType.TYPE_LEG, "data_mh3g/MH3EQUIP_LEG.csv", listEquipLeg);

        readEquipmentCSV(PSItemType.TYPE_HEAD, "data_mh3g/MH3EQUIP_USER_HEAD.csv", listUserEquipHead);
        readEquipmentCSV(PSItemType.TYPE_BODY, "data_mh3g/MH3EQUIP_USER_BODY.csv", listUserEquipBody);
        readEquipmentCSV(PSItemType.TYPE_ARM, "data_mh3g/MH3EQUIP_USER_ARM.csv", listUserEquipArm);
        readEquipmentCSV(PSItemType.TYPE_WEIST, "data_mh3g/MH3EQUIP_USER_WST.csv", listUserEquipWeist);
        readEquipmentCSV(PSItemType.TYPE_LEG, "data_mh3g/MH3EQUIP_USER_LEG.csv", listUserEquipLeg);

        readEquipmentCSV(PSItemType.TYPE_HEAD, "data_mh3g/MH3EQUIP_TRASH_HEAD.csv", listTrashEquipHead);
        readEquipmentCSV(PSItemType.TYPE_BODY, "data_mh3g/MH3EQUIP_TRASH_BODY.csv", listTrashEquipBody);
        readEquipmentCSV(PSItemType.TYPE_ARM, "data_mh3g/MH3EQUIP_TRASH_ARM.csv", listTrashEquipArm);
        readEquipmentCSV(PSItemType.TYPE_WEIST, "data_mh3g/MH3EQUIP_TRASH_WST.csv", listTrashEquipWeist);
        readEquipmentCSV(PSItemType.TYPE_LEG, "data_mh3g/MH3EQUIP_TRASH_LEG.csv", listTrashEquipLeg);

        ArrayList<PSItem> listDecoration = new ArrayList<PSItem>();
        ArrayList<PSItem> listUserDecoration = new ArrayList<PSItem>();
        ArrayList<PSItem> listTrashDecoration = new ArrayList<PSItem>();

        readDecorationCSV(PSItemType.TYPE_DECORATION, "data_mh3g/MH3DECO.csv", listDecoration);
        readDecorationCSV(PSItemType.TYPE_DECORATION, "data_mh3g/MH3DECO_USER.csv", listUserDecoration);
        readDecorationCSV(PSItemType.TYPE_DECORATION, "data_mh3g/MH3DECO_TRASH.csv", listUserDecoration);

        PSBaseItems cont = Repository.getBaseItems();

        cont.listBaseEquipHead = listEquipHead;
        cont.listBaseEquipBody = listEquipBody;
        cont.listBaseEquipArm = listEquipArm;
        cont.listBaseEquipWeist = listEquipWeist;
        cont.listBaseEquipLeg = listEquipLeg;
        cont.listBaseCharm = new ArrayList<PSItem>();
        cont.listBaseDecoration = listDecoration;

        cont.listUserEquipHead = listUserEquipHead;
        cont.listUserEquipBody = listUserEquipBody;
        cont.listUserEquipArm = listUserEquipArm;
        cont.listUserEquipWeist = listUserEquipWeist;
        cont.listUserEquipLeg = listUserEquipLeg;
        cont.listUserCharm = new ArrayList<PSItem>();;
        cont.listUserDecoration = listUserDecoration;

        cont.listTrashEquipHead = listTrashEquipHead;
        cont.listTrashEquipBody = listTrashEquipBody;
        cont.listTrashEquipArm = listTrashEquipArm;
        cont.listTrashEquipWeist = listTrashEquipWeist;
        cont.listTrashEquipLeg = listTrashEquipLeg;
        cont.listTrashCharm = new ArrayList<PSItem>();;
        cont.listTrashDecoration = listTrashDecoration;

        cont.invalidate();
    }

    public void readSkillsCSV(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        List<String> str = new ArrayList<String>();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                String skillName = str.get(0);
                String skillKind = str.get(1);
                int skillPoint = Integer.parseInt(str.get(2));
                int hunterType = Integer.parseInt(str.get(3));

                SkillKind kindObj = null;
                kindObj = categories.findKindByName(skillKind);
                if (kindObj == null) {
                    kindObj = new SkillKind(skillKind);
                    categories.addSkillKind(kindObj);
                }

                SkillPoint rank;
                rank = new SkillPoint(kindObj, skillPoint, skillPoint > 0, skillName);
                categories.addPoint(rank);
            }
        } finally {
            in.close();
        }
    }

    public void readEquipmentCSV(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVReader in = null;
        List<String> str = new ArrayList<String>();
        SkillCategories categories = Repository.getSkillCategories();

        try {
            try {
                in = new CSVReader(fileName);
            }catch(IOException e) {
                return;
            }

            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                PSItem item = new PSItem(itemType);

                Iterator<String> it = str.iterator();

                item.name = it.next();
                item.genderType = Integer.parseInt(it.next());
                item.hunterType = Integer.parseInt(it.next());
                item.rareRank = Integer.parseInt(it.next());
                item.slotCount = Integer.parseInt(it.next());
                item.existHunterRank = Integer.parseInt(it.next());
                item.existTownRank = Integer.parseInt(it.next());
                item.defInitial = Integer.parseInt(it.next());
                item.defMax = Integer.parseInt(it.next());
                item.shellFire = Integer.parseInt(it.next());
                item.shellWater = Integer.parseInt(it.next());
                item.shellIce = Integer.parseInt(it.next());
                item.shellThunder = Integer.parseInt(it.next());
                item.shellDragon = Integer.parseInt(it.next());

                for (int i = 0; it.hasNext() && i < 5; ++i) {
                    String name = it.next();
                    int point = 0;

                    try {
                        if (name.length() == 0) {
                            it.next();
                            continue;
                        }
                        point = Integer.parseInt(it.next());
                    }catch(Exception e) {
                        continue;
                    }

                    if (name.equals("n") || name.equals("n{") || name .equals("n{")) {
                        item.isCopieSkill = true;
                        continue;
                    }
                    if (name.startsWith("---")) {
                        continue;
                    }

                    SkillKind kind = categories.findKindByName(name);
                    if (kind == null) {
                        System.out.println("Kind [" + name +"] not found for item " + item);
                    }else {
                        item.skills.set(kind, point, true);
                    }
                }

                for (int i = 0; it.hasNext() && i < 4; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = it.next().intern();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt(it.next());
                        item.materialAList.add(material);
                    } else {
                        if (it.hasNext()) {
                            it.next();
                        }
                    }
                }
                list.add(item);
            }
        } finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void readDecorationCSV(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVReader in = null;
        List<String> str = new ArrayList<String>();
        SkillCategories categories = Repository.getSkillCategories();

        try {
            try {
                in = new CSVReader(fileName);
            }catch(IOException e) {
                return;
            }
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                PSItem item = new PSItem(itemType);

                Iterator<String> it = str.iterator();

                item.name = it.next();
                item.rareRank = Integer.parseInt(it.next());
                item.slotCount = Integer.parseInt(it.next());
                item.existHunterRank = Integer.parseInt(it.next());
                item.existTownRank = Integer.parseInt(it.next());

                for (int i = 0; it.hasNext() && i < 2; ++i) {
                    String name = it.next();
                    if (name.length() == 0) {
                        it.next();
                        continue;
                    }
                    int point = Integer.parseInt(it.next());

                    if (name.startsWith("---")) {
                        continue;
                    }
                    SkillKind kind = categories.findKindByName(name);
                    item.skills.set(kind, point, true);
                }

                for (int i = 0; it.hasNext() && i < 4; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = it.next().intern();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt(it.next());
                        item.materialAList.add(material);
                    } else {
                        if (it.hasNext()) {
                            it.next();
                        }
                    }
                }
                for (int i = 0; it.hasNext() && i < 4; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = it.next();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt(it.next());
                        item.materialBList.add(material);
                    } else {
                        if (it.hasNext()) {
                            it.next();
                        }
                    }
                }
                list.add(item);
            }
        } finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void readCharmCSVFile(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVReader in = new CSVReader(fileName);
        ArrayList<PSItem> infoList = new ArrayList<PSItem>();
        List<String> str = new ArrayList<String>();
        SkillCategories categories = Repository.getSkillCategories();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                PSItem item = new PSItem(itemType);
                Iterator<String> it = str.iterator();

                item.name = it.next();
                item.slotCount = Integer.parseInt(it.next());

                for (int i = 0; it.hasNext() && i < 2; ++i) {
                    String name = it.next();
                    if (name.length() == 0) {
                        it.next();
                        continue;
                    }
                    int point = Integer.parseInt(it.next());

                    try {
                        SkillKind kind = categories.findKindByName(name);
                        item.skills.set(kind, point, true);
                    } catch (Exception e) {
                        e.printStackTrace();
                        ;
                    }
                }
                list.add(item);
            }
        } finally {
            in.close();
        }
    }

    public void writeUserEquipmentCSV(int type, String fileName, ArrayList<PSItem> list) throws IOException {
        CSVWriter out = null;
        List<String> str = new ArrayList<String>();

        try {
            try {
                out = new CSVWriter(fileName);
            }catch(FileNotFoundException e) {
                e.printStackTrace();
                return;
            }

            for (PSItem item : list) {
                str.add(item.name);
                str.add(String.valueOf(item.genderType));
                str.add(String.valueOf(item.hunterType));
                str.add(String.valueOf(item.rareRank));
                str.add(String.valueOf(item.slotCount));
                str.add(String.valueOf(item.existHunterRank));
                str.add(String.valueOf(item.existTownRank));
                str.add(String.valueOf(item.defInitial));
                str.add(String.valueOf(item.defMax));
                str.add(String.valueOf(item.shellFire));
                str.add(String.valueOf(item.shellWater));
                str.add(String.valueOf(item.shellIce));
                str.add(String.valueOf(item.shellThunder));
                str.add(String.valueOf(item.shellDragon));

                for (int i = 0; i < 5; ++ i) {
                    if (item.isCopieSkill) {
                        if (i == 0) {
                            str.add("n");
                            str.add("1");
                        }else {
                            str.add("");
                            str.add("");
                        }
                    }else if (i >= item.skills.size()) {
                        str.add("");
                        str.add("");
                    }else {
                        str.add(item.skills.kind(i).name);
                        str.add(String.valueOf(item.skills.point(i)));
                    }
                }

                for (int i = 0; i < 4; ++ i) {
                    if (i >= item.materialAList.size()) {
                        str.add("");
                        str.add("");
                    }else {
                        str.add(item.materialAList.get(i).name);
                        str.add(Integer.toString(item.materialAList.get(i).count));
                    }
                }
                out.writeLine(str);
                str.clear();
            }
        } finally {
            out.close();
        }
    }

    public void writeUserDecorationCSV(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVWriter out = null;
        List<String> str = new ArrayList<String>();

        try {
            try {
                out = new CSVWriter(fileName);
            }catch(FileNotFoundException e) {
                e.printStackTrace();
                return;
            }

            for (PSItem item : list) {
                str.clear();
                str.add(item.name);
                str.add(String.valueOf(item.rareRank));
                str.add(String.valueOf(item.slotCount));
                str.add(String.valueOf(item.existHunterRank));
                str.add(String.valueOf(item.existTownRank));

                for(int i = 0; i < 2; ++ i) {
                    SkillSet skills = item.skills;
                    if (i >= skills.size()) {
                        str.add("---");
                        str.add("");
                    }else {
                        str.add(skills.kind(i).name);
                        str.add(String.valueOf(skills.point(i)));
                    }
                }
                for (int i = 0; i < 4; ++ i) {
                    if (i >= item.materialAList.size()) {
                        str.add("");
                        str.add("");
                    }else {
                        str.add(item.materialAList.get(i).name);
                        str.add(Integer.toString(item.materialAList.get(i).count));
                    }
                }
                for (int i = 0; i < 4; ++ i) {
                    if (i >= item.materialBList.size()) {
                        str.add("");
                        str.add("");
                    }else {
                        str.add(item.materialBList.get(i).name);
                        str.add(Integer.toString(item.materialBList.get(i).count));
                    }
                }

            }

        }finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void readSkillCategories(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        List<String> str = new ArrayList<String>();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                String categoryName = str.get(0);
                categories.addCategory(categoryName);
                for (int i = 1; i < str.size(); ++i) {
                    String skillName = str.get(i);
                    categories.setCategory(categoryName, skillName);
                }
            }
        } finally {
            in.close();
        }
    }

    public void readSkillFukugo(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        List<String> str = new ArrayList<String>();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                String nameFukugo = str.get(0);
                SkillPoint pointFukugo = Repository.getSkillCategories().pointNameToPoint(nameFukugo);

                if (pointFukugo == null) {
                    System.out.println("XLsPF" + nameFukugo);
                    continue;
                }

                ArrayList<SkillPoint> listPoint = new ArrayList<SkillPoint>();

                for (int i = 1; i < str.size(); ++i) {
                    String name2 = str.get(i);
                    SkillPoint point2 = Repository.getSkillCategories().pointNameToPoint(name2);
                    if (point2 == null) {
                        System.out.println("XLsQF" + name2);
                        continue;
                    }
                    listPoint.add(point2);
                }

                Repository.getFukugo().mapFukugo.put(pointFukugo, listPoint);
            }
        } finally {
            in.close();
        }
    }

    public void writeCharmCSVFile(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVWriter out = new CSVWriter(fileName);
        List<String> str = new ArrayList<String>();
        SkillCategories categories = Repository.getSkillCategories();

        try {
            for (PSItem item : list) {
                str.clear();
                str.add(item.name);
                str.add(Integer.toString(item.slotCount));

                for (int i = 0; i < 2; ++i) {
                    if (i >= item.skills.size()) {
                        str.add("");
                        str.add("");
                    }else {
                        str.add(item.skills.kind(i).name);
                        str.add(Integer.toString(item.skills.point(i)));
                    }
                }
                out.writeLine(str);
            }
        } finally {
            out.close();
        }
    }
}
