package portablesimulator.csv;

import java.io.FileNotFoundException;
import portablesimulator.PSItem;
import portablesimulator.skillset.SkillPoint;
import portablesimulator.skillset.SkillKind;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import portablesimulator.PSItemMaterial;
import portablesimulator.PSItemType;
import portablesimulator.skillset.SkillCategories;
import portablesimulator.skillset.SkillSet;

class MHP2GDataIO {

    public MHP2GDataIO() {
    }

    public void readAll() throws IOException {
        readSkillsCSV("data_mhp2g/SKILL_EQ.csv");
        readSkillFukugo("data_mhp2g/conf/FUKUGO.txt");
        //readSkillCategories("data_mhp2g/conf/CATEGORY.txt");

        ArrayList<PSItem> listEquipHead = new ArrayList<PSItem>();
        readEquipmentCSV(PSItemType.TYPE_HEAD, "data_mhp2g/MHP2EQUIP_HEAD.csv", listEquipHead);

        ArrayList<PSItem> listEquipBody = new ArrayList<PSItem>();
        readEquipmentCSV(PSItemType.TYPE_BODY, "data_mhp2g/MHP2EQUIP_BODY.csv", listEquipBody);

        ArrayList<PSItem> listEquipArm = new ArrayList<PSItem>();
        readEquipmentCSV(PSItemType.TYPE_ARM, "data_mhp2g/MHP2EQUIP_ARM.csv", listEquipArm);

        ArrayList<PSItem> listEquipWeist = new ArrayList<PSItem>();
        readEquipmentCSV(PSItemType.TYPE_WEIST, "data_mhp2g/MHP2EQUIP_WST.csv", listEquipWeist);

        ArrayList<PSItem> listEquipLeg = new ArrayList<PSItem>();
        readEquipmentCSV(PSItemType.TYPE_LEG, "data_mhp2g/MHP2EQUIP_LEG.csv", listEquipLeg);

        ArrayList<PSItem> listDecoration = new ArrayList<PSItem>();
        readDecorationCSV(PSItemType.TYPE_DECORATION, "data_mhp2g/MHP2EQUIP_DECO.csv", listDecoration);

        PSBaseItems cont = Repository.getBaseItems();

        cont.listBaseEquipHead = listEquipHead;
        cont.listBaseEquipBody = listEquipBody;
        cont.listBaseEquipArm = listEquipArm;
        cont.listBaseEquipWeist = listEquipWeist;
        cont.listBaseEquipLeg = listEquipLeg;
        cont.listBaseCharm = new ArrayList<PSItem>();
        cont.listBaseDecoration = listDecoration;

        cont.invalidate();
    }

    public void writeUserData() throws IOException {
        PSBaseItems base = Repository.getBaseItems();

        writeUserEquipmentCSV(PSItemType.TYPE_HEAD, "data_mhp2g/MH3EQUIP_USER_HEAD.csv", Repository.getBaseItems().listUserEquipHead);
        writeUserEquipmentCSV(PSItemType.TYPE_BODY, "data_mhp2g/MH3EQUIP_USER_BODY.csv", Repository.getBaseItems().listUserEquipBody);
        writeUserEquipmentCSV(PSItemType.TYPE_ARM,  "data_mhp2g/MH3EQUIP_USER_ARM.csv", Repository.getBaseItems().listUserEquipArm);
        writeUserEquipmentCSV(PSItemType.TYPE_WEIST,"data_mhp2g/MH3EQUIP_USER_WEIST.csv", Repository.getBaseItems().listUserEquipWeist);
        writeUserEquipmentCSV(PSItemType.TYPE_LEG,  "data_mhp2g/MH3EQUIP_USER_LEG.csv", Repository.getBaseItems().listUserEquipLeg);
        writeUserDecorationCSV(PSItemType.TYPE_DECORATION, "data_mhp2g/MH3DECO_USER.csv", Repository.getBaseItems().listUserDecoration);

        writeUserEquipmentCSV(PSItemType.TYPE_HEAD, "data_mhp2g/MH3EQUIP_TRASH_HEAD.csv", Repository.getBaseItems().listTrashEquipHead);
        writeUserEquipmentCSV(PSItemType.TYPE_BODY, "data_mhp2g/MH3EQUIP_TRASH_BODY.csv", Repository.getBaseItems().listTrashEquipBody);
        writeUserEquipmentCSV(PSItemType.TYPE_ARM,  "data_mhp2g/MH3EQUIP_TRASH_ARM.csv", Repository.getBaseItems().listTrashEquipArm);
        writeUserEquipmentCSV(PSItemType.TYPE_WEIST,"data_mhp2g/MH3EQUIP_TRASH_WEIST.csv", Repository.getBaseItems().listTrashEquipWeist);
        writeUserEquipmentCSV(PSItemType.TYPE_LEG,  "data_mhp2g/MH3EQUIP_TRASH_LEG.csv", Repository.getBaseItems().listTrashEquipLeg);
        writeUserDecorationCSV(PSItemType.TYPE_DECORATION, "data_mhp2g/MH3DECO_TRASH.csv", Repository.getBaseItems().listTrashDecoration);
    }

    public void readSkillsCSV(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        List<String> str = new ArrayList<String>();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                String skillName = str.get(0);
                String skillKind = str.get(1);
                int skillPoint = Integer.parseInt(str.get(2));
                int hunterType = Integer.parseInt(str.get(3));
                String category = str.get(4);

                SkillKind kindObj = null;
                kindObj = categories.findKindByName(skillKind);
                if (kindObj == null) {
                    kindObj = new SkillKind(skillKind);
                    categories.addSkillKind(kindObj);
                }

                SkillPoint rank;
                rank = new SkillPoint(kindObj, skillPoint, skillPoint > 0, skillName);
                categories.addPoint(rank);
                categories.setCategory(category, skillName);
            }
        } finally {
            in.close();
        }
    }

    public void readEquipmentCSV(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVReader in = new CSVReader(fileName);
        List<String> str = new ArrayList<String>();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                PSItem item = new PSItem(itemType);

                Iterator<String> it = str.iterator();

                item.name = it.next();
                item.genderType = Integer.parseInt(it.next());
                item.hunterType = Integer.parseInt(it.next());
                item.rareRank = Integer.parseInt(it.next());
                item.slotCount = Integer.parseInt(it.next());
                if (item.rareRank >= 9) {
                    item.existHunterRank = 3;
                    item.existTownRank = 3;
                }else if (item.rareRank >= 6) {
                    item.existHunterRank = 2;
                    item.existTownRank = 2;
                }else {
                    item.existHunterRank = 1;
                    item.existTownRank = 1;
                }
                item.defInitial = Integer.parseInt(it.next());
                item.defMax = Integer.parseInt(it.next());
                item.shellFire = Integer.parseInt(it.next());
                item.shellWater = Integer.parseInt(it.next());
                item.shellIce = Integer.parseInt(it.next());
                item.shellThunder = Integer.parseInt(it.next());
                item.shellDragon = Integer.parseInt(it.next());

                for (int i = 0; it.hasNext() && i < 5; ++i) {
                    String name = it.next();
                    if (name.length() == 0) {
                        it.next();
                        continue;
                    }
                    int point = Integer.parseInt(it.next());

                    if (name.equals("Ȃ")) {
                        continue;
                    }
                    if (name.startsWith("n{")) {
                        item.isCopieSkill = true;
                        continue;
                    }

                    SkillKind kind = Repository.getSkillCategories().findKindByName(name);
                    if (kind == null) {
                        System.out.println("Unknown Kind " + name);
                        continue;
                    }
                    item.skills.set(kind, point, true);
                }

                for (int i = 0; it.hasNext() && i < 5; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = it.next();
                    if (material.name.length() != 0 && it.hasNext()) {
                        material.count = Integer.parseInt(it.next());
                        item.materialAList.add(material);
                    } else {
                        if (it.hasNext()) {
                            it.next();
                        }
                    }
                }
                for (int i = 0; it.hasNext() && i < 2; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = it.next();
                    if (material.name.length() != 0 && it.hasNext()) {
                        material.count = Integer.parseInt(it.next());
                        item.materialBList.add(material);
                    } else {
                        if (it.hasNext()) {
                            it.next();
                        }
                    }
                }
                list.add(item);
            }
        } finally {
            in.close();
        }
    }

    public void readDecorationCSV(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVReader in = new CSVReader(fileName);
        List<String> str = new ArrayList<String>();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                PSItem item = new PSItem(itemType);

                Iterator<String> it = str.iterator();

                item.name = it.next();
                item.rareRank = Integer.parseInt(it.next());
                item.slotCount = Integer.parseInt(it.next());
                item.existHunterRank = 0;
                item.existTownRank = 0;

                for (int i = 0; it.hasNext() && i < 2; ++i) {
                    String name = it.next();
                    if (name.length() == 0) {
                        it.next();
                        continue;
                    }
                    if (name.equals("Ȃ")) {
                        if (it.hasNext()) {
                            it.next();
                        }
                        continue;
                    }
                    int point = Integer.parseInt(it.next());

                    SkillKind kind = Repository.getSkillCategories().findKindByName(name);
                    if (kind == null) {
                        System.out.println("Unknown Decoration Kind " + name);
                        continue;
                    }
                    item.skills.set(kind, point, true);
                }

                String level = it.next();
                if (level.equals("")) {
                    item.existHunterRank = 1;
                    item.existTownRank = 1;
                }
                if (level.equals("")) {
                    item.existHunterRank = 2;
                    item.existTownRank = 2;
                }
                if (level.equals("f")) {
                    item.existHunterRank = 3;
                    item.existTownRank = 99;
                }

                for (int i = 0; it.hasNext() && i < 4; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = it.next();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt(it.next());
                        item.materialAList.add(material);
                    } else {
                        if (it.hasNext()) {
                            it.next();
                        }
                    }
                }
                for (int i = 0; it.hasNext() && i < 4; ++i) {
                    PSItemMaterial material = new PSItemMaterial();
                    material.name = it.next();
                    if (material.name.length() != 0) {
                        material.count = Integer.parseInt(it.next());
                        item.materialBList.add(material);
                    } else {
                        if (it.hasNext()) {
                            it.next();
                        }
                    }
                }
                list.add(item);
            }
        } finally {
            in.close();
        }
    }

    public void readSkillCategories(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        List<String> str = new ArrayList<String>();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                String categoryName = str.get(0);
                categories.addCategory(categoryName);
                for (int i = 1; i < str.size(); ++i) {
                    String skillName = str.get(i);
                    categories.setCategory(categoryName, skillName);
                }
            }
        } finally {
            in.close();
        }
    }

    public void readSkillFukugo(String fileName) throws IOException {
        CSVReader in = new CSVReader(fileName);
        SkillCategories categories = Repository.getSkillCategories();
        List<String> str = new ArrayList<String>();

        try {
            while (true) {
                if (in.readLine(str) == false) {
                    break;
                }

                String nameFukugo = str.get(0);
                SkillPoint pointFukugo = Repository.getSkillCategories().pointNameToPoint(nameFukugo);

                if (pointFukugo == null) {
                    System.out.println("XLsPF" + nameFukugo);
                    continue;
                }

                ArrayList<SkillPoint> listPoint = new ArrayList<SkillPoint>();

                for (int i = 1; i < str.size(); ++i) {
                    String name2 = str.get(i);
                    SkillPoint point2 = Repository.getSkillCategories().pointNameToPoint(name2);
                    if (point2 == null) {
                        System.out.println("XLsQF" + name2);
                        continue;
                    }
                    listPoint.add(point2);
                }

                Repository.getFukugo().mapFukugo.put(pointFukugo, listPoint);
            }
        } finally {
            in.close();
        }
    }

    public void writeUserEquipmentCSV(int type, String fileName, ArrayList<PSItem> list) throws IOException {
        CSVWriter out = null;
        List<String> str = new ArrayList<String>();

        try {
            try {
                out = new CSVWriter(fileName);
            }catch(FileNotFoundException e) {
                e.printStackTrace();
                return;
            }

            for (PSItem item : list) {
                str.add(item.name);
                str.add(String.valueOf(item.genderType));
                str.add(String.valueOf(item.hunterType));
                str.add(String.valueOf(item.rareRank));
                str.add(String.valueOf(item.slotCount));
                str.add(String.valueOf(item.existHunterRank));
                str.add(String.valueOf(item.existTownRank));
                str.add(String.valueOf(item.defInitial));
                str.add(String.valueOf(item.defMax));
                str.add(String.valueOf(item.shellFire));
                str.add(String.valueOf(item.shellWater));
                str.add(String.valueOf(item.shellIce));
                str.add(String.valueOf(item.shellThunder));
                str.add(String.valueOf(item.shellDragon));

                for (int i = 0; i < 5; ++ i) {
                    if (item.isCopieSkill) {
                        if (i == 0) {
                            str.add("n");
                            str.add("1");
                        }else {
                            str.add("");
                            str.add("");
                        }
                    }else if (i >= item.skills.size()) {
                        str.add("");
                        str.add("");
                    }else {
                        str.add(item.skills.kind(i).name);
                        str.add(String.valueOf(item.skills.point(i)));
                    }
                }

                for (int i = 0; i < 4; ++ i) {
                    if (i >= item.materialAList.size()) {
                        str.add("");
                        str.add("");
                    }else {
                        str.add(item.materialAList.get(i).name);
                        str.add(Integer.toString(item.materialAList.get(i).count));
                    }
                }
                out.writeLine(str);
                str.clear();
            }
        } finally {
            out.close();
        }
    }

    public void writeUserDecorationCSV(int itemType, String fileName, List<PSItem> list) throws IOException {
        CSVWriter out = null;
        List<String> str = new ArrayList<String>();

        try {
            try {
                out = new CSVWriter(fileName);
            }catch(FileNotFoundException e) {
                e.printStackTrace();
                return;
            }

            for (PSItem item : list) {
                str.clear();
                str.add(item.name);
                str.add(String.valueOf(item.rareRank));
                str.add(String.valueOf(item.slotCount));
                str.add(String.valueOf(item.existHunterRank));
                str.add(String.valueOf(item.existTownRank));

                for(int i = 0; i < 2; ++ i) {
                    SkillSet skills = item.skills;
                    if (i >= skills.size()) {
                        str.add("---");
                        str.add("");
                    }else {
                        str.add(skills.kind(i).name);
                        str.add(String.valueOf(skills.point(i)));
                    }
                }
                for (int i = 0; i < 4; ++ i) {
                    if (i >= item.materialAList.size()) {
                        str.add("");
                        str.add("");
                    }else {
                        str.add(item.materialAList.get(i).name);
                        str.add(Integer.toString(item.materialAList.get(i).count));
                    }
                }
                for (int i = 0; i < 4; ++ i) {
                    if (i >= item.materialBList.size()) {
                        str.add("");
                        str.add("");
                    }else {
                        str.add(item.materialBList.get(i).name);
                        str.add(Integer.toString(item.materialBList.get(i).count));
                    }
                }

            }

        }finally {
            if (out != null) {
                out.close();
            }
        }
    }
}
