package portablesimulator.csv;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import portablesimulator.PSItem;
import portablesimulator.PSItemType;
import portablesimulator.decoration.DecorationCount;

public class PSSearchItems {
    Set<String>[] candidateUnchecked = new Set[8];
    Set<String>[] viewUnchecked = new Set[8];
    public DecorationCount searchUsableCount = null;

    public PSSearchItems() {
        for (int i = 0; i < 8; ++i) {
            candidateUnchecked[i] = new HashSet<String>();
            viewUnchecked[i] = new HashSet<String>();
        }
    }

    public boolean isCandidateChecked(PSItem item) {
        String name = item.name;
        if (item.itemType == PSItemType.TYPE_CHARM) {
            name = item.name + "[" + item.slotCount +"]" + item.skills.skillToString(null, true);
        }
        return candidateUnchecked[item.itemType].contains(name) == false;
    }

    public void setCandidateChecked(PSItem item, boolean value) {
        String name = item.name;
        if (item.itemType == PSItemType.TYPE_CHARM) {
            name = item.name + "[" + item.slotCount +"]" + item.skills.skillToString(null, true);
        }
        if (value) {
            candidateUnchecked[item.itemType].remove(name);
        } else {
            candidateUnchecked[item.itemType].add(name);
        }
    }

    public boolean isViewChecked(PSItem item) {
        String name = item.name;
        if (item.itemType == PSItemType.TYPE_CHARM) {
            name = item.name + "[" + item.slotCount +"]" + item.skills.skillToString(null, true);
        }
        return viewUnchecked[item.itemType].contains(name) == false;
    }

    public void setViewChecked(PSItem item, boolean value) {
        String name = item.name;
        if (item.itemType == PSItemType.TYPE_CHARM) {
            name = item.name + "[" + item.slotCount +"]" + item.skills.skillToString(null, true);
        }
        if (value) {
            viewUnchecked[item.itemType].remove(name);
        } else {
            viewUnchecked[item.itemType].add(name);
        }
    }
}
