package portablesimulator.gui;

import java.awt.Color;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import portablesimulator.PSItem;

public class MyComboBoxForUsableCount extends javax.swing.JPanel {

    /** Creates new form MyLabeledTextField */
    public MyComboBoxForUsableCount() {
        initComponents();
    }

    public void setLabelForeground(Color fore) {
        this.jLabel1.setForeground(fore);
    }

    /** Creates new form MyLabeledTextField */
    public MyComboBoxForUsableCount(PSFrame frame, PSItem item, int defaultValue) {
        initComponents();
        this.frame = frame;
        this.item = item;
        setLabel(item.name);
        setValue(defaultValue);
    }

    public ComboBoxModel createNumberModel() {
        int minValue = 0;
        int maxValue = 20;
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        for(int i = minValue; i <= maxValue; ++ i) {
            model.addElement(new MyComboBoxElement(String.valueOf(i), i));
        }
        model.addElement(new MyComboBoxElement("", Integer.MAX_VALUE));
        return model;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jComboBox1 = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("jLabel1");
        jLabel1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel1MouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jLabel1, gridBagConstraints);

        jComboBox1.setModel(createNumberModel());
        jComboBox1.addPopupMenuListener(new javax.swing.event.PopupMenuListener() {
            public void popupMenuCanceled(javax.swing.event.PopupMenuEvent evt) {
            }
            public void popupMenuWillBecomeInvisible(javax.swing.event.PopupMenuEvent evt) {
            }
            public void popupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent evt) {
                jComboBox1PopupMenuWillBecomeVisible(evt);
            }
        });
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        add(jComboBox1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        //frame.doPrintTextArea(item.getFormatted(), "ACeڍ");
    }//GEN-LAST:event_jComboBox1ActionPerformed

    private void jLabel1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel1MouseClicked
        //frame.doPrintTextArea(item.getFormatted(), "ACeڍ");
    }//GEN-LAST:event_jLabel1MouseClicked

    private void jComboBox1PopupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent evt) {//GEN-FIRST:event_jComboBox1PopupMenuWillBecomeVisible
        frame.doPrintTextArea(item.getFormatted(), "ACeڍ");
    }//GEN-LAST:event_jComboBox1PopupMenuWillBecomeVisible


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

    private PSFrame frame;
    public PSItem  item;

    public String getLabel() {
        return jLabel1.getText();
    }

    public void setLabel(String label) {
        jLabel1.setText(label);
    }

    public int getValue() {
        return MyComboBoxUtil.getComboSelectedInt(jComboBox1, 0);
    }

    public void setValue(int num) {
        MyComboBoxUtil.setComboSelectedInt(jComboBox1, num);
    }
}
