#!/usr/bin/env python
# -*- coding: utf-8 -*-

import time
import datetime
import sqlite3
import re
import sys

usage = sys.argv[0] + """<topic1> <topic2>"""
DATABASE = "./story.db"

range_begin = datetime.datetime(2009, 10, 26)
range_end = datetime.datetime(2009, 11, 26)

begin_t = time.mktime(range_begin.timetuple())
end_t = time.mktime(range_end.timetuple())

try:
    topic1 = sys.argv[1].decode("utf-8")
except IndexError:
    sys.exit(usage)

if len(sys.argv) > 2:
    topic2 = sys.argv[2].decode("utf-8")
else:
    topic2 = ""

if topic2:
    cmd = """select sid, title, date from stories where date >= ? and date < ? and sid in (
              select sid from topics where topic == ? and sid in (
              select sid from topics where topic == ? )) order by date
"""
    con = sqlite3.connect(DATABASE)
    cur = con.cursor()
    cur.execute(cmd, (begin_t, end_t, topic1, topic2))
else:
    cmd = """select sid, title, date from stories where date >= ? and date < ? and sid in (
              select sid from topics where topic == ? ) order by date
"""
    con = sqlite3.connect(DATABASE)
    cur = con.cursor()
    cur.execute(cmd, (begin_t, end_t, topic1))

print """
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"
  "http://www.w3.org/TR/html4/strict.dtd">
<html lang="ja">
<head>
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>Article list</title>
</head>
<body>
<table border="1" cellpadding="4" cellspacing="0">
<tr><th>#</th><th>date</th><th>time</th><th>title</th></tr>
"""

index = 1
for row in cur:
    sid = row[0]
    title = row[1]
    tm = row[2]
    dt = datetime.datetime.fromtimestamp(tm)
    localdt = dt + datetime.timedelta(hours=9)

    output = '<tr><td>%(index)d</td><td>%(date)s</td><td>%(time)s</td><td><a href="%(url)s">%(title)s</a></tr></tr>' % dict(index=index, date=localdt.strftime("%y-%m-%d"), time=localdt.strftime("%H:%M:%S"), url="http://sourceforge.jp/magazine/" + sid, title=title)
    print output.encode("utf-8")
    index += 1


print "</table></body></html>"
cur.close()
con.close()

