#!/usr/bin/env python
# -*- coding: utf-8 -*-

import cgi
import cgitb; cgitb.enable()

from bigblack.bigblack import BigBlack, Debugger

import os
import time
import datetime
import sqlite3
import re
import sys

import databases

#LOG_DB = "database/analytics_dat"
WRITERS = (u"松島浩道", u"末岡洋子", u"二瓶亮史", u"大津真", u"林利明", u"Infostand")

class StatApp(BigBlack):
    def __init__(self):
        BigBlack.__init__(self)
        self.debugger = Debugger(self)

    def root(self):
        "/ handler"
        topic1 = self.cgi.getfirst("topic1", "")
        topic2 = self.cgi.getfirst("topic2", "")
        self.view.render("root.html", dict(title="newsclip login",
                                           topic1=topic1,
                                           topic2=topic2,
                                           op=""))

    def h_query(self):
        "/query/ handler"
        # get parameters
        topic1 = self.cgi.getfirst("topic1", "").decode("utf-8")
        topic2 = self.cgi.getfirst("topic2", "").decode("utf-8")
        year = self.cgi.getfirst("start_y", "")
        month = self.cgi.getfirst("start_m", "")

        # set time period
        start_year = int(year) if year else 2010
        start_month = int(month) if month else 1
        if start_month == 1:
            start_month = 12
            start_year -= 1
        else:
            start_month -= 1
        end_year = start_year
        end_month = start_month + 1
        if end_month > 12:
            end_year += 1
            end_month = 1
        range_begin = datetime.datetime(start_year, start_month, 26)
        begin_t = time.mktime(range_begin.timetuple())
        range_end = datetime.datetime(end_year, end_month, 26)
        end_t = time.mktime(range_end.timetuple())


        # initiate DBs
        hatebu_db = databases.HatebuDB()
        ga_db = databases.GALogDB()
        s_db = databases.StoryDB()
        index = 1
        result = []
        
        # scan DB
        with s_db:
            for row in s_db.query(topic1, topic2, begin_t, end_t):
                sid = row[0]
                title = row[1]
                tm = row[2]
                dt = datetime.datetime.fromtimestamp(tm)
                localdt = dt + datetime.timedelta(hours=9)

                author = s_db.find_author(sid, WRITERS)
                pv = ga_db.get_PV(sid)
                hatebu_count = hatebu_db.get_count(sid)

                d = dict(index=index,
                         date=localdt.strftime("%y-%m-%d"),
                         time=localdt.strftime("%H:%M:%S"),
                         url="http://sourceforge.jp/magazine/" + sid,
                         pageviews=pv,
                         author=author,
                         title=title,
                         hatebu_count=hatebu_count)
                result.append(d)
                index += 1

        # render view
        self.view.render("root.html", dict(title="newsclip login",
                                           topic1=topic1,
                                           topic2=topic2,
                                           year=year,
                                           month=month,
                                           op="query",
                                           result=result))

if __name__ == '__main__':
    app = StatApp()
    app.run()
