package jp.sourceforge.pdt_tools.callhierarchy;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ICallHierarchyFactory;
import org.eclipse.dltk.core.ICallProcessor;
import org.eclipse.dltk.core.ICalleeProcessor;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.search.IDLTKSearchScope;

public class CallHierarchyFactory implements ICallHierarchyFactory {

	public ICallProcessor createCallProcessor() {
		return new CallProcessor();
	}

	public ICalleeProcessor createCalleeProcessor(IMethod method,
			IProgressMonitor monitor, IDLTKSearchScope scope) {
		return new CalleeProcessor(method, monitor, scope);
	}

}
