package jp.sourceforge.pdt_tools.variablefilter.preferences;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import jp.sourceforge.pdt_tools.variablefilter.VariableFilter;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VariableFilterEditDialog extends Dialog {

	private VariableFilter filter;
	private String title;
	private Composite panel;
	private Combo filterTypeCombo;
	private Text filterPatternText;
	private Button regExCheck;

	public VariableFilterEditDialog(Shell shell, String title,
			VariableFilter filter) {
		super(shell);
		this.title = title;
		this.filter = filter;
	}

	public VariableFilter getFilter() {
		return filter;
	}

	private boolean validate() {
		if (regExCheck.getSelection()) {
			String pattern = filterPatternText.getText();
			if (pattern.length() > 0) {
				try {
					Pattern.compile(pattern);
					return true;
				} catch (PatternSyntaxException e) {
				}
			}
			return false;
		} else {
			return filterPatternText.getText().length() > 0;
		}
	}

	@Override
	protected void configureShell(Shell newShell) {
		newShell.setText(title);
		super.configureShell(newShell);
	}

	@Override
	protected Control createContents(Composite parent) {
		Control control = super.createContents(parent);
		filterPatternText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				getButton(IDialogConstants.OK_ID).setEnabled(validate());
			}
		});
		filterTypeCombo.setText(VariableFilter.getTypeName(filter.getType()));
		filterPatternText.setText(filter.getPattern());
		regExCheck.setSelection(filter.isRegEx());
		return control;
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		Composite base = (Composite) super.createDialogArea(parent);

		panel = new Composite(base, SWT.NONE);
		GridLayout layout = new GridLayout(2, false);
		panel.setLayout(layout);
		panel.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

		Label typelabel = new Label(panel, SWT.NONE);
		typelabel.setText(Messages.VariableFilterEditDialog_type_label);
		typelabel.setLayoutData(new GridData(SWT.BEGINNING, SWT.BEGINNING,
				false, false));
		filterTypeCombo = new Combo(panel, SWT.DROP_DOWN | SWT.READ_ONLY);
		filterTypeCombo.setLayoutData(new GridData(SWT.BEGINNING,
				SWT.BEGINNING, false, false));
		filterTypeCombo.add(VariableFilter.getTypeName(VariableFilter.BY_NAME));
		filterTypeCombo
				.add(VariableFilter.getTypeName(VariableFilter.BY_VALUE));
		filterTypeCombo.setText(VariableFilter
				.getTypeName(VariableFilter.BY_NAME));

		Label patternlabel = new Label(panel, SWT.NONE);
		patternlabel.setText(Messages.VariableFilterEditDialog_pattern_label);
		patternlabel.setLayoutData(new GridData(SWT.BEGINNING, SWT.BEGINNING,
				false, false));
		filterPatternText = new Text(panel, SWT.MULTI | SWT.WRAP | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.BORDER);
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, true);
		data.widthHint = 250;
		data.heightHint = 50;
		filterPatternText.setLayoutData(data);

		regExCheck = new Button(panel, SWT.CHECK);
		data = new GridData(SWT.FILL, SWT.DEFAULT, true, false);
		data.horizontalSpan = 2;
		regExCheck.setLayoutData(data);
		regExCheck.setText(Messages.VariableFilterEditDialog_regex_label);

		return base;
	}

	@Override
	protected boolean isResizable() {
		return true;
	}

	@Override
	protected void okPressed() {
		filter.setType(filterTypeCombo.getSelectionIndex() + 1);
		filter.setPattern(filterPatternText.getText());
		filter.isRegEx(regExCheck.getSelection());
		super.okPressed();
	}
}
