package jp.sourceforge.pdt_tools.variablefilter;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class VariableFilterHandler implements IHandler {

	private VariablesViewerFilter viewerFilter = new VariablesViewerFilter();

	private IPropertyChangeListener listener = new IPropertyChangeListener() {
		public void propertyChange(PropertyChangeEvent event) {
			viewerFilter.update();
		}
	};

	public VariableFilterHandler() {
		IPreferenceStore store = VariableFilterPlugin.getDefault()
				.getPreferenceStore();
		store.addPropertyChangeListener(listener);
	}

	public void dispose() {
		IPreferenceStore store = VariableFilterPlugin.getDefault()
				.getPreferenceStore();
		store.removePropertyChangeListener(listener);
	}

	public Object execute(ExecutionEvent event) throws ExecutionException {
		IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow(event);
		if (window == null) {
			window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
			if (window == null) {
				return null;
			}
		}
		IWorkbenchPage page = window.getActivePage();
		if (page != null) {
			IViewPart part = page.findView(IDebugUIConstants.ID_VARIABLE_VIEW);
			if (part instanceof IDebugView) {
				Viewer viewer = ((IDebugView) part).getViewer();
				if (viewer instanceof StructuredViewer) {
					StructuredViewer structuredViewer = (StructuredViewer) viewer;
					Command command = event.getCommand();
					boolean activate;
					if (event.getTrigger() == null) {
						activate = true;
					} else {
						activate = !HandlerUtil.toggleCommandState(command);
					}
					if (activate) {
						boolean exists = false;
						ViewerFilter[] filters = structuredViewer.getFilters();
						for (ViewerFilter filter : filters) {
							if (filter.equals(viewerFilter)) {
								exists = true;
								break;
							}
						}
						if (!exists) {
							structuredViewer.addFilter(viewerFilter);
						}
					} else {
						structuredViewer.removeFilter(viewerFilter);
					}
				}
			}
		}
		return null;
	}

	public boolean isEnabled() {
		return true;
	}

	public boolean isHandled() {
		return true;
	}

	public void addHandlerListener(IHandlerListener handlerListener) {
	}

	public void removeHandlerListener(IHandlerListener handlerListener) {
	}
}
