/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.web.core.internal.Logger;

public class SetupPHPProjectAction
implements IObjectActionDelegate,
IActionDelegate {
    IWorkbenchPart fPart;
    Object[] fTarget;

    private void doInstall(IProject project, IProgressMonitor monitor) {
        try {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.eclipse.php.core.PHPNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
        catch (CoreException ex) {
            Logger.logException((Throwable)ex);
        }
    }

    private void install(final IProject project) {
        IProgressService service = null;
        if (this.fPart != null) {
            service = (IProgressService)this.fPart.getSite().getService(IProgressService.class);
        }
        if (service == null) {
            this.doInstall(project, null);
        } else {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SetupPHPProjectAction.this.doInstall(project, monitor);
                }
            };
            try {
                service.run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                Logger.logException((Throwable)e);
            }
            catch (InterruptedException e) {
                Logger.logException((Throwable)e);
            }
        }
    }

    public void run(IAction action) {
        if (this.fTarget == null) {
            return;
        }
        int i = 0;
        while (i < this.fTarget.length) {
            IProject project;
            if (this.fTarget[i] instanceof IResource && !DLTKLanguageManager.hasScriptNature((IProject)(project = ((IResource)this.fTarget[i]).getProject()))) {
                this.install(project);
            }
            ++i;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fTarget = ((IStructuredSelection)selection).toArray();
            boolean enabled = true;
            Object[] objectArray = this.fTarget;
            int n = this.fTarget.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (!(obj instanceof IProject)) {
                    enabled = false;
                    break;
                }
                IProject project = (IProject)obj;
                if (!project.isAccessible() || DLTKLanguageManager.hasScriptNature((IProject)project)) {
                    enabled = false;
                    break;
                }
                ++n2;
            }
            action.setEnabled(enabled);
        } else {
            this.fTarget = null;
            action.setEnabled(false);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPart = targetPart;
    }
}

