/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.doubleclick;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPPairMatcher;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.w3c.dom.Node;

public class PHPDoubleClickStrategy
extends DefaultTextDoubleClickStrategy {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    protected PHPPairMatcher fPairMatcher = new PHPPairMatcher(BRACKETS);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doubleClicked(ITextViewer textViewer) {
        block14: {
            if (textViewer instanceof StructuredTextViewer) {
                IStructuredModel structuredModel;
                block12: {
                    block13: {
                        StructuredTextViewer structuredTextViewer = (StructuredTextViewer)textViewer;
                        structuredModel = null;
                        try {
                            IStructuredDocumentRegion sdRegion;
                            Node node;
                            int caretPosition;
                            structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(structuredTextViewer.getDocument());
                            if (structuredModel == null || (caretPosition = textViewer.getSelectedRange().x) <= 0 || (node = (Node)structuredModel.getIndexedRegion(caretPosition)) == null || (sdRegion = structuredModel.getStructuredDocument().getRegionAtCharacterOffset(caretPosition)) == null) break block12;
                            ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(caretPosition);
                            IStructuredDocumentRegion container = sdRegion;
                            if (tRegion instanceof ITextRegionContainer) {
                                container = (ITextRegionContainer)tRegion;
                                tRegion = container.getRegionAtCharacterOffset(caretPosition);
                            }
                            if (tRegion == null || tRegion.getType() != "PHP_CONTENT") break block12;
                            IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
                            if ((tRegion = phpScriptRegion.getPhpToken(caretPosition - container.getStartOffset() - phpScriptRegion.getStart())).getType() == "PHP_VARIABLE" || tRegion.getType() == "PHP_THIS" || PHPPartitionTypes.isPHPDocTagState((String)tRegion.getType())) {
                                structuredTextViewer.setSelectedRange(container.getStartOffset() + phpScriptRegion.getStart() + tRegion.getStart(), tRegion.getTextLength());
                            } else {
                                if (tRegion.getType() != "PHPDOC_COMMENT" && tRegion.getType() != "PHP_LINE_COMMENT" && tRegion.getType() != "PHP_COMMENT") break block12;
                                this.resetVariableSelectionRangeInComments(textViewer, structuredTextViewer);
                            }
                            if (structuredModel == null) break block13;
                        }
                        catch (BadLocationException e) {
                            PHPUiPlugin.log(e);
                            if (structuredModel != null) {
                                structuredModel.releaseFromRead();
                            }
                            break block14;
                        }
                        catch (Throwable throwable) {
                            if (structuredModel != null) {
                                structuredModel.releaseFromRead();
                            }
                            throw throwable;
                        }
                        structuredModel.releaseFromRead();
                    }
                    return;
                }
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        super.doubleClicked(textViewer);
    }

    protected IRegion findExtendedDoubleClickSelection(IDocument document, int offset) {
        IRegion match = this.fPairMatcher.match(document, offset);
        if (match != null && match.getLength() >= 2) {
            return new Region(match.getOffset() + 1, match.getLength() - 2);
        }
        return this.findWord(document, offset);
    }

    private void resetVariableSelectionRangeInComments(ITextViewer textViewer, StructuredTextViewer structuredTextViewer) throws BadLocationException {
        super.doubleClicked(textViewer);
        Point selectedRange = structuredTextViewer.getSelectedRange();
        int offset = selectedRange.x;
        if (offset > 0) {
            IDocument document = structuredTextViewer.getDocument();
            char previousChar = document.getChar(offset - 1);
            if (previousChar == '$') {
                structuredTextViewer.setSelectedRange(offset - 1, selectedRange.y + 1);
            } else if (selectedRange.y == 1 && document.getChar(offset) == '$') {
                structuredTextViewer.setSelectedRange(offset, selectedRange.y + 1);
            }
        }
    }
}

