/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;

public final class SemanticToken {
    private Identifier fNode;
    private Expression fLiteral;
    private IBinding fBinding;
    private boolean fIsBindingResolved = false;
    private Program fRoot;
    private boolean fIsRootResolved = false;

    public IBinding getBinding() {
        if (!this.fIsBindingResolved) {
            this.fIsBindingResolved = true;
            if (this.fNode != null) {
                this.fBinding = this.fNode.resolveBinding();
            }
        }
        return this.fBinding;
    }

    public Identifier getNode() {
        return this.fNode;
    }

    public Expression getLiteral() {
        return this.fLiteral;
    }

    public Program getRoot() {
        if (!this.fIsRootResolved) {
            this.fIsRootResolved = true;
            this.fRoot = (Program)(this.fNode != null ? this.fNode : this.fLiteral).getRoot();
        }
        return this.fRoot;
    }

    void update(Identifier node) {
        this.clear();
        this.fNode = node;
    }

    void update(Expression literal) {
        this.clear();
        this.fLiteral = literal;
    }

    void clear() {
        this.fNode = null;
        this.fLiteral = null;
        this.fBinding = null;
        this.fIsBindingResolved = false;
        this.fRoot = null;
        this.fIsRootResolved = false;
    }
}

