/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.BrowserInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.documentation.PHPDocumentationContentAccess;
import org.eclipse.php.internal.ui.documentation.PHPElementLinks;
import org.eclipse.php.internal.ui.editor.hover.AbstractPHPEditorTextHover;
import org.eclipse.php.internal.ui.editor.hover.PHPDocumentationBrowserInformationControlInput;
import org.eclipse.php.internal.ui.editor.hover.PHPHoverMessages;
import org.eclipse.php.internal.ui.util.Messages;
import org.eclipse.php.internal.ui.util.OpenBrowserUtil;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.osgi.framework.Bundle;

public class PHPDocumentationHover
extends AbstractPHPEditorTextHover
implements IPHPTextHover,
IInformationProviderExtension2 {
    private static final long LABEL_FLAGS = ScriptElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static String fgStyleSheet;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    public IHoverMessageDecorator getMessageDecorator() {
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    private static void addLinkListener(final BrowserInformationControl control) {
        control.addLocationListener(PHPElementLinks.createLocationListener(new PHPElementLinks.ILinkHandler(){

            public void handleInlineLink(IModelElement linkTarget) {
                PHPDocumentationBrowserInformationControlInput hoverInfo = PHPDocumentationHover.getHoverInfo(new IModelElement[]{linkTarget}, null, (PHPDocumentationBrowserInformationControlInput)control.getInput());
                if (control.hasDelayedInputChangeListener()) {
                    control.notifyDelayedInputChange((Object)hoverInfo);
                } else {
                    control.setInput((Object)hoverInfo);
                }
            }

            public void handleDeclarationLink(IModelElement linkTarget) {
                control.notifyDelayedInputChange(null);
                control.dispose();
            }

            public boolean handleExternalLink(URL url, Display display) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                OpenBrowserUtil.open(url, display);
                return true;
            }

            public void handleTextSet() {
            }
        }));
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        PHPDocumentationBrowserInformationControlInput info = (PHPDocumentationBrowserInformationControlInput)((Object)this.getHoverInfo2(textViewer, hoverRegion));
        return info != null ? info.getHtml() : null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.internalGetHoverInfo(textViewer, hoverRegion);
    }

    private PHPDocumentationBrowserInformationControlInput internalGetHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String constantValue;
        IModelElement[] elements = this.getElementsAt(textViewer, hoverRegion);
        if (elements == null || elements.length == 0) {
            return null;
        }
        TreeSet<IModelElement> elementSet = new TreeSet<IModelElement>(new Comparator<IModelElement>(){

            @Override
            public int compare(IModelElement o1, IModelElement o2) {
                if (o1 instanceof IType && o2 instanceof IType) {
                    IType type1 = (IType)o1;
                    IType type2 = (IType)o2;
                    try {
                        if (PHPFlags.isNamespace((int)type1.getFlags()) && PHPFlags.isNamespace((int)type2.getFlags()) && type1.getElementName().equals(type2.getElementName())) {
                            return 0;
                        }
                    }
                    catch (ModelException modelException) {}
                }
                return 1;
            }
        });
        ArrayList<IModelElement> elementList = new ArrayList<IModelElement>();
        int i = 0;
        while (i < elements.length) {
            if (!elementSet.contains(elements[i])) {
                elementSet.add(elements[i]);
                elementList.add(elements[i]);
            }
            ++i;
        }
        elements = elementList.toArray(new IModelElement[elementList.size()]);
        if (elements.length == 1 && elements[0].getElementType() == 8) {
            constantValue = this.getConstantValue((IField)elements[0], hoverRegion);
            if (constantValue != null) {
                constantValue = HTMLPrinter.convertToHTMLContent((String)constantValue);
            }
        } else {
            constantValue = null;
        }
        return PHPDocumentationHover.getHoverInfo(elements, constantValue, null);
    }

    private static PHPDocumentationBrowserInformationControlInput getHoverInfo(IModelElement[] elements, String constantValue, PHPDocumentationBrowserInformationControlInput previousInput) {
        int nResults = elements.length;
        StringBuffer buffer = new StringBuffer();
        boolean hasContents = false;
        IModelElement element = null;
        int leadingImageWidth = 0;
        if (nResults > 1) {
            int i = 0;
            while (i < elements.length) {
                HTMLPrinter.startBulletList((StringBuffer)buffer);
                IModelElement curr = elements[i];
                if (curr instanceof IMember || curr.getElementType() == 8) {
                    HTMLPrinter.addBullet((StringBuffer)buffer, (String)PHPDocumentationHover.getInfoText(curr, constantValue, false));
                    hasContents = true;
                }
                HTMLPrinter.endBulletList((StringBuffer)buffer);
                ++i;
            }
        } else {
            element = elements[0];
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)PHPDocumentationHover.getInfoText((IModelElement)member, constantValue, true));
                Reader reader = null;
                try {
                    reader = PHPDocumentationHover.getHTMLContent(member);
                }
                catch (ModelException modelException) {}
                if (reader != null) {
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
                }
                hasContents = true;
            } else if (element.getElementType() == 8) {
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)PHPDocumentationHover.getInfoText(element, constantValue, true));
                hasContents = true;
            }
            leadingImageWidth = 20;
        }
        if (!hasContents) {
            return null;
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)PHPDocumentationHover.getStyleSheet());
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return new PHPDocumentationBrowserInformationControlInput(previousInput, element, buffer.toString(), leadingImageWidth);
        }
        return null;
    }

    private static String getInfoText(IModelElement element, String constantValue, boolean allowImage) {
        URL imageUrl;
        StringBuffer label = PHPDocumentationHover.getInfoText(element);
        if (element.getElementType() == 8 && constantValue != null) {
            label.append(' ');
            label.append('=');
            label.append(' ');
            label.append(constantValue);
        }
        String imageName = null;
        if (allowImage && (imageUrl = PHPUiPlugin.getDefault().getImagesOnFSRegistry().getImageURL(element)) != null) {
            imageName = imageUrl.toExternalForm();
        }
        StringBuffer buf = new StringBuffer();
        PHPDocumentationHover.addImageAndLabel(buf, imageName, 16, 16, 2, 2, label.toString(), 20, 2);
        return buf.toString();
    }

    private static boolean isFinal(IField field) {
        try {
            return PHPFlags.isFinal((int)field.getFlags());
        }
        catch (ModelException e) {
            PHPUiPlugin.log(e);
            return false;
        }
    }

    private String getConstantValue(IField field, IRegion hoverRegion) {
        if (!PHPDocumentationHover.isFinal(field)) {
            return null;
        }
        ISourceModule typeRoot = this.getEditorInputModelElement();
        if (typeRoot == null) {
            return null;
        }
        Object constantValue = null;
        if (field != null && field.exists()) {
            try {
                ConstantDeclaration decl;
                Program unit = SharedASTProvider.getAST(field.getSourceModule(), SharedASTProvider.WAIT_YES, null);
                ASTNode node = NodeFinder.perform((ASTNode)unit, (int)field.getNameRange().getOffset(), (int)field.getNameRange().getLength());
                if (node != null && node instanceof Identifier && node.getParent() instanceof ConstantDeclaration && (decl = (ConstantDeclaration)node.getParent()).initializers().size() == 1 && decl.initializers().get(0) instanceof Scalar) {
                    Scalar scalar = (Scalar)decl.initializers().get(0);
                    constantValue = scalar.getStringValue();
                }
            }
            catch (ModelException modelException) {
            }
            catch (IOException iOException) {}
        }
        if (constantValue == null) {
            return null;
        }
        if (constantValue instanceof String) {
            StringBuffer result = new StringBuffer();
            String stringConstant = (String)constantValue;
            if (stringConstant.length() > 80) {
                result.append(stringConstant.substring(0, 80));
                result.append("...");
            } else {
                result.append(stringConstant);
            }
            return result.toString();
        }
        if (constantValue instanceof Integer) {
            int intValue = (Integer)constantValue;
            return PHPDocumentationHover.formatWithHexValue(constantValue, "0x" + Integer.toHexString(intValue));
        }
        return constantValue.toString();
    }

    private static String formatWithHexValue(Object constantValue, String hexValue) {
        return Messages.format(PHPHoverMessages.JavadocHover_constantValue_hexValue, new String[]{constantValue.toString(), hexValue});
    }

    protected static String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            fgStyleSheet = PHPDocumentationHover.loadStyleSheet();
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.dltk.ui.documentationFont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    /*
     * Loose catch block
     */
    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)PHPUiPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/PHPDocumentationHoverStyleSheet.css");
        if (styleSheetURL != null) {
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
            StringBuffer buffer = new StringBuffer(1500);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            String string = buffer.toString();
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return string;
            catch (IOException ex) {
                try {
                    PHPUiPlugin.log(ex);
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                return "";
            }
        }
        return null;
    }

    public static void addImageAndLabel(StringBuffer buf, String imageName, int imageWidth, int imageHeight, int imageLeft, int imageTop, String label, int labelLeft, int labelTop) {
        if (imageName != null) {
            StringBuffer imageStyle = new StringBuffer("position: absolute; ");
            imageStyle.append("width: ").append(imageWidth).append("px; ");
            imageStyle.append("height: ").append(imageHeight).append("px; ");
            imageStyle.append("top: ").append(imageTop).append("px; ");
            imageStyle.append("left: ").append(imageLeft).append("px; ");
            buf.append("<!--[if lte IE 6]><![if gte IE 5.5]>\n");
            buf.append("<span style=\"").append(imageStyle).append("filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(imageName).append("')\"></span>\n");
            buf.append("<![endif]><![endif]-->\n");
            buf.append("<!--[if !IE]>-->\n");
            buf.append("<img style='").append(imageStyle).append("' src='").append(imageName).append("'/>\n");
            buf.append("<!--<![endif]-->\n");
            buf.append("<!--[if gte IE 7]>\n");
            buf.append("<img style='").append(imageStyle).append("' src='").append(imageName).append("'/>\n");
            buf.append("<![endif]-->\n");
        }
        buf.append("<div style='word-wrap:break-word;");
        if (imageName != null) {
            buf.append("margin-left: ").append(labelLeft).append("px; ");
            buf.append("margin-top: ").append(labelTop).append("px; ");
        }
        buf.append("'>");
        buf.append(label);
        buf.append("</div>");
    }

    protected static Reader getHTMLContent(IMember curr) throws ModelException {
        String html = PHPDocumentationContentAccess.getHTMLContent(curr);
        if (html != null) {
            return new StringReader(html);
        }
        return null;
    }

    private static StringBuffer getInfoText(IModelElement member) {
        long flags = member.getElementType() == 8 ? LOCAL_VARIABLE_FLAGS : LABEL_FLAGS;
        String label = ScriptElementLabels.getDefault().getElementLabel(member, flags);
        return new StringBuffer(label);
    }

    private static final class BackAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public BackAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(PHPHoverMessages.JavadocHover_back);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput previous = (BrowserInformationControlInput)this.fInfoControl.getInput().getPrevious();
            if (previous != null) {
                this.fInfoControl.setInput((Object)previous);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getPrevious() != null) {
                BrowserInput previous = current.getPrevious();
                this.setToolTipText(Messages.format(PHPHoverMessages.JavadocHover_back_toElement_toolTip, BasicElementLabels.getJavaElementName((String)previous.getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(PHPHoverMessages.JavadocHover_back);
                this.setEnabled(false);
            }
        }
    }

    private static final class ForwardAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public ForwardAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(PHPHoverMessages.JavadocHover_forward);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput next = (BrowserInformationControlInput)this.fInfoControl.getInput().getNext();
            if (next != null) {
                this.fInfoControl.setInput((Object)next);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getNext() != null) {
                this.setToolTipText(Messages.format(PHPHoverMessages.JavadocHover_forward_toElement_toolTip, BasicElementLabels.getJavaElementName((String)current.getNext().getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(PHPHoverMessages.JavadocHover_forward_toolTip);
                this.setEnabled(false);
            }
        }
    }

    public static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fInformationPresenterControlCreator;

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
            this.fInformationPresenterControlCreator = informationPresenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            String tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                String font = "org.eclipse.dltk.ui.documentationFont";
                BrowserInformationControl iControl = new BrowserInformationControl(parent, font, tooltipAffordanceString){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return HoverControlCreator.this.fInformationPresenterControlCreator;
                    }
                };
                PHPDocumentationHover.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, tooltipAffordanceString);
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                String tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
                ((IInformationControlExtension4)control).setStatusText(tooltipAffordanceString);
            }
            return true;
        }
    }

    private static final class OpenDeclarationAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public OpenDeclarationAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(PHPHoverMessages.JavadocHover_openDeclaration);
            DLTKPluginImages.setLocalImageDescriptors((IAction)this, (String)"goto_input.gif");
        }

        public void run() {
            PHPDocumentationBrowserInformationControlInput infoInput = (PHPDocumentationBrowserInformationControlInput)this.fInfoControl.getInput();
            this.fInfoControl.notifyDelayedInputChange(null);
            this.fInfoControl.dispose();
            try {
                IEditorPart editor = EditorUtility.openInEditor((Object)infoInput.getElement(), (boolean)true);
                EditorUtility.revealInEditor((IEditorPart)editor, (IModelElement)infoInput.getElement());
            }
            catch (PartInitException e) {
                PHPUiPlugin.log(e);
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
        }
    }

    public static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        public IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                ToolBarManager tbm = new ToolBarManager(0x800000);
                String font = "org.eclipse.dltk.ui.documentationFont";
                BrowserInformationControl iControl = new BrowserInformationControl(parent, font, tbm);
                final BackAction backAction = new BackAction(iControl);
                backAction.setEnabled(false);
                tbm.add((IAction)backAction);
                final ForwardAction forwardAction = new ForwardAction(iControl);
                tbm.add((IAction)forwardAction);
                forwardAction.setEnabled(false);
                final OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction(iControl);
                tbm.add((IAction)openDeclarationAction);
                IInputChangedListener inputChangeListener = new IInputChangedListener(){

                    public void inputChanged(Object newInput) {
                        backAction.update();
                        forwardAction.update();
                        if (newInput != null && newInput instanceof BrowserInformationControlInput) {
                            BrowserInformationControlInput input = (BrowserInformationControlInput)newInput;
                            Object inputElement = input.getInputElement();
                            boolean isJavaElementInput = inputElement instanceof IModelElement;
                            openDeclarationAction.setEnabled(isJavaElementInput);
                        }
                    }
                };
                iControl.addInputChangeListener(inputChangeListener);
                tbm.update(true);
                PHPDocumentationHover.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, true);
        }
    }
}

