/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.templates;

import java.util.ArrayList;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.templates.ScriptTemplateAccess;
import org.eclipse.dltk.ui.templates.ScriptTemplateCompletionProcessor;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.window.Window;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.templates.PhpTemplateAccess;
import org.eclipse.php.internal.ui.editor.templates.PhpTemplateProposal;
import org.eclipse.php.internal.ui.text.template.contentassist.TemplateInformationControlCreator;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PhpTemplateCompletionProcessor
extends ScriptTemplateCompletionProcessor {
    private static final ICompletionProposal[] EMPTY_ICOMPLETION_PROPOSAL = new ICompletionProposal[0];
    private static final ICompletionProposal[] EMPTY = new ICompletionProposal[0];
    private String contextTypeId = "php";
    private static char[] IGNORE = new char[]{'.', ':', '@', '$'};

    public PhpTemplateCompletionProcessor(ScriptContentAssistInvocationContext context) {
        super(context);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        try {
            String type = TextUtilities.getContentType((IDocument)document, (String)"org.eclipse.wst.sse.core.default_structured_text_partitioning", (int)offset, (boolean)true);
            if (!"org.eclipse.php.PHP_DEFAULT".equals(type)) {
                return EMPTY;
            }
        }
        catch (BadLocationException badLocationException) {}
        if (this.isInDocOrCommentOrString(viewer, offset)) {
            return EMPTY;
        }
        ICompletionProposal[] completionProposals = super.computeCompletionProposals(viewer, offset);
        if (completionProposals == null) {
            return EMPTY;
        }
        return this.filterUsingPrefix(completionProposals, this.extractPrefix(viewer, offset));
    }

    private boolean isInDocOrCommentOrString(ITextViewer viewer, int offset) {
        block14: {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            if (modelManager != null) {
                IStructuredModel structuredModel = null;
                structuredModel = modelManager.getExistingModelForRead(viewer.getDocument());
                if (structuredModel != null) {
                    try {
                        IPhpScriptRegion phpScriptRegion;
                        String type;
                        IStructuredDocumentRegion sdRegion;
                        block13: {
                            DOMModelForPHP domModelForPHP = (DOMModelForPHP)structuredModel;
                            try {
                                IStructuredDocument document = domModelForPHP.getDocument().getStructuredDocument();
                                sdRegion = document.getRegionAtCharacterOffset(offset);
                                if (sdRegion != null) break block13;
                                return false;
                            }
                            catch (Exception e) {
                                Logger.logException((Throwable)e);
                                break block14;
                            }
                        }
                        ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(offset);
                        if (textRegion == null) {
                            return false;
                        }
                        IStructuredDocumentRegion container = sdRegion;
                        if (textRegion instanceof ITextRegionContainer) {
                            container = (ITextRegionContainer)textRegion;
                            textRegion = container.getRegionAtCharacterOffset(offset);
                        }
                        if (textRegion.getType() == "PHP_CONTENT" && (PHPPartitionTypes.isPHPMultiLineCommentState((String)(type = (textRegion = (phpScriptRegion = (IPhpScriptRegion)textRegion).getPhpToken(offset - container.getStartOffset() - phpScriptRegion.getStart())).getType())) || PHPPartitionTypes.isPHPDocState((String)type) || PHPPartitionTypes.isPHPLineCommentState((String)type) || PHPPartitionTypes.isPHPQuotesState((String)type))) {
                            return true;
                        }
                    }
                    finally {
                        structuredModel.releaseFromRead();
                    }
                }
            }
        }
        return false;
    }

    private ICompletionProposal[] filterUsingPrefix(ICompletionProposal[] completionProposals, String prefix) {
        if (prefix.length() == 0) {
            return EMPTY_ICOMPLETION_PROPOSAL;
        }
        ArrayList<PhpTemplateProposal> matches = new ArrayList<PhpTemplateProposal>();
        int i = 0;
        while (i < completionProposals.length) {
            PhpTemplateProposal phpTemplateProposal = (PhpTemplateProposal)completionProposals[i];
            Template template = phpTemplateProposal.getTemplateNew();
            if (template.getName().startsWith(prefix)) {
                matches.add(phpTemplateProposal);
            }
            ++i;
        }
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    /*
     * Unable to fully structure code
     */
    protected String extractPrefix(ITextViewer viewer, int offset) {
        i = offset;
        document = viewer.getDocument();
        if (i <= document.getLength()) ** GOTO lbl7
        return "";
        {
            while (Character.isLetterOrDigit(ch = document.getChar(i - 1)) || '@' == ch || '_' == ch || '$' == ch) {
                --i;
lbl7:
                // 2 sources

                if (i > 0) continue;
            }
            return document.get(i, offset - i);
        }
    }

    protected Template[] getTemplates(String contextTypeId) {
        Template[] templates = null;
        TemplateStore store = this.getTemplateStore();
        if (store != null) {
            templates = store.getTemplates(contextTypeId);
        }
        return templates;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        TemplateContextType type = null;
        ContextTypeRegistry registry = this.getTemplateContextRegistry();
        if (registry != null) {
            type = registry.getContextType(this.contextTypeId);
        }
        return type;
    }

    protected Image getImage(Template template) {
        return PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_TEMPLATE);
    }

    protected ContextTypeRegistry getTemplateContextRegistry() {
        return PHPUiPlugin.getDefault().getTemplateContextRegistry();
    }

    protected TemplateStore getTemplateStore() {
        return PHPUiPlugin.getDefault().getTemplateStore();
    }

    public void setContextTypeId(String contextTypeId) {
        this.contextTypeId = contextTypeId;
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return new PhpTemplateProposal(template, context, region, this.getImage(template), relevance);
    }

    protected IInformationControlCreator getInformationControlCreator() {
        int orientation = Window.getDefaultOrientation();
        IEditorPart editor = this.getContext().getEditor();
        if (editor == null) {
            editor = DLTKUIPlugin.getActivePage().getActiveEditor();
        }
        if (editor instanceof IWorkbenchPartOrientation) {
            orientation = ((IWorkbenchPartOrientation)editor).getOrientation();
        }
        return new TemplateInformationControlCreator(orientation);
    }

    protected String getContextTypeId() {
        return this.contextTypeId;
    }

    protected char[] getIgnore() {
        return IGNORE;
    }

    protected ScriptTemplateAccess getTemplateAccess() {
        return PhpTemplateAccess.getInstance();
    }
}

