/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.util;

import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.util.WeakObject;

public class WeakPropertyChangeListener
extends WeakObject
implements IPropertyChangeListener {
    private Object target;
    private static ReferenceQueue q = new ReferenceQueue();
    private static Class[] parameterTypes = new Class[]{IPropertyChangeListener.class};
    private static Object[] parameterValues = new Object[1];
    private static String removeListenerMethodName = "removePropertyChangeListener";

    public static WeakPropertyChangeListener create(IPropertyChangeListener l, Object target) {
        WeakPropertyChangeListener.removeRedundantReferences();
        return new WeakPropertyChangeListener(l, target);
    }

    public static void removeRedundantReferences() {
        WeakPropertyChangeListener r = (WeakPropertyChangeListener)((Object)q.poll());
        while (r != null) {
            WeakPropertyChangeListener.removeRedundantReference(r);
            r = (WeakPropertyChangeListener)((Object)q.poll());
        }
    }

    private static void removeRedundantReference(WeakPropertyChangeListener listener) {
        try {
            Method setMethod = listener.target.getClass().getMethod(removeListenerMethodName, parameterTypes);
            WeakPropertyChangeListener.parameterValues[0] = listener;
            setMethod.invoke(listener.target, parameterValues);
        }
        catch (Exception exc) {
            PHPCorePlugin.log((Throwable)exc);
        }
    }

    protected WeakPropertyChangeListener(IPropertyChangeListener l, Object target) {
        super((Object)l, q);
        this.target = target;
    }

    public void propertyChange(PropertyChangeEvent event) {
        IPropertyChangeListener l = (IPropertyChangeListener)this.get();
        if (l != null) {
            l.propertyChange(event);
        } else {
            WeakPropertyChangeListener.removeRedundantReference(this);
        }
    }
}

