/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.console;

import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.php.internal.debug.core.IPHPConsoleEventListener;
import org.eclipse.php.internal.debug.core.launching.DebugConsoleMonitor;
import org.eclipse.php.internal.debug.core.launching.PHPHyperLink;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.launching.PHPStreamsProxy;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.swt.graphics.Color;

public class PHPConsoleColorProvider
extends ConsoleColorProvider {
    private static IPHPConsoleEventListener[] fConsoleEventListeners;
    private PHPProcess fProcess;
    private IConsole fConsole;
    private ILaunch fLaunch;
    private PHPHyperLink fPHPHyperLink;
    private static final String PHP_DEBUG_STREAM;

    static {
        PHP_DEBUG_STREAM = String.valueOf(PHPDebugUIPlugin.getID()) + ".PHP_CONSOLE_STREAM";
    }

    public void connect(IProcess process, IConsole console) {
        this.fConsole = console;
        PHPStreamsProxy proxy = (PHPStreamsProxy)process.getStreamsProxy();
        if (!(process instanceof PHPProcess)) {
            return;
        }
        this.fProcess = (PHPProcess)process;
        this.fProcess.setConsole(this.fConsole);
        this.fPHPHyperLink = new PHPHyperLink();
        this.fProcess.setPHPHyperLink(this.fPHPHyperLink);
        DebugConsoleMonitor debugMonitor = (DebugConsoleMonitor)proxy.getConsoleStreamMonitor();
        this.fConsole.connect((IStreamMonitor)debugMonitor, PHP_DEBUG_STREAM);
        this.fLaunch = process.getLaunch();
        PHPDebugTarget target = null;
        if (this.fLaunch.getDebugTarget() instanceof PHPDebugTarget) {
            target = (PHPDebugTarget)this.fLaunch.getDebugTarget();
        }
        if (target != null) {
            IPHPConsoleEventListener[] listeners;
            IPHPConsoleEventListener[] iPHPConsoleEventListenerArray = listeners = PHPConsoleColorProvider.getConsoleEventListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IPHPConsoleEventListener eventListener = iPHPConsoleEventListenerArray[n2];
                eventListener.init(this.fLaunch, debugMonitor, this.fPHPHyperLink);
                target.addConsoleEventListener(eventListener);
                ++n2;
            }
        }
        super.connect(process, this.fConsole);
    }

    private static IPHPConsoleEventListener[] getConsoleEventListeners() {
        if (fConsoleEventListeners == null) {
            IConfigurationElement[] elements;
            HashMap<String, IPHPConsoleEventListener> listeners = new HashMap<String, IPHPConsoleEventListener>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PHPDebugUIPlugin.getID(), "phpConsoleListeners");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                IConfigurationElement element = iConfigurationElementArray[n2];
                if ("listener".equals(element.getName()) && !listeners.containsKey(id = element.getAttribute("id"))) {
                    String overridesIds = element.getAttribute("overridesId");
                    if (overridesIds != null) {
                        StringTokenizer st = new StringTokenizer(overridesIds, ", ");
                        while (st.hasMoreTokens()) {
                            listeners.put(st.nextToken(), null);
                        }
                    }
                    try {
                        listeners.put(id, (IPHPConsoleEventListener)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        PHPDebugUIPlugin.log(e);
                    }
                }
                ++n2;
            }
            Collection l = listeners.values();
            while (l.remove(null)) {
            }
            fConsoleEventListeners = l.toArray(new IPHPConsoleEventListener[listeners.size()]);
        }
        return fConsoleEventListeners;
    }

    public void disconnect() {
        this.fConsole = null;
        this.fProcess = null;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Color getColor(String streamIdentifer) {
        if (PHP_DEBUG_STREAM.equals(streamIdentifer)) {
            return DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.errorColor");
        }
        return null;
    }

    protected IProcess getProcess() {
        return this.fProcess;
    }

    protected IConsole getConsole() {
        return this.fConsole;
    }
}

