/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.rewrite;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.rewrite.RewriteEventStore;

public final class NodeInfoStore {
    private AST ast;
    private Map placeholderNodes;
    private Set collapsedNodes;

    public NodeInfoStore(AST ast) {
        this.ast = ast;
        this.placeholderNodes = null;
        this.collapsedNodes = null;
    }

    public final void markAsStringPlaceholder(ASTNode placeholder, String code) {
        StringPlaceholderData data = new StringPlaceholderData();
        data.code = code;
        this.setPlaceholderData(placeholder, data);
    }

    public final void markAsCopyTarget(ASTNode target, RewriteEventStore.CopySourceInfo copySource) {
        CopyPlaceholderData data = new CopyPlaceholderData();
        data.copySource = copySource;
        this.setPlaceholderData(target, data);
    }

    public final ASTNode newPlaceholderNode(int nodeType) {
        try {
            ASTNode node = this.ast.createInstance(nodeType);
            switch (node.getType()) {
                case 3: {
                    Assignment assignment = (Assignment)node;
                    assignment.setLeftHandSide(this.ast.newVariable("a"));
                    assignment.setOperator(0);
                    assignment.setRightHandSide(this.ast.newVariable("a"));
                    break;
                }
                case 37: {
                    InfixExpression expression = (InfixExpression)node;
                    expression.setLeft(this.ast.newScalar("a"));
                    expression.setOperator(18);
                    expression.setRight(this.ast.newVariable("a"));
                    break;
                }
                case 60: {
                    Variable variable = (Variable)node;
                    variable.setName(this.ast.newIdentifier(""));
                    break;
                }
                case 28: {
                    ForStatement forStatement = (ForStatement)node;
                    Assignment assignment1 = this.ast.newAssignment();
                    assignment1.setLeftHandSide(this.ast.newVariable("a"));
                    assignment1.setOperator(0);
                    assignment1.setRightHandSide(this.ast.newVariable("a"));
                    forStatement.initializers().add(assignment1);
                    InfixExpression expression1 = this.ast.newInfixExpression();
                    expression1.setLeft(this.ast.newScalar("a"));
                    expression1.setOperator(3);
                    expression1.setRight(this.ast.newVariable("a"));
                    forStatement.conditions().add(expression1);
                    PostfixExpression pexp = this.ast.newPostfixExpression();
                    pexp.setOperator(0);
                    pexp.setVariable(this.ast.newVariable("a"));
                    forStatement.updaters().add(pexp);
                    forStatement.setBody(this.ast.newBlock());
                }
            }
            return node;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public Block createCollapsePlaceholder() {
        Block placeHolder = this.ast.newBlock();
        if (this.collapsedNodes == null) {
            this.collapsedNodes = new HashSet();
        }
        this.collapsedNodes.add(placeHolder);
        return placeHolder;
    }

    public boolean isCollapsed(ASTNode node) {
        if (this.collapsedNodes != null) {
            return this.collapsedNodes.contains(node);
        }
        return false;
    }

    public Object getPlaceholderData(ASTNode node) {
        if (this.placeholderNodes != null) {
            return this.placeholderNodes.get(node);
        }
        return null;
    }

    private void setPlaceholderData(ASTNode node, PlaceholderData data) {
        if (this.placeholderNodes == null) {
            this.placeholderNodes = new IdentityHashMap();
        }
        this.placeholderNodes.put(node, data);
    }

    public void clear() {
        this.placeholderNodes = null;
        this.collapsedNodes = null;
    }

    protected static final class CopyPlaceholderData
    extends PlaceholderData {
        public RewriteEventStore.CopySourceInfo copySource;

        protected CopyPlaceholderData() {
        }

        public String toString() {
            return "[placeholder " + this.copySource + "]";
        }
    }

    static class PlaceholderData {
        PlaceholderData() {
        }
    }

    protected static final class StringPlaceholderData
    extends PlaceholderData {
        public String code;

        protected StringPlaceholderData() {
        }

        public String toString() {
            return "[placeholder string: " + this.code + "]";
        }
    }
}

