/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambdaFunctionDeclaration
extends Expression {
    private final boolean isReference;
    private final List<? extends Expression> lexicalVars;
    protected List<FormalParameter> arguments = new LinkedList<FormalParameter>();
    private Block body = new Block();

    public LambdaFunctionDeclaration(int start, int end, List<FormalParameter> formalParameters, List<? extends Expression> lexicalVars, Block body, boolean isReference) {
        super(start, end);
        if (formalParameters != null) {
            this.arguments = formalParameters;
        }
        this.body = body;
        this.lexicalVars = lexicalVars;
        this.isReference = isReference;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit) {
            for (FormalParameter formalParameter : this.arguments) {
                formalParameter.traverse(visitor);
            }
            if (this.lexicalVars != null) {
                for (Expression expression : this.lexicalVars) {
                    expression.traverse(visitor);
                }
            }
            if (this.body != null) {
                this.body.traverse(visitor);
            }
        }
        visitor.endvisit((Expression)this);
    }

    public Collection<? extends Expression> getLexicalVars() {
        return this.lexicalVars;
    }

    public Collection<FormalParameter> getArguments() {
        return this.arguments;
    }

    public Block getBody() {
        return this.body;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }

    public int getKind() {
        return 73;
    }
}

