/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dnd;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;

public class ExternalFileDropAdapter
extends DropTargetAdapter {
    private static ExternalFileDropAdapter instance;

    private ExternalFileDropAdapter() {
    }

    public static ExternalFileDropAdapter getInstance() {
        if (instance == null) {
            instance = new ExternalFileDropAdapter();
        }
        return instance;
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = 1;
    }

    public void drop(final DropTargetEvent event) {
        if (event.data instanceof String[]) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    String[] files;
                    String[] stringArray = files = (String[])event.data;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String file = stringArray[n2];
                        try {
                            EditorUtility.openLocalFile(file, 0);
                        }
                        catch (CoreException e) {
                            Logger.logException(e);
                        }
                        ++n2;
                    }
                }
            });
        }
    }
}

