/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.folding.IStructuredTextFoldingProvider;
import org.eclipse.php.ui.folding.IPHPFoldingPreferenceBlock;

public final class PHPFoldingStructureProviderDescriptor {
    private static final String PREFERENCES_CLASS = "preferencesClass";
    private static final String CLASS = "class";
    private static final String NAME = "name";
    private static final String ID = "id";
    private String fId;
    private String fName;
    private boolean fHasPreferences;
    private IConfigurationElement fElement;

    PHPFoldingStructureProviderDescriptor(IConfigurationElement element) {
        this.fElement = element;
        this.fId = element.getAttributeAsIs(ID);
        Assert.isLegal((this.fId != null ? 1 : 0) != 0);
        this.fName = element.getAttribute(NAME);
        if (this.fName == null) {
            this.fName = this.fId;
        }
        this.fHasPreferences = element.getAttributeAsIs(PREFERENCES_CLASS) != null;
    }

    public IStructuredTextFoldingProvider createProvider() throws CoreException {
        IStructuredTextFoldingProvider prov = (IStructuredTextFoldingProvider)this.fElement.createExecutableExtension(CLASS);
        return prov;
    }

    public IPHPFoldingPreferenceBlock createPreferences() throws CoreException {
        if (this.fHasPreferences) {
            IPHPFoldingPreferenceBlock prefs = (IPHPFoldingPreferenceBlock)this.fElement.createExecutableExtension(PREFERENCES_CLASS);
            return prefs;
        }
        throw new IllegalStateException(PHPUIMessages.PHPFoldingStructureProviderDescriptor_0);
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }
}

