/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocContext;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

public abstract class PHPDocTagContext
extends PHPDocContext {
    private String tagName;

    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        int tagStart;
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        TextSequence statementText = this.getStatementText();
        int tagEnd = statementText.length();
        boolean found = false;
        do {
            tagEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, tagEnd);
            tagStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.getPhpVersion(), this.getStatementText(), tagEnd, true);
            this.tagName = statementText.subSequence(tagStart, tagEnd).toString();
            if (tagStart > 0 && statementText.charAt(tagStart - 1) == '@') {
                found = true;
            }
            tagEnd = tagStart - 1;
        } while (!found && tagStart > 0);
        return found;
    }

    public String getTagName() {
        return this.tagName;
    }
}

