/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class CatchClause
extends Statement {
    private final TypeReference className;
    private final VariableReference variable;
    private final Block statement;

    public CatchClause(int start, int end, TypeReference className, VariableReference variable, Block statement) {
        super(start, end);
        assert (className != null && variable != null && statement != null);
        this.className = className;
        this.variable = variable;
        this.statement = statement;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            this.className.traverse(visitor);
            this.variable.traverse(visitor);
            this.statement.traverse(visitor);
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 9;
    }

    public TypeReference getClassName() {
        return this.className;
    }

    public Block getStatement() {
        return this.statement;
    }

    public VariableReference getVariable() {
        return this.variable;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

