/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.dom.AttrImplForPhp;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPhp;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.format.CaseDefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.CommentIndentationStrategy;
import org.eclipse.php.internal.core.format.CurlyCloseIndentationStrategy;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.php.internal.core.format.PHPCloseTagIndentationStrategy;
import org.eclipse.php.internal.core.format.PhpFormatConstraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.text.rules.SimpleStructuredRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class PhpFormatter
implements IStructuredFormatter {
    private final IIndentationStrategy defaultIndentationStrategy = new DefaultIndentationStrategy();
    private final IIndentationStrategy curlyCloseIndentationStrategy = new CurlyCloseIndentationStrategy();
    private final IIndentationStrategy caseDefaultIndentationStrategy = new CaseDefaultIndentationStrategy();
    private final IIndentationStrategy commentIndentationStrategy = new CommentIndentationStrategy();
    private final IIndentationStrategy phpCloseTagIndentationStrategy = new PHPCloseTagIndentationStrategy();
    protected PhpFormatConstraints fFormatContraints = null;
    protected IStructuredFormatPreferences fFormatPreferences = null;
    protected IProgressMonitor fProgressMonitor = null;
    private final int length;
    private final int start;
    private static final byte CHAR_TAB = 9;
    private static final byte CHAR_SPACE = 32;
    private final StringBuffer resultBuffer = new StringBuffer();

    public PhpFormatter(int start, int length) {
        this.start = start;
        this.length = length;
    }

    public void format(Node node) {
        this.format(node, this.getFormatContraints());
    }

    public void format(Node node, IStructuredFormatContraints formatContraints) {
        if (node instanceof IDOMNode) {
            this.formatNode((IDOMNode)node, formatContraints);
        }
    }

    private void formatNode(IDOMNode node, IStructuredFormatContraints formatContraints) {
        if (node instanceof ElementImplForPhp && ((ElementImplForPhp)node).isPhpTag()) {
            IStructuredDocumentRegion sdRegionStart = node.getStartStructuredDocumentRegion();
            this.format(sdRegionStart);
        }
        if (node instanceof AttrImplForPhp) {
            IStructuredDocument document = node.getStructuredDocument();
            int lineIndex = document.getLineOfOffset(node.getStartOffset());
            int endLineIndex = document.getLineOfOffset(node.getEndOffset());
            while (lineIndex <= endLineIndex) {
                this.formatLine(document, lineIndex);
                ++lineIndex;
            }
        }
        if (node.hasChildNodes()) {
            IDOMNode child = (IDOMNode)node.getFirstChild();
            while (child != null) {
                this.formatNode(child, formatContraints);
                child = (IDOMNode)child.getNextSibling();
            }
        }
    }

    public IStructuredFormatContraints getFormatContraints() {
        if (this.fFormatContraints == null) {
            this.fFormatContraints = new PhpFormatConstraints();
        }
        return this.fFormatContraints;
    }

    public IStructuredFormatPreferences getFormatPreferences() {
        return this.fFormatPreferences;
    }

    public void setFormatPreferences(IStructuredFormatPreferences formatPreferences) {
        this.fFormatPreferences = formatPreferences;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    protected final int getStart() {
        return this.start;
    }

    protected final int getLength() {
        return this.length;
    }

    private void format(IStructuredDocumentRegion sdRegion) {
        assert (sdRegion != null);
        int regionStart = sdRegion.getStartOffset();
        int regionEnd = sdRegion.getEnd();
        int formatRequestStart = this.getStart();
        int formatRequestEnd = formatRequestStart + this.getLength();
        int startFormat = Math.max(formatRequestStart, regionStart);
        int endFormat = Math.min(formatRequestEnd, regionEnd);
        IStructuredDocument document = sdRegion.getParentDocument();
        int lineIndex = document.getLineOfOffset(startFormat);
        int endLineIndex = document.getLineOfOffset(endFormat);
        while (lineIndex <= endLineIndex) {
            this.formatLine(document, lineIndex);
            ++lineIndex;
        }
    }

    private void formatLine(IStructuredDocument document, int lineNumber) {
        this.resultBuffer.setLength(0);
        try {
            String firstTokenType;
            IPhpScriptRegion scriptRegion;
            int originalTextEnd;
            IRegion originalLineInfo = document.getLineInformation(lineNumber);
            int orginalLineStart = originalLineInfo.getOffset();
            int originalLineLength = originalLineInfo.getLength();
            if (originalLineLength == 0) {
                return;
            }
            String lineText = document.get(orginalLineStart, originalLineLength);
            IRegion formattedLineInformation = this.getFormattedLineInformation(originalLineInfo, lineText);
            if (!this.shouldReformat(document, formattedLineInformation)) {
                return;
            }
            int formattedLineStart = formattedLineInformation.getOffset();
            int formattedTextEnd = formattedLineStart + formattedLineInformation.getLength();
            if (formattedTextEnd != (originalTextEnd = orginalLineStart + originalLineLength)) {
                document.replace(formattedTextEnd, originalTextEnd - formattedTextEnd, "");
                if (formattedLineStart == formattedTextEnd) {
                    return;
                }
            }
            int startingWhiteSpaces = formattedLineStart - orginalLineStart;
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(formattedLineStart);
            ITextRegion firstTokenInLine = sdRegion.getRegionAtCharacterOffset(formattedLineStart);
            int regionStart = sdRegion.getStartOffset(firstTokenInLine);
            if (firstTokenInLine instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)firstTokenInLine;
                firstTokenInLine = container.getRegionAtCharacterOffset(formattedLineStart);
                regionStart += firstTokenInLine.getStart();
            }
            if (firstTokenInLine instanceof IPhpScriptRegion && (firstTokenInLine = (scriptRegion = (IPhpScriptRegion)firstTokenInLine).getPhpToken(formattedLineStart - regionStart)) != null && firstTokenInLine.getStart() + sdRegion.getStartOffset() < orginalLineStart && firstTokenInLine.getType() == "WHITESPACE") {
                firstTokenInLine = scriptRegion.getPhpToken(formattedLineStart - regionStart + firstTokenInLine.getLength());
            }
            if (firstTokenInLine == null) {
                return;
            }
            if (firstTokenInLine == null) {
                // empty if block
            }
            IIndentationStrategy insertionStrategy = (firstTokenType = firstTokenInLine.getType()) == "PHP_CASE" || firstTokenType == "PHP_DEFAULT" ? this.caseDefaultIndentationStrategy : (this.isPHPCommentRegion(firstTokenType) ? this.commentIndentationStrategy : (firstTokenType == "PHP_CLOSETAG" ? this.phpCloseTagIndentationStrategy : this.getIndentationStrategy(lineText.charAt(startingWhiteSpaces))));
            insertionStrategy.placeMatchingBlanks(document, this.resultBuffer, lineNumber, document.getLineOffset(lineNumber));
            String newIndentation = this.resultBuffer.toString();
            String oldIndentation = lineText.substring(0, startingWhiteSpaces);
            char newChar = '\u0000';
            if (newIndentation.length() > 0) {
                newChar = newIndentation.charAt(0);
            }
            char oldChar = '\u0000';
            if (oldIndentation.length() > 0) {
                oldChar = oldIndentation.charAt(0);
            }
            if (newIndentation.length() != oldIndentation.length() || newChar != oldChar) {
                document.replaceText((Object)sdRegion, orginalLineStart, startingWhiteSpaces, newIndentation);
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private boolean isPHPCommentRegion(String tokenType) {
        return tokenType == "PHP_COMMENT" || tokenType == "PHP_COMMENT_END" || tokenType == "PHPDOC_COMMENT" || tokenType == "PHPDOC_COMMENT_END";
    }

    private IRegion getFormattedLineInformation(IRegion lineInfo, String lineText) {
        int leftNonWhitespaceChar = 0;
        int rightNonWhitespaceChar = lineText.length() - 1;
        char[] chars = lineText.toCharArray();
        boolean keepSearching = true;
        while (keepSearching) {
            boolean rightIsWhiteSpace;
            boolean leftIsWhiteSpace = chars[leftNonWhitespaceChar] == ' ' || chars[leftNonWhitespaceChar] == '\t';
            boolean bl = rightIsWhiteSpace = chars[rightNonWhitespaceChar] == ' ' || chars[rightNonWhitespaceChar] == '\t';
            if (leftIsWhiteSpace) {
                ++leftNonWhitespaceChar;
            }
            if (rightIsWhiteSpace) {
                --rightNonWhitespaceChar;
            }
            boolean bl2 = keepSearching = (leftIsWhiteSpace || rightIsWhiteSpace) && leftNonWhitespaceChar < rightNonWhitespaceChar;
        }
        if (leftNonWhitespaceChar > rightNonWhitespaceChar) {
            return new SimpleStructuredRegion(lineInfo.getOffset(), 0);
        }
        return leftNonWhitespaceChar == 0 && rightNonWhitespaceChar == lineText.length() - 1 ? lineInfo : new SimpleStructuredRegion(lineInfo.getOffset() + leftNonWhitespaceChar, rightNonWhitespaceChar - leftNonWhitespaceChar + 1);
    }

    private boolean shouldReformat(IStructuredDocument document, IRegion lineInfo) {
        String checkedLineBeginState = FormatterUtils.getPartitionType(document, lineInfo.getOffset());
        return checkedLineBeginState == "org.eclipse.php.PHP_DEFAULT" || checkedLineBeginState == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || checkedLineBeginState == "org.eclipse.php.PHP_SINGLE_LINE_COMMENT" || checkedLineBeginState == "org.eclipse.php.PHP_DOC";
    }

    protected IIndentationStrategy getIndentationStrategy(char c) {
        if (c == '}') {
            return this.curlyCloseIndentationStrategy;
        }
        return this.getDefaultIndentationStrategy();
    }

    private IIndentationStrategy getDefaultIndentationStrategy() {
        return this.defaultIndentationStrategy;
    }
}

