/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.index;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.IElementResolver;
import org.eclipse.dltk.internal.core.MethodParameterInfo;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.core.SourceMethodUtils;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.index.IPHPDocAwareElement;
import org.eclipse.php.internal.core.model.IncludeField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpElementResolver
implements IElementResolver {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(",");
    private static final String[] EMPTY = new String[0];

    public IModelElement resolve(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule) {
        Object parentElement = (ModelElement)sourceModule;
        if (qualifier != null) {
            parentElement = new IndexType((ModelElement)parentElement, qualifier, 2048, 0, 0, 0, 0, null, doc);
        }
        if (parent != null) {
            parentElement = new SourceType(parentElement, parent);
        }
        switch (elementType) {
            case 7: {
                String[] superClassNames = null;
                if (metadata != null) {
                    superClassNames = SEPARATOR_PATTERN.split(metadata);
                }
                return new IndexType((ModelElement)parentElement, elementName, flags, offset, length, nameOffset, nameLength, superClassNames, doc);
            }
            case 9: {
                String[] parameters = metadata != null ? SEPARATOR_PATTERN.split(metadata) : EMPTY;
                return new IndexMethod((ModelElement)parentElement, elementName, flags, offset, length, nameOffset, nameLength, parameters, doc);
            }
            case 8: {
                return new IndexField((ModelElement)parentElement, elementName, flags, offset, length, nameOffset, nameLength, doc);
            }
            case 12: {
                return new IncludeField((ModelElement)parentElement, metadata);
            }
        }
        Logger.log(2, String.valueOf(PhpElementResolver.class.getName()) + ": Unsupported element type (" + elementType + ")");
        return null;
    }

    protected static Map<String, String> decodeDocInfo(String doc) {
        if (doc == null) {
            return null;
        }
        HashMap<String, String> info = new HashMap<String, String>();
        StringTokenizer tok = new StringTokenizer(doc, ";");
        while (tok.hasMoreTokens()) {
            String key = tok.nextToken();
            String value = null;
            int i = key.indexOf(58);
            if (i != -1) {
                value = key.substring(i + 1);
                key = key.substring(0, i);
            }
            info.put(key, value);
        }
        return info;
    }

    protected static boolean isDeprecated(String doc) {
        Map<String, String> info = PhpElementResolver.decodeDocInfo(doc);
        return info != null && info.containsKey("d");
    }

    private static class IndexField
    extends SourceField
    implements IPHPDocAwareElement {
        private int flags;
        private ISourceRange sourceRange;
        private ISourceRange nameRange;
        private String doc;

        public IndexField(ModelElement parent, String name, int flags, int offset, int length, int nameOffset, int nameLength, String doc) {
            super(parent, name);
            this.flags = flags;
            this.sourceRange = new SourceRange(offset, length);
            this.nameRange = new SourceRange(nameOffset, nameLength);
            this.doc = doc;
        }

        public int getFlags() throws ModelException {
            return this.flags;
        }

        public ISourceRange getNameRange() throws ModelException {
            return this.nameRange;
        }

        public ISourceRange getSourceRange() throws ModelException {
            return this.sourceRange;
        }

        public boolean isDeprecated() {
            return PhpElementResolver.isDeprecated(this.doc);
        }

        public String[] getReturnTypes() {
            return null;
        }
    }

    private static class IndexMethod
    extends SourceMethod
    implements IPHPDocAwareElement {
        private static final Pattern ARRAY_TYPE_PATTERN = Pattern.compile("array\\[.*\\]");
        private int flags;
        private ISourceRange sourceRange;
        private ISourceRange nameRange;
        private IParameter[] parameters;
        private String doc;

        public IndexMethod(ModelElement parent, String name, int flags, int offset, int length, int nameOffset, int nameLength, String[] parameterNames, String doc) {
            super(parent, name);
            this.flags = flags;
            this.sourceRange = new SourceRange(offset, length);
            this.nameRange = new SourceRange(nameOffset, nameLength);
            this.parameters = new IParameter[0];
            if (parameterNames != null) {
                this.parameters = new IParameter[parameterNames.length];
                int i = 0;
                while (i < parameterNames.length) {
                    String[] values = parameterNames[i].split("\\|");
                    if (values.length == 1) {
                        this.parameters[i] = new MethodParameterInfo(values[0]);
                    } else {
                        String type = values[0];
                        if ("#".equals(type)) {
                            type = null;
                        }
                        String param = values[1];
                        String defaultValue = values[2];
                        if ("#".equals(defaultValue)) {
                            defaultValue = null;
                        }
                        this.parameters[i] = new MethodParameterInfo(param, type, defaultValue);
                    }
                    ++i;
                }
            }
            this.doc = doc;
        }

        public int getFlags() throws ModelException {
            return this.flags;
        }

        public ISourceRange getNameRange() throws ModelException {
            return super.getNameRange();
        }

        public ISourceRange getSourceRange() throws ModelException {
            return this.sourceRange;
        }

        public IParameter[] getParameters() throws ModelException {
            return this.parameters;
        }

        public String[] getParameterNames() throws ModelException {
            return SourceMethodUtils.getParameterNames((IParameter[])this.parameters);
        }

        public boolean isConstructor() throws ModelException {
            return (this.flags & 0x100000) != 0;
        }

        public boolean isDeprecated() {
            return PhpElementResolver.isDeprecated(this.doc);
        }

        public String[] getReturnTypes() {
            String types;
            Map<String, String> info = PhpElementResolver.decodeDocInfo(this.doc);
            if (info != null && (types = info.get("r")) != null) {
                String[] returnTypes = types.split(",");
                int i = 0;
                while (i < returnTypes.length) {
                    returnTypes[i] = returnTypes[i].replaceAll("~", ",");
                    ++i;
                }
                return returnTypes;
            }
            return null;
        }
    }

    private static class IndexType
    extends SourceType
    implements IPHPDocAwareElement {
        private int flags;
        private ISourceRange sourceRange;
        private ISourceRange nameRange;
        private String[] superClassNames;
        private String doc;

        public IndexType(ModelElement parent, String name, int flags, int offset, int length, int nameOffset, int nameLength, String[] superClassNames, String doc) {
            super(parent, name);
            this.flags = flags;
            this.sourceRange = new SourceRange(offset, length);
            this.nameRange = new SourceRange(nameOffset, nameLength);
            this.superClassNames = superClassNames;
            this.doc = doc;
        }

        public int getFlags() throws ModelException {
            return this.flags;
        }

        public ISourceRange getNameRange() throws ModelException {
            return super.getNameRange();
        }

        public ISourceRange getSourceRange() throws ModelException {
            return this.sourceRange;
        }

        public String[] getSuperClasses() throws ModelException {
            return this.superClassNames;
        }

        public boolean isDeprecated() {
            return PhpElementResolver.isDeprecated(this.doc);
        }

        public String[] getReturnTypes() {
            return null;
        }
    }
}

