/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.actions;

import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.actions.EvaluationContextManager;
import org.eclipse.php.internal.debug.ui.watch.IWatchExpressionResultExtension;
import org.eclipse.php.internal.debug.ui.watch.PHPWatchExpressionDelegate;
import org.eclipse.php.internal.debug.ui.watch.XDebugWatchExpressionDelegate;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public class PopupInspectAction
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate,
IEditorActionDelegate,
IPartListener,
IViewActionDelegate {
    public static final String ACTION_DEFININITION_ID = "org.eclipse.php.debug.ui.commands.Inspect";
    private IAction fAction;
    private IWorkbenchPart fTargetPart;
    private IWorkbenchWindow fWindow;
    private IRegion fRegion;
    private boolean fEvaluating;
    private IWorkbenchPart fNewTargetPart = null;
    private IDebugModelPresentation fPresentation;
    private IExpression expression;
    private ITextEditor fTextEditor;
    private ISelection fSelectionBeforeEvaluation;
    private IWatchExpressionListener watchExpressionListener;

    protected String getObjectContext() {
        ISelection sec;
        IWorkbenchPage page = PHPUiPlugin.getActivePage();
        IStructuredSelection selection = null;
        if (page != null && (sec = page.getSelection()) instanceof IStructuredSelection) {
            selection = (IStructuredSelection)sec;
        }
        if (selection instanceof TextSelection) {
            TextSelection textSelection = (TextSelection)selection;
            return textSelection.getText();
        }
        return null;
    }

    protected IStackFrame getStackFrameContext() {
        IWorkbenchPart part = this.getTargetPart();
        IStackFrame frame = null;
        frame = part == null ? EvaluationContextManager.getEvaluationContext(this.getWindow()) : EvaluationContextManager.getEvaluationContext(part);
        return frame;
    }

    public void evaluationComplete(IWatchExpressionResult result) {
        if (PHPDebugUIPlugin.getDefault() == null) {
            return;
        }
        IValue value = result.getValue();
        if (result.hasErrors() || value != null) {
            Display display = PHPDebugUIPlugin.getStandardDisplay();
            if (display.isDisposed()) {
                return;
            }
            this.displayResult(result);
        }
    }

    protected void evaluationCleanup() {
        this.setEvaluating(false);
        this.setTargetPart(this.fNewTargetPart);
    }

    protected void displayResult(final IWatchExpressionResult result) {
        IWorkbenchPart part = this.getTargetPart();
        final StyledText styledText = PopupInspectAction.getStyledText(part);
        if (styledText != null) {
            this.expression = new IExpression(){

                public String getModelIdentifier() {
                    return this.getDebugTarget().getModelIdentifier();
                }

                public ILaunch getLaunch() {
                    return this.getDebugTarget().getLaunch();
                }

                public Object getAdapter(Class adapter) {
                    return AdapterManager.getDefault().getAdapter((Object)this, adapter);
                }

                public String getExpressionText() {
                    return result.getExpressionText();
                }

                public IValue getValue() {
                    return result.getValue();
                }

                public IDebugTarget getDebugTarget() {
                    IValue value = this.getValue();
                    if (value != null) {
                        return this.getValue().getDebugTarget();
                    }
                    if (result instanceof IWatchExpressionResultExtension) {
                        return ((IWatchExpressionResultExtension)result).getDebugTarget();
                    }
                    return null;
                }

                public void dispose() {
                }
            };
            PHPDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    PopupInspectAction.this.showPopup(styledText);
                }
            });
        }
        this.evaluationCleanup();
    }

    protected void showPopup(StyledText textWidget) {
        IWorkbenchPart part = this.getTargetPart();
        if (part instanceof ITextEditor) {
            this.fTextEditor = (ITextEditor)part;
            this.fSelectionBeforeEvaluation = this.getTargetSelection();
        }
        InspectPopupDialog displayPopup = new InspectPopupDialog(this.getShell(), PopupInspectAction.getPopupAnchor(textWidget), ACTION_DEFININITION_ID, this.expression){

            public boolean close() {
                boolean returnValue = super.close();
                if (PopupInspectAction.this.fTextEditor != null && PopupInspectAction.this.fSelectionBeforeEvaluation != null) {
                    PopupInspectAction.this.fTextEditor.getSelectionProvider().setSelection(PopupInspectAction.this.fSelectionBeforeEvaluation);
                    PopupInspectAction.this.fTextEditor = null;
                    PopupInspectAction.this.fSelectionBeforeEvaluation = null;
                }
                return returnValue;
            }
        };
        displayPopup.open();
    }

    protected void run() {
        String expression = this.getObjectContext();
        IStackFrame stackFrame = this.getStackFrameContext();
        if (stackFrame == null) {
            return;
        }
        if (this.watchExpressionListener == null) {
            this.watchExpressionListener = new IWatchExpressionListener(){

                public void watchEvaluationFinished(IWatchExpressionResult result) {
                    PopupInspectAction.this.evaluationComplete(result);
                }
            };
        }
        if (stackFrame instanceof DBGpStackFrame) {
            new XDebugWatchExpressionDelegate().evaluateExpression(expression, (IDebugElement)stackFrame, this.watchExpressionListener);
        } else if (stackFrame instanceof PHPStackFrame) {
            new PHPWatchExpressionDelegate().evaluateExpression(expression, (IDebugElement)stackFrame, this.watchExpressionListener);
        }
    }

    protected ISelection getTargetSelection() {
        ISelectionProvider provider;
        IWorkbenchPart part = this.getTargetPart();
        if (part != null && (provider = part.getSite().getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return null;
    }

    protected boolean compareToEditorInput(IStackFrame stackFrame) {
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return false;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return false;
        }
        Object sourceElement = locator.getSourceElement(stackFrame);
        if (sourceElement == null) {
            return false;
        }
        IEditorInput sfEditorInput = this.getDebugModelPresentation().getEditorInput(sourceElement);
        if (this.getTargetPart() instanceof IEditorPart) {
            return ((IEditorPart)this.getTargetPart()).getEditorInput().equals(sfEditorInput);
        }
        return false;
    }

    protected Shell getShell() {
        if (this.getTargetPart() != null) {
            return this.getTargetPart().getSite().getShell();
        }
        return PHPDebugUIPlugin.getActiveWorkbenchShell();
    }

    protected boolean textHasContent(String text) {
        int length;
        if (text != null && (length = text.length()) > 0) {
            int i = 0;
            while (i < length) {
                if (Character.isLetterOrDigit(text.charAt(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void run(IAction action) {
        if (PHPUiPlugin.getActivePage() != null) {
            this.setTargetPart(PHPUiPlugin.getActivePage().getActivePart());
        }
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            action.setEnabled(textSelection.getLength() != 0);
        }
    }

    public void dispose() {
        this.disposeDebugModelPresentation();
        IWorkbenchWindow win = this.getWindow();
        if (win != null) {
            win.getPartService().removePartListener((IPartListener)this);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.setWindow(window);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            this.setTargetPart(page.getActivePart());
        }
        window.getPartService().addPartListener((IPartListener)this);
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IDebugModelPresentation getDebugModelPresentation() {
        if (this.fPresentation == null) {
            this.fPresentation = DebugUITools.newDebugModelPresentation((String)"org.eclipse.php.debug.core");
        }
        return this.fPresentation;
    }

    protected void disposeDebugModelPresentation() {
        if (this.fPresentation != null) {
            this.fPresentation.dispose();
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setAction(action);
        this.setTargetPart((IWorkbenchPart)targetEditor);
    }

    public void partActivated(IWorkbenchPart part) {
        this.setTargetPart(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.getTargetPart()) {
            this.setTargetPart(null);
        }
        if (part == this.getNewTargetPart()) {
            this.setNewTargetPart(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void init(IViewPart view) {
        this.setTargetPart((IWorkbenchPart)view);
    }

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected void setTargetPart(IWorkbenchPart part) {
        if (this.isEvaluating()) {
            this.setNewTargetPart(part);
        } else {
            this.fTargetPart = part;
        }
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.setAction(action);
        this.setTargetPart(targetPart);
    }

    protected IWorkbenchPart getNewTargetPart() {
        return this.fNewTargetPart;
    }

    protected void setNewTargetPart(IWorkbenchPart newTargetPart) {
        this.fNewTargetPart = newTargetPart;
    }

    protected boolean isEvaluating() {
        return this.fEvaluating;
    }

    protected void setEvaluating(boolean evaluating) {
        this.fEvaluating = evaluating;
    }

    protected IRegion getRegion() {
        return this.fRegion;
    }

    public static StyledText getStyledText(IWorkbenchPart part) {
        ITextViewer viewer = (ITextViewer)part.getAdapter(ITextViewer.class);
        StyledText textWidget = null;
        if (viewer == null) {
            Control control = (Control)part.getAdapter(Control.class);
            if (control instanceof StyledText) {
                textWidget = (StyledText)control;
            }
        } else {
            textWidget = viewer.getTextWidget();
        }
        return textWidget;
    }

    public static Point getPopupAnchor(StyledText textWidget) {
        if (textWidget != null) {
            Point docRange = textWidget.getSelectionRange();
            int midOffset = docRange.x + docRange.y / 2;
            Point point = textWidget.getLocationAtOffset(midOffset);
            point = textWidget.toDisplay(point);
            GC gc = new GC((Drawable)textWidget);
            gc.setFont(textWidget.getFont());
            int height = gc.getFontMetrics().getHeight();
            gc.dispose();
            point.y += height;
            return point;
        }
        return null;
    }
}

