/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.actions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.actions.variables.ChangeVariableValueInputDialog;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStringValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;

public class XDebugVariableValueEditor
implements IVariableValueEditor {
    public boolean editVariable(IVariable variable, Shell shell) {
        try {
            String name = variable.getName();
            String title = PHPDebugUIMessages.PHPPrimitiveValueEditor_0;
            String message = MessageFormat.format((String)PHPDebugUIMessages.PHPPrimitiveValueEditor_1, (Object[])new Object[]{name});
            String initialValue = this.getValueString(variable);
            PrimitiveValidator validator = new PrimitiveValidator(variable);
            ChangeVariableValueInputDialog dialog = new ChangeVariableValueInputDialog(shell, title, message, initialValue, (IInputValidator)validator);
            if (dialog.open() == 0) {
                String stringValue = dialog.getValue();
                variable.setValue(stringValue);
            }
        }
        catch (DebugException e) {
            IStatus status = e.getStatus();
            ErrorDialog.openError((Shell)shell, (String)PHPDebugUIMessages.PHPPrimitiveValueEditor_2, (String)PHPDebugUIMessages.PHPPrimitiveValueEditor_3, (IStatus)status);
        }
        return true;
    }

    private String getValueString(IVariable variable) throws DebugException {
        DBGpStringValue strValue;
        IValue value = variable.getValue();
        String initialValue = value.getValueString();
        if (value instanceof DBGpStringValue && !(strValue = (DBGpStringValue)value).isComplete()) {
            DBGpTarget target = (DBGpTarget)value.getDebugTarget();
            DBGpVariable dbgpVar = (DBGpVariable)variable;
            String stackLevel = dbgpVar.getStackLevel();
            Node result = target.getCompleteString(dbgpVar.getFullName(), stackLevel, strValue.getRequiredBytes());
            if (result != null) {
                DBGpVariable tempVar = new DBGpVariable(target, result, stackLevel);
                IValue valRes = null;
                try {
                    valRes = tempVar.getValue();
                    if (valRes != null) {
                        ((DBGpVariable)variable).replaceValue(valRes);
                        initialValue = valRes.getValueString();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return initialValue;
    }

    public boolean saveVariable(IVariable variable, String expression, Shell shell) {
        return false;
    }

    protected class PrimitiveValidator
    implements IInputValidator {
        IVariable var;

        public PrimitiveValidator(IVariable var) {
            this.var = var;
        }

        public String isValid(String newText) {
            String errorMsg = null;
            try {
                if (!this.var.verifyValue(newText)) {
                    errorMsg = PHPDebugUIMessages.XDebugVariableValueEditor_invalidValue;
                }
            }
            catch (DebugException e) {
                Logger.logException("DebugException", e);
                errorMsg = "unexpected error occurred, see log for details";
            }
            return errorMsg;
        }
    }
}

