/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences;

import org.eclipse.php.internal.debug.ui.preferences.IPageControlValidator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class BasePathValidator
implements IPageControlValidator {
    private String errorMessage;
    private boolean isValid;
    private Text fDefaultBasePath;

    public BasePathValidator(Text fDefaultBasePath) {
        this.fDefaultBasePath = fDefaultBasePath;
    }

    public Control getControl() {
        return this.fDefaultBasePath;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void validate() {
        if (this.fDefaultBasePath != null) {
            String textAsString = this.fDefaultBasePath.getText();
            if (textAsString.equalsIgnoreCase("")) {
                this.errorMessage = "Base Path cannot contain an empty value for root type '/'";
                this.fDefaultBasePath.setMessage(this.errorMessage);
                this.isValid = false;
            } else if (!textAsString.startsWith("/")) {
                this.errorMessage = "Base Path must start with '/' prefix";
                this.fDefaultBasePath.setMessage(this.errorMessage);
                this.isValid = false;
            } else {
                this.errorMessage = null;
                this.fDefaultBasePath.setMessage("Example Path: '/<projectName>' | /<path> | '/'");
                this.isValid = true;
            }
        } else {
            this.isValid = false;
        }
    }
}

