/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ApplicationFileViewerFilter
extends ViewerFilter {
    protected String[] validExtensions;
    protected String[] requiredNatures;

    public ApplicationFileViewerFilter(String[] requiredNatures, String[] validExtensions) {
        this.requiredNatures = requiredNatures;
        this.validExtensions = validExtensions;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.isValid(element);
    }

    public boolean isValid(Object element) {
        if (IFile.class.isInstance(element)) {
            return this.isValidFile((IFile)element);
        }
        if (IContainer.class.isInstance(element)) {
            return this.isValidDirectory((IContainer)element);
        }
        return false;
    }

    public boolean isValidFile(IFile file) {
        String ext = file.getFileExtension();
        int i = 0;
        while (i < this.validExtensions.length) {
            if (this.validExtensions[i].equalsIgnoreCase(ext)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isValidDirectory(IContainer container) {
        try {
            return this.projectHasRequiredNatures(container.getProject()) && !container.getName().startsWith(".");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean projectHasRequiredNatures(IProject project) throws CoreException {
        if (this.requiredNatures != null) {
            int i = 0;
            while (i < this.requiredNatures.length) {
                if (!project.hasNature(this.requiredNatures[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

