/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.includepath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.php.internal.core.buildpath.BuildPathUtils;
import org.eclipse.php.internal.core.includepath.IIncludepathListener;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.preferences.CorePreferencesSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludePathManager {
    private static final String PREF_KEY = "include_path";
    private static final char PREF_SEP = '\u0005';
    private static IncludePathManager instance = new IncludePathManager();
    private boolean modifyingIncludePath;
    private final Set<IIncludepathListener> listeners = new HashSet<IIncludepathListener>(4);

    private IncludePathManager() {
        DLTKCore.addElementChangedListener((IElementChangedListener)new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                this.processChildren(event.getDelta());
            }

            private void processChildren(IModelElementDelta delta) {
                block18: {
                    if (IncludePathManager.this.modifyingIncludePath) {
                        return;
                    }
                    IModelElement element = delta.getElement();
                    try {
                        if ((delta.getFlags() & 0x20000) != 0) {
                            int n;
                            IScriptProject scriptProject = element.getScriptProject();
                            IProject project = scriptProject.getProject();
                            IncludePath[] includePathEntries = IncludePathManager.this.getIncludePaths(project);
                            LinkedList<IncludePath> newEntries = new LinkedList<IncludePath>(Arrays.asList(includePathEntries));
                            IBuildpathEntry[] rawBuildpath = scriptProject.getRawBuildpath();
                            boolean changed = false;
                            HashSet<IPath> addedModels = new HashSet<IPath>();
                            this.getAddedModels(delta, addedModels);
                            IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath;
                            int n2 = rawBuildpath.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                IBuildpathEntry entry = iBuildpathEntryArray[n3];
                                boolean added = false;
                                IncludePath[] includePathArray = includePathEntries;
                                n = includePathEntries.length;
                                int n4 = 0;
                                while (n4 < n) {
                                    IncludePath includePath = includePathArray[n4];
                                    if (includePath.isBuildpath() && entry.equals(includePath.getEntry()) || !addedModels.contains(entry.getPath())) {
                                        added = false;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (added && IncludePathManager.isBuildpathAllowed(entry)) {
                                    newEntries.add(new IncludePath((Object)entry, scriptProject));
                                    changed = true;
                                }
                                ++n3;
                            }
                            LinkedList<IncludePath> entriesToRemove = new LinkedList<IncludePath>();
                            IncludePath[] includePathArray = includePathEntries;
                            int n5 = includePathEntries.length;
                            n2 = 0;
                            while (n2 < n5) {
                                IncludePath includePath = includePathArray[n2];
                                boolean removed = true;
                                IBuildpathEntry[] iBuildpathEntryArray2 = rawBuildpath;
                                int n6 = rawBuildpath.length;
                                n = 0;
                                while (n < n6) {
                                    IBuildpathEntry entry = iBuildpathEntryArray2[n];
                                    if (includePath.isBuildpath()) {
                                        if (entry.equals(includePath.getEntry())) {
                                            removed = false;
                                            break;
                                        }
                                    } else {
                                        removed = false;
                                    }
                                    ++n;
                                }
                                if (removed) {
                                    entriesToRemove.add(includePath);
                                }
                                ++n2;
                            }
                            for (IncludePath includePath : entriesToRemove) {
                                newEntries.remove(includePath);
                                changed = true;
                            }
                            if (changed) {
                                IncludePathManager.this.setIncludePath(project, newEntries.toArray(new IncludePath[newEntries.size()]));
                            }
                        } else {
                            IModelElementDelta[] children;
                            IModelElementDelta[] iModelElementDeltaArray = children = delta.getAffectedChildren();
                            int n = children.length;
                            int n7 = 0;
                            while (n7 < n) {
                                IModelElementDelta child = iModelElementDeltaArray[n7];
                                this.processChildren(child);
                                ++n7;
                            }
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block18;
                        e.printStackTrace();
                    }
                }
            }

            private void getAddedModels(IModelElementDelta delta, Set<IPath> addedModels) {
                int i = 0;
                while (i < delta.getAddedChildren().length) {
                    addedModels.add(delta.getAddedChildren()[i].getElement().getPath());
                    ++i;
                }
                i = 0;
                while (i < delta.getAffectedChildren().length) {
                    this.getAddedModels(delta.getAffectedChildren()[i], addedModels);
                    ++i;
                }
            }
        });
    }

    public static IncludePathManager getInstance() {
        return instance;
    }

    public IncludePath[] getIncludePaths(IProject project) {
        LinkedList<IncludePath> includePathEntries;
        block12: {
            IBuildpathEntry[] buildpath;
            block11: {
                block10: {
                    includePathEntries = new LinkedList<IncludePath>();
                    buildpath = null;
                    try {
                        buildpath = DLTKCore.create((IProject)project).getRawBuildpath();
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block10;
                        e.printStackTrace();
                    }
                }
                String includePath = CorePreferencesSupport.getInstance().getProjectSpecificPreferencesValue(PREF_KEY, null, project);
                if (includePath == null) break block11;
                block2: while (includePath != null) {
                    String path;
                    int i = includePath.indexOf(5);
                    if (i == -1) {
                        path = includePath;
                        includePath = null;
                    } else {
                        path = includePath.substring(0, i);
                        includePath = includePath.substring(i + 1);
                    }
                    i = path.indexOf(59);
                    if (i == -1) continue;
                    int kind = Integer.parseInt(path.substring(0, i));
                    path = path.substring(i + 1);
                    if (kind == 0) {
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                        if (resource == null) continue;
                        includePathEntries.add(new IncludePath((Object)resource, project));
                        continue;
                    }
                    if (buildpath == null) continue;
                    IBuildpathEntry[] iBuildpathEntryArray = buildpath;
                    int n = buildpath.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPath localPath;
                        IBuildpathEntry entry = iBuildpathEntryArray[n2];
                        if (entry.getEntryKind() == kind && (localPath = EnvironmentPathUtils.getLocalPath((IPath)entry.getPath())).equals((Object)new Path(path))) {
                            includePathEntries.add(new IncludePath((Object)entry, project));
                            continue block2;
                        }
                        ++n2;
                    }
                }
                break block12;
            }
            if (buildpath == null) break block12;
            IBuildpathEntry[] iBuildpathEntryArray = buildpath;
            int n = buildpath.length;
            int n3 = 0;
            while (n3 < n) {
                IBuildpathEntry entry = iBuildpathEntryArray[n3];
                if (IncludePathManager.isBuildpathAllowed(entry)) {
                    includePathEntries.add(new IncludePath((Object)entry, project));
                }
                ++n3;
            }
        }
        return includePathEntries.toArray(new IncludePath[includePathEntries.size()]);
    }

    public void setIncludePath(final IProject project, IncludePath[] includePathEntries) {
        final StringBuilder buf = new StringBuilder();
        if (project == null || includePathEntries == null) {
            return;
        }
        int i = 0;
        while (i < includePathEntries.length) {
            IBuildpathEntry entry;
            IncludePath includePath = includePathEntries[i];
            if (includePath.isBuildpath()) {
                entry = (IBuildpathEntry)includePath.getEntry();
                IPath localPath = EnvironmentPathUtils.getLocalPath((IPath)entry.getPath());
                buf.append(entry.getEntryKind()).append(';').append(localPath.toString());
            } else {
                entry = (IResource)includePath.getEntry();
                buf.append("0;").append(entry.getFullPath().toString());
            }
            if (i < includePathEntries.length - 1) {
                buf.append('\u0005');
            }
            ++i;
        }
        this.modifyingIncludePath = true;
        WorkspaceJob job = new WorkspaceJob("Modifying Include Path"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                CorePreferencesSupport.getInstance().setProjectSpecificPreferencesValue(IncludePathManager.PREF_KEY, buf.toString(), project);
                IncludePathManager.this.modifyingIncludePath = false;
                IncludePathManager.this.refresh(project);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)project.getWorkspace().getRoot());
        job.setPriority(10);
        job.schedule();
    }

    public static boolean isBuildpathAllowed(IBuildpathEntry entry) {
        return entry.getEntryKind() == 5 && !entry.getPath().toString().equals("org.eclipse.php.core.LANGUAGE") || entry.getEntryKind() == 1 || entry.getEntryKind() == 2;
    }

    public void removeEntryFromIncludePath(IProject project, IBuildpathEntry buildpathEntry) throws ModelException {
        IncludePath[] includePathEntries = this.getIncludePaths(project);
        ArrayList<IncludePath> newIncludePathEntries = new ArrayList<IncludePath>();
        IncludePath[] includePathArray = includePathEntries;
        int n = includePathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IncludePath entry = includePathArray[n2];
            Object includePathEntry = entry.getEntry();
            IPath resourcePath = null;
            if (includePathEntry instanceof IBuildpathEntry) {
                IBuildpathEntry bpEntry = (IBuildpathEntry)includePathEntry;
                resourcePath = bpEntry.getPath();
            } else {
                IResource resource = (IResource)includePathEntry;
                resourcePath = resource.getFullPath();
            }
            if (resourcePath != null && !resourcePath.toString().equals(buildpathEntry.getPath().toString())) {
                newIncludePathEntries.add(entry);
            }
            ++n2;
        }
        this.setIncludePath(project, newIncludePathEntries.toArray(new IncludePath[newIncludePathEntries.size()]));
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        switch (buildpathEntry.getEntryKind()) {
            case 1: 
            case 2: 
            case 5: {
                BuildPathUtils.removeEntryFromBuildPath(scriptProject, buildpathEntry);
            }
        }
    }

    public void addEntriesToIncludePath(IProject project, List<IBuildpathEntry> entries) {
        ArrayList<IncludePath> includePathEntries = new ArrayList<IncludePath>();
        for (IBuildpathEntry buildpathEntry : entries) {
            if (buildpathEntry.getEntryKind() == 3) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(buildpathEntry.getPath());
                if (resource == null) continue;
                includePathEntries.add(new IncludePath((Object)resource, project));
                continue;
            }
            includePathEntries.add(new IncludePath((Object)buildpathEntry, project));
        }
        this.setIncludePath(project, includePathEntries.toArray(new IncludePath[includePathEntries.size()]));
    }

    public void appendEntriesToIncludePath(IProject project, List<IBuildpathEntry> entries) {
        ArrayList<IncludePath> includePathEntries = new ArrayList<IncludePath>();
        for (IBuildpathEntry buildpathEntry : entries) {
            if (buildpathEntry.getEntryKind() == 3) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(buildpathEntry.getPath());
                if (resource == null) continue;
                includePathEntries.add(new IncludePath((Object)resource, project));
                continue;
            }
            includePathEntries.add(new IncludePath((Object)buildpathEntry, project));
        }
        includePathEntries.addAll(Arrays.asList(IncludePathManager.getInstance().getIncludePaths(project)));
        this.setIncludePath(project, includePathEntries.toArray(new IncludePath[includePathEntries.size()]));
    }

    public static IPath isInIncludePath(IProject project, IPath entryPath) {
        IncludePath[] includePathEntries;
        if (entryPath == null) {
            return null;
        }
        IncludePathManager includepathManager = IncludePathManager.getInstance();
        IncludePath[] includePathArray = includePathEntries = includepathManager.getIncludePaths(project);
        int n = includePathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IncludePath entry = includePathArray[n2];
            Object includePathEntry = entry.getEntry();
            IPath resourcePath = null;
            if (includePathEntry instanceof IBuildpathEntry) {
                IBuildpathEntry bpEntry = (IBuildpathEntry)includePathEntry;
                resourcePath = bpEntry.getPath();
            } else {
                IResource resource = (IResource)includePathEntry;
                resourcePath = resource.getFullPath();
            }
            if (resourcePath != null && resourcePath.isPrefixOf(entryPath)) {
                return resourcePath;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIncludepathListener(IIncludepathListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Error adding listener in IncludepathManager");
        }
        IncludePathManager includePathManager = this;
        synchronized (includePathManager) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIncludepathListener(IIncludepathListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Error adding listener in IncludepathManager");
        }
        IncludePathManager includePathManager = this;
        synchronized (includePathManager) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh(IProject project) {
        IIncludepathListener[] array = null;
        IncludePathManager includePathManager = this;
        synchronized (includePathManager) {
            array = this.listeners.toArray(new IIncludepathListener[this.listeners.size()]);
        }
        IIncludepathListener[] iIncludepathListenerArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            IIncludepathListener includepathListener = iIncludepathListenerArray[n2];
            includepathListener.refresh(project);
            ++n2;
        }
    }
}

