/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.io.File;
import java.net.URI;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPVersionConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.wizards.CompositeData;
import org.eclipse.php.internal.ui.wizards.DetectGroup;
import org.eclipse.php.internal.ui.wizards.IPHPProjectCreateWizardPage;
import org.eclipse.php.internal.ui.wizards.LocationGroup;
import org.eclipse.php.internal.ui.wizards.NameGroup;
import org.eclipse.php.internal.ui.wizards.WizardFragment;
import org.eclipse.php.internal.ui.wizards.WizardModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPProjectWizardFirstPage
extends WizardPage
implements IPHPProjectCreateWizardPage {
    private static final String PAGE_NAME = NewWizardMessages.ScriptProjectWizardFirstPage_page_title;
    public static final String ERROR_MESSAGE = "ErrorMessage";
    protected Validator fPdtValidator;
    protected String fInitialName;
    protected NameGroup fNameGroup;
    protected DetectGroup fDetectGroup;
    protected VersionGroup fVersionGroup;
    protected JavaScriptSupportGroup fJavaScriptSupportGroup;
    protected LayoutGroup fLayoutGroup;
    protected LocationGroup fPHPLocationGroup;
    protected WizardFragment fragment;

    public PHPProjectWizardFirstPage() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.ScriptProjectWizardFirstPage_page_title);
        this.setDescription(NewWizardMessages.ScriptProjectWizardFirstPage_page_description);
        this.fInitialName = "";
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), false));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite, this.fInitialName, this.getShell());
        this.fPHPLocationGroup = new LocationGroup(composite, this.fNameGroup, this.getShell());
        CompositeData data = new CompositeData();
        data.setParetnt(composite);
        data.setSettings(this.getDialogSettings());
        data.setObserver(this.fPHPLocationGroup);
        this.fragment = (WizardFragment)Platform.getAdapterManager().loadAdapter((Object)data, PHPProjectWizardFirstPage.class.getName());
        this.fVersionGroup = new VersionGroup(composite);
        this.fLayoutGroup = new LayoutGroup(composite);
        this.fJavaScriptSupportGroup = new JavaScriptSupportGroup(composite, this);
        this.fDetectGroup = new DetectGroup(composite, this.fPHPLocationGroup, this.fNameGroup);
        this.fNameGroup.addObserver(this.fPHPLocationGroup);
        this.fDetectGroup.addObserver(this.fLayoutGroup);
        this.fPHPLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fPdtValidator = new Validator();
        this.fNameGroup.addObserver(this.fPdtValidator);
        this.fPHPLocationGroup.addObserver(this.fPdtValidator);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.fNameGroup.postSetFocus();
        this.setHelpContext(composite);
    }

    public boolean isExistingLocation() {
        return this.fPHPLocationGroup.isExistingLocation();
    }

    protected void setHelpContext(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.creating_php_projects");
    }

    public URI getLocationURI() {
        IEnvironment environment = this.getEnvironment();
        return environment.getURI(this.fPHPLocationGroup.getLocation());
    }

    public IEnvironment getEnvironment() {
        return this.fPHPLocationGroup.getEnvironment();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public boolean isInWorkspace() {
        return this.fPHPLocationGroup.isInWorkspace();
    }

    public boolean isInLocalServer() {
        return this.fPHPLocationGroup.isInLocalServer();
    }

    public boolean getDetect() {
        return this.fDetectGroup.mustDetect();
    }

    public boolean hasPhpSourceFolder() {
        return this.fLayoutGroup != null && this.fLayoutGroup.isDetailedLayout();
    }

    public GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    private boolean canCreate(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        }
        return file.canWrite();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (!visible && currentPage != null && currentPage instanceof IPHPProjectCreateWizardPage) {
            ((IPHPProjectCreateWizardPage)currentPage).initPage();
        }
    }

    public void initPage() {
    }

    public WizardModel getWizardData() {
        if (this.fragment != null) {
            return this.fragment.getWizardModel();
        }
        return null;
    }

    public void performFinish(IProgressMonitor monitor) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PHPUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.php.ui.wizards.JSsupport", PHPProjectWizardFirstPage.this.fJavaScriptSupportGroup.getSelection());
            }
        });
    }

    public boolean shouldSupportJavaScript() {
        return this.fJavaScriptSupportGroup != null && this.fJavaScriptSupportGroup.shouldSupportJavaScript();
    }

    public boolean isDefaultVersionSelected() {
        return this.fVersionGroup != null && this.fVersionGroup.fDefaultValues.isSelected();
    }

    public boolean getUseAspTagsValue() {
        return this.fVersionGroup != null && this.fVersionGroup.fConfigurationBlock.getUseAspTagsValue();
    }

    public PHPVersion getPHPVersionValue() {
        if (this.fVersionGroup != null) {
            return this.fVersionGroup.fConfigurationBlock.getPHPVersionValue();
        }
        return null;
    }

    public class JavaScriptSupportGroup
    implements SelectionListener {
        private final Group fGroup;
        protected Button fEnableJavaScriptSupport;

        public boolean shouldSupportJavaScript() {
            return PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.php.ui.wizards.JSsupport");
        }

        public JavaScriptSupportGroup(Composite composite, WizardPage projectWizardFirstPage) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)PHPProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(PHPUIMessages.JavaScriptSupportGroup_OptionBlockTitle);
            this.fEnableJavaScriptSupport = new Button((Composite)this.fGroup, 131104);
            this.fEnableJavaScriptSupport.setText(PHPUIMessages.JavaScriptSupportGroup_EnableSupport);
            this.fEnableJavaScriptSupport.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.fEnableJavaScriptSupport.addSelectionListener((SelectionListener)this);
            this.fEnableJavaScriptSupport.setSelection(PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.php.ui.wizards.JSsupport"));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
        }

        public boolean getSelection() {
            return this.fEnableJavaScriptSupport.getSelection();
        }
    }

    public class LayoutGroup
    implements Observer,
    SelectionListener,
    IDialogFieldListener {
        private final SelectionButtonDialogField fStdRadio = new SelectionButtonDialogField(16);
        private final SelectionButtonDialogField fSrcBinRadio;
        private Group fGroup;
        private Link fPreferenceLink;

        public LayoutGroup(Composite composite) {
            this.fStdRadio.setLabelText(PHPUIMessages.LayoutGroup_OptionBlock_ProjectSrc);
            this.fStdRadio.setDialogFieldListener((IDialogFieldListener)this);
            this.fSrcBinRadio = new SelectionButtonDialogField(16);
            this.fSrcBinRadio.setLabelText(PHPUIMessages.LayoutGroup_OptionBlock_SrcResources);
            this.fSrcBinRadio.setDialogFieldListener((IDialogFieldListener)this);
            boolean useSrcBin = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.php.ui.wizards.srcBinFoldersInNewProjects");
            this.fSrcBinRadio.setSelection(useSrcBin);
            this.fStdRadio.setSelection(!useSrcBin);
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)PHPProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(PHPUIMessages.LayoutGroup_OptionBlock_Title);
            this.fStdRadio.doFillIntoGrid((Composite)this.fGroup, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fStdRadio.getSelectionButton(null));
            this.fSrcBinRadio.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setText(PHPUIMessages.ToggleLinkingAction_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            this.fPreferenceLink.setEnabled(true);
            this.updateEnableState();
        }

        public void update(Observable o, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            if (PHPProjectWizardFirstPage.this.fDetectGroup == null) {
                return;
            }
            boolean detect = PHPProjectWizardFirstPage.this.fDetectGroup.mustDetect();
            this.fStdRadio.setEnabled(!detect);
            this.fSrcBinRadio.setEnabled(!detect);
            if (this.fGroup != null) {
                this.fGroup.setEnabled(!detect);
            }
        }

        public boolean isDetailedLayout() {
            return this.fSrcBinRadio.isSelected();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void dialogFieldChanged(DialogField field) {
            this.updateEnableState();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String prefID = "org.eclipse.php.ui.preferences.PHPProjectLayoutPreferencePage";
            Object data = null;
            PreferencesUtil.createPreferenceDialogOn((Shell)PHPProjectWizardFirstPage.this.getShell(), (String)prefID, (String[])new String[]{prefID}, data).open();
        }
    }

    public final class Validator
    implements Observer {
        public void update(Observable o, Object arg) {
            IEnvironment environment;
            IWorkspace workspace = DLTKUIPlugin.getWorkspace();
            String name = PHPProjectWizardFirstPage.this.fNameGroup.getName();
            if (name.length() == 0) {
                PHPProjectWizardFirstPage.this.setErrorMessage(null);
                PHPProjectWizardFirstPage.this.setMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterProjectName);
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                PHPProjectWizardFirstPage.this.setErrorMessage(nameStatus.getMessage());
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IProject handle = PHPProjectWizardFirstPage.this.getProjectHandle();
            if (!PHPProjectWizardFirstPage.this.isInLocalServer() && handle.exists()) {
                PHPProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_projectAlreadyExists);
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            String newProjectNameLowerCase = name.toLowerCase();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject currentProject = iProjectArray[n2];
                String existingProjectName = currentProject.getName();
                if (existingProjectName.toLowerCase().equals(newProjectNameLowerCase)) {
                    PHPProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_projectAlreadyExists);
                    PHPProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
                ++n2;
            }
            String location = PHPProjectWizardFirstPage.this.fPHPLocationGroup.getLocation().toOSString();
            if (location.length() == 0) {
                PHPProjectWizardFirstPage.this.setErrorMessage(null);
                PHPProjectWizardFirstPage.this.setMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterLocation);
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                PHPProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_invalidDirectory);
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IPath projectPath = Path.fromOSString((String)location);
            if (!PHPProjectWizardFirstPage.this.fPHPLocationGroup.isInWorkspace() && Platform.getLocation().isPrefixOf(projectPath)) {
                PHPProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_cannotCreateInWorkspace);
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!PHPProjectWizardFirstPage.this.fPHPLocationGroup.isInWorkspace() && EnvironmentManager.isLocal((IEnvironment)(environment = PHPProjectWizardFirstPage.this.getEnvironment()))) {
                IStatus locationStatus = workspace.validateProjectLocation(handle, projectPath);
                projectPath.toFile();
                if (!locationStatus.isOK()) {
                    PHPProjectWizardFirstPage.this.setErrorMessage(locationStatus.getMessage());
                    PHPProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
                if (!PHPProjectWizardFirstPage.this.canCreate(projectPath.toFile())) {
                    PHPProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_invalidDirectory);
                    PHPProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
            }
            if (PHPProjectWizardFirstPage.this.fragment != null) {
                PHPProjectWizardFirstPage.this.fragment.getWizardModel().putObject("ProjectName", PHPProjectWizardFirstPage.this.fNameGroup.getName());
                if (!PHPProjectWizardFirstPage.this.fragment.isComplete()) {
                    PHPProjectWizardFirstPage.this.setErrorMessage((String)PHPProjectWizardFirstPage.this.fragment.getWizardModel().getObject(PHPProjectWizardFirstPage.ERROR_MESSAGE));
                    PHPProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
            }
            PHPProjectWizardFirstPage.this.setPageComplete(true);
            PHPProjectWizardFirstPage.this.setErrorMessage(null);
            PHPProjectWizardFirstPage.this.setMessage(null);
        }
    }

    public class VersionGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener,
    SelectionListener {
        public final SelectionButtonDialogField fDefaultValues;
        protected final SelectionButtonDialogField fCustomValues;
        public PHPVersionConfigurationBlock fConfigurationBlock;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.dltk.ui.last.external.project";
        private Link fPreferenceLink;

        public VersionGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)PHPProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(PHPUIMessages.VersionGroup_OptionBlock_Title);
            this.fDefaultValues = new SelectionButtonDialogField(16);
            this.fDefaultValues.setDialogFieldListener((IDialogFieldListener)this);
            this.fDefaultValues.setLabelText(PHPUIMessages.VersionGroup_OptionBlock_fDefaultValues);
            this.fCustomValues = new SelectionButtonDialogField(16);
            this.fCustomValues.setDialogFieldListener((IDialogFieldListener)this);
            this.fCustomValues.setLabelText(PHPUIMessages.VersionGroup_OptionBlock_fCustomValues);
            this.fDefaultValues.setSelection(true);
            this.fCustomValues.setSelection(false);
            this.fDefaultValues.doFillIntoGrid((Composite)group, 3);
            this.fCustomValues.doFillIntoGrid((Composite)group, 2);
            this.fConfigurationBlock = this.createConfigurationBlock(new IStatusChangeListener(){

                public void statusChanged(IStatus status) {
                }
            }, null, null);
            this.fConfigurationBlock.createContents((Composite)group);
            this.fConfigurationBlock.setEnabled(false);
        }

        protected PHPVersionConfigurationBlock createConfigurationBlock(IStatusChangeListener listener, IProject project, IWorkbenchPreferenceContainer container) {
            return new PHPVersionConfigurationBlock(listener, project, container, true);
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public void update(Observable o, Object arg) {
            this.fireEvent();
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            IEnvironment environment = PHPProjectWizardFirstPage.this.getEnvironment();
            IEnvironmentUI environmentUI = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
            if (environmentUI != null && (selectedDirectory = environmentUI.selectFolder(PHPProjectWizardFirstPage.this.getShell())) != null) {
                DLTKUIPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fDefaultValues) {
                boolean checked = this.fDefaultValues.isSelected();
                if (this.fConfigurationBlock != null) {
                    this.fConfigurationBlock.setEnabled(!checked);
                }
            }
            this.fireEvent();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String prefID = "org.eclipse.php.ui.preferences.PHPInterpreterPreferencePage";
            Object data = null;
            PreferencesUtil.createPreferenceDialogOn((Shell)PHPProjectWizardFirstPage.this.getShell(), (String)prefID, (String[])new String[]{prefID}, data).open();
            if (!this.fCustomValues.isSelected()) {
                this.fConfigurationBlock.performRevert();
            }
        }
    }
}

