/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.IDBGpModelConstants;
import org.w3c.dom.Node;

public class DBGpNumValue
extends DBGpValue {
    private String numberType;

    public DBGpNumValue(DBGpVariable owningVariable, Node property, String numType) {
        super(owningVariable, property);
        this.setModifiable(true);
        this.numberType = numType;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.numberType;
    }

    void genValueString(String data) {
        if (data != null) {
            this.setValueString(data.trim());
        } else {
            this.setValueString(IDBGpModelConstants.INVALID_VAR_CONTENT);
        }
    }

    public void setValue(String expression) throws DebugException {
        this.genValueString(expression);
    }

    boolean verifyValue(String expression) throws DebugException {
        try {
            Float.parseFloat(expression);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

