/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.codeassist.contexts.DeclarationContext;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

public abstract class TypeDeclarationContext
extends DeclarationContext {
    protected static final Pattern EXTENDS_PATTERN = Pattern.compile("\\Wextends\\W", 2);
    protected static final Pattern IMPLEMENTS_PATTERN = Pattern.compile("\\Wimplements", 2);
    private int typeEnd;
    private int typeIdentifierEnd;
    private boolean hasExtends;
    private boolean hasImplements;
    protected Matcher implementsMatcher;
    protected Matcher extendsMatcher;

    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        TextSequence statementText = this.getStatementText();
        this.typeEnd = PHPTextSequenceUtilities.isInClassDeclaration(statementText);
        if (this.typeEnd == -1) {
            return false;
        }
        this.typeIdentifierEnd = 0;
        while (this.typeIdentifierEnd < statementText.length()) {
            if (!Character.isLetterOrDigit(statementText.charAt(this.typeIdentifierEnd))) break;
            ++this.typeIdentifierEnd;
        }
        if (this.typeIdentifierEnd == statementText.length()) {
            return true;
        }
        this.extendsMatcher = EXTENDS_PATTERN.matcher(statementText);
        this.hasExtends = this.extendsMatcher.find();
        this.implementsMatcher = IMPLEMENTS_PATTERN.matcher(statementText);
        this.hasImplements = this.implementsMatcher.find();
        return true;
    }

    public int getTypeEnd() {
        return this.typeEnd;
    }

    public int getTypeIdentifierEnd() {
        return this.typeIdentifierEnd;
    }

    public boolean hasExtends() {
        return this.hasExtends;
    }

    public boolean hasImplements() {
        return this.hasImplements;
    }
}

