/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Collection;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalElementStrategy;
import org.eclipse.php.internal.core.language.keywords.PHPKeywords;

public abstract class KeywordsStrategy
extends GlobalElementStrategy {
    public KeywordsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public KeywordsStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        AbstractCompletionContext concreteContext = (AbstractCompletionContext)context;
        ISourceModule sourceModule = concreteContext.getSourceModule();
        String prefix = concreteContext.getPrefix();
        SourceRange replaceRange = this.getReplacementRange(concreteContext);
        boolean withoutSemicolon = concreteContext.getNextWord().trim().equals(";");
        Collection<PHPKeywords.KeywordData> keywordsList = PHPKeywords.getInstance(sourceModule.getScriptProject().getProject()).findByPrefix(prefix);
        for (PHPKeywords.KeywordData keyword : keywordsList) {
            if (this.filterKeyword(keyword)) continue;
            String suffix = keyword.suffix;
            if (withoutSemicolon && suffix.endsWith(";")) {
                suffix = suffix.substring(0, suffix.length() - 1);
            }
            reporter.reportKeyword(keyword.name, suffix, replaceRange);
        }
    }

    protected abstract boolean filterKeyword(PHPKeywords.KeywordData var1);
}

