/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.PropertyTesters;

import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.ui.IEditorInput;

public class PHPLaunchPropertyTester
extends PropertyTester {
    private static final String PROPERTY = "launchablePHP";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        List list;
        if (receiver instanceof List && (list = (List)receiver).size() > 0) {
            Object obj = list.get(0);
            if (PROPERTY.equals(property)) {
                if (obj instanceof IEditorInput) {
                    return this.test((IModelElement)DLTKUIPlugin.getEditorInputModelElement((IEditorInput)((IEditorInput)obj)));
                }
                if (obj instanceof IAdaptable) {
                    IResource resource = this.getResource((IAdaptable)obj);
                    if (resource != null && resource.getType() == 1) {
                        return PHPToolkitUtil.isPhpFile((IFile)((IFile)resource));
                    }
                    if (resource != null && resource.getType() == 4) {
                        return this.isWebPageProjectLaunch(args, (IProject)resource);
                    }
                }
            }
        }
        return false;
    }

    private IResource getResource(IAdaptable obj) {
        IModelElement modelElement = (IModelElement)obj.getAdapter(IModelElement.class);
        if (modelElement != null) {
            return modelElement.getResource();
        }
        return (IResource)obj.getAdapter(IResource.class);
    }

    private boolean test(IModelElement modelElement) {
        return modelElement != null && modelElement.getElementType() == 5 && PHPToolkitUtil.isPhpElement((IModelElement)modelElement);
    }

    private boolean isWebPageProjectLaunch(Object[] args, IProject resource) {
        block3: {
            try {
                Server localServer = ServersManager.getLocalServer((IProject)resource);
                if (localServer != null) break block3;
                return false;
            }
            catch (CoreException e) {
                PHPDebugUIPlugin.log(e);
                return false;
            }
        }
        return PHPToolkitUtil.isPhpProject((IProject)resource) && args.length > 0 && "webPage".equals(args[0]);
    }
}

