/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.List;
import org.eclipse.php.internal.core.ast.locator.PhpElementConciliator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Quote;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;

public class ConstantHighlighting
extends AbstractSemanticHighlighting {
    public AbstractSemanticApply getSemanticApply() {
        return new ConstantApply();
    }

    public void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(false).setDefaultTextColor(0, 0, 192).setItalicByDefault(true);
    }

    public String getDisplayName() {
        return "Constants";
    }

    protected class ConstantApply
    extends AbstractSemanticApply {
        boolean isInQuote = false;

        protected ConstantApply() {
        }

        public boolean visit(ConstantDeclaration constDecl) {
            List names = constDecl.names();
            for (Identifier name : names) {
                ConstantHighlighting.this.highlight((ASTNode)name);
            }
            return true;
        }

        public boolean visit(Quote quote) {
            this.isInQuote = true;
            return true;
        }

        public void endVisit(Quote quote) {
            this.isInQuote = false;
        }

        public boolean visit(Scalar scalar) {
            Identifier identifier;
            FunctionInvocation fi;
            String value = scalar.getStringValue();
            if (!((scalar.getScalarType() != 2 || this.isInQuote) && scalar.getScalarType() != 4 || "null".equals(value) || "false".equals(value) || "true".equals(value) || value.charAt(0) == '\'' || value.charAt(0) == '\"')) {
                ConstantHighlighting.this.highlight((ASTNode)scalar);
            } else if (scalar.getParent() instanceof FunctionInvocation && (fi = (FunctionInvocation)scalar.getParent()).parameters().get(0) == scalar && fi.getFunctionName().getName() instanceof Identifier && ("define".equalsIgnoreCase((identifier = (Identifier)fi.getFunctionName().getName()).getName()) || "constant".equalsIgnoreCase(identifier.getName()))) {
                ConstantHighlighting.this.highlight((ASTNode)scalar);
            }
            return true;
        }

        public boolean visit(StaticConstantAccess access) {
            ConstantHighlighting.this.highlight((ASTNode)access.getConstant());
            return true;
        }

        public boolean visit(NamespaceName namespace) {
            List segs;
            Identifier c;
            ASTNode parent = namespace.getParent();
            if (!(parent instanceof NamespaceDeclaration || parent instanceof StaticDispatch || parent instanceof FunctionName || PhpElementConciliator.concile((ASTNode)(c = (Identifier)(segs = namespace.segments()).get(segs.size() - 1))) != 5)) {
                ConstantHighlighting.this.highlight((ASTNode)c);
            }
            return true;
        }
    }
}

