﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
using Progressive.PecaStarter.Common;
using Progressive.PecaStarter.Model;
using Progressive.PecaStarter.Util;
using Progressive.PecaStarter.ViewModel.Page;

namespace Progressive.PecaStarter.ViewModel.Command
{
    public abstract class ChannelCommandBase : PeercastCommandBase
    {
        protected readonly Logger logger;
        protected readonly IList<YellowPages> yellowPageses;

        public ChannelCommandBase(Peercast peercast, Logger logger, IList<YellowPages> yellowPageses, MainWindowViewModel viewModel)
            : base(peercast, viewModel)
        {
            this.logger = logger;
            this.yellowPageses = yellowPageses;
        }

        protected bool TryLength(string str)
        {
            return str != null && HttpUtils.UrlEncode(str, PeercastDefine.Encoding).Length <= PeercastDefine.MaxParameterLength;
        }

        protected NameValueCollection GetWebApiParameters(IList<string> parameters, int bitrate, YellowPagesViewModel ypvm, ExternalSourceViewModel esvm, string streamUrl)
        {
            var nvc = new NameValueCollection();
            foreach (var param in parameters)
            {
                string value;
                switch (param)
                {
                    case "name":
                        value = esvm.Name.Value;
                        break;
                    case "bitrate":
                        value = bitrate.ToString();
                        break;
                    case "tags":
                        value = esvm.Genre.Value;
                        break;
                    case "description":
                        value = esvm.Description.Value;
                        break;
                    case "comment":
                        value = esvm.Comment.Value;
                        break;
                    case "contact_url":
                        value = esvm.ContactUrl.Value;
                        break;
                    case "protocol":
                        value = "Peercast";
                        break;
                    case "stream_url":
                        if (streamUrl == "")
                        {
                            continue;
                        }
                        value = streamUrl;
                        break;
                    case "type":
                        value = "WMV";
                        break;
                    case "result_format":
                        value = "json";
                        break;
                    default:
                        value = ypvm[param] as string;
                        break;
                }
                nvc.Add(param, value);
            }
            return nvc;
        }
    }
}
