﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Input;
using Progressive.PecaStarter.ViewModel.Command;
using System.Collections.ObjectModel;
using Progressive.PecaStarter.Model;

namespace Progressive.PecaStarter.ViewModel.Page
{
    public class RelayListViewModel : ViewModelBase
    {
        #region Variables
        private MainWindowViewModel parent;
        private bool isListEnabled;
        private IList<Channel> channels;
        private YellowPagesViewModel selectedYellowPages;
        #endregion

        #region Binding Properties
        public bool IsListEnabled
        {
            get { return isListEnabled; }
            set
            {
                isListEnabled = value;
                NotifyPropertyChanged("IsListEnabled");
            }
        }
        public IList<Channel> Channels
        {
            get { return channels; }
            set
            {
                channels = value;
                NotifyPropertyChanged("Channels");
            }
        }
        public Visibility LoadingVisibility { get { return IsListEnabled ? Visibility.Collapsed : Visibility.Visible; } }
        public IDictionary<string, YellowPagesViewModel> YellowPageses { get { return parent.YellowPageses; } }
        public YellowPagesViewModel SelectedYellowPages
        {
            get { return selectedYellowPages; }
            set
            {
                selectedYellowPages = value;
                NotifyPropertyChanged("SelectedYellowPages");
            }
        }
        public ICommand ReloadCommand { get; private set; }
        public ICommand OpenCommand { get; private set; }
        #endregion

        public RelayListViewModel(Peercast peercast, IList<YellowPages>yellowPageses, MainWindowViewModel parent)
        {
            this.parent = parent;
            selectedYellowPages = null;
            isListEnabled = true;
            Channels = new Collection<Channel>();
            ReloadCommand = new ReloadCommand(peercast, parent, this);
            OpenCommand = new OpenCommand(peercast, yellowPageses, parent);
            AddRelation("IsListEnabled", "LoadingVisibility");
        }
    }
}
