﻿using System;
using System.IO;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using Progressive.PecaStarter.Commons.Networks;

namespace Progressive.PecaStarter.Commons.Daos
{
    class WebRequest : IDisposable
    {
        private HttpWebRequest request;
        private WebClient client;

        public bool IsBusy { get { return client.IsBusy; } }

        public WebRequest()
        {
            client = new WebClient();
            client.Encoding = Encoding.ASCII;
        }

        public void Dispose()
        {
            client.Dispose();
        }

        public async Task Access(string address)
        {
            request = (HttpWebRequest)HttpWebRequest.Create(address);
            await request.AccessAsync();
        }

        public async Task<string> GetText(string address)
        {
            request = (HttpWebRequest)HttpWebRequest.Create(address);
            return await request.GetTextAsync();
        }
    }
}
