﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Progressive.PecaStarter.Model;
using System.Windows.Threading;
using System.Threading;
using System.Collections.Specialized;
using Progressive.PecaStarter.Common;

namespace Progressive.PecaStarter.ViewModel.Command
{
    class TimerCommand
    {
        private Peercast peercast;
        private Logger logger;
        private Dispatcher dispatcher;
        private MainWindowViewModel viewModel;
        private WebApiYellowPages wyp;
        private NameValueCollection nvc;

        public TimerCommand(Peercast peercast, Logger logger, Dispatcher dispatcher, MainWindowViewModel viewModel, WebApiYellowPages wyp, NameValueCollection nvc)
        {
            this.peercast = peercast;
            this.logger = logger;
            this.dispatcher = dispatcher;
            this.viewModel = viewModel;
            this.wyp = wyp;
            this.nvc = nvc;
        }

        public void Execute()
        {
            for (; ; )
            {
                switch (dispatcher.Invoke<bool?>(() =>
                {
                    if (!viewModel.IsBroadcast)
                    {
                        return false;
                    }
                    if (viewModel.IsBusy)
                    {
                        return null;
                    }
                    viewModel.IsBusy = true;
                    viewModel.Feedback = "リスナー数を取得中...";
                    return true;
                }))
                {
                    case false:
                        return;
                    case null:
                        Thread.Sleep(TimeSpan.FromSeconds(10));
                        continue;
                }
                break;
            }
            try
            {
                var t = peercast.GetListeners();
                t.Wait();
                var info = t.Result;
                if (info.Result != Result.Success)
                {
                    dispatcher.Invoke(() => viewModel.NotifyAlert("リスナー数の取得中にエラーが発生しました。\n原因: " + info.Result.GetErrorMessage()));
                    return;
                }
                if (viewModel.SettingsViewModel.Logging)
                {
                    logger.insert(info.Value.Item1.ToString(), info.Value.Item2.ToString(), "", "", "");
                    dispatcher.Invoke(() => viewModel.Feedback = "ログを保存しました。");
                }
                if (wyp != null)
                {
                    dispatcher.Invoke(() => viewModel.Feedback = "YPと通信中...");
                    if (viewModel.YellowPagesesViewModel.SelectedYellowPages[YellowPagesDefine.ListenersInvisibility] != "True")
                    {
                        nvc["listeners"] = Math.Min(info.Value.Item1, info.Value.Item2).ToString();
                    }
                    else
                    {
                        nvc["listeners"] = "-1";
                    }
                    wyp.Update(nvc);
                    dispatcher.Invoke(() => viewModel.Feedback = "リスナー数を更新しました。");
                }
            }
            finally
            {
                dispatcher.Invoke(() => viewModel.IsBusy = false);
            }
        }
    }

    static class DispatcherExtensions
    {
        public static void Invoke(this Dispatcher dispatcher, Action action)
        {
            dispatcher.Invoke(action, null);
        }

        public static T Invoke<T>(this Dispatcher dispatcher, Func<T> func)
        {
            return (T)dispatcher.Invoke(func, null);
        }
    }
}
