﻿using System;
using System.Windows.Input;

namespace Progressive.PecaStarter.ViewModel.Command
{
    public abstract class CommandBase : ICommand
    {
        protected readonly BroadcastViewModel ViewModel;

        public event EventHandler CanExecuteChanged;

        public CommandBase(BroadcastViewModel viewModel)
        {
            ViewModel = viewModel;
        }

        public abstract bool CanExecute(object parameter);

        public void Execute(object parameter)
        {
            try
            {
                OnExecute(parameter);
            }
            catch (ApplicationException e)
            {
                ViewModel.Alert = e.Message;
            }
            catch (Exception e)
            {
                ViewModel.Alert = "致命的なエラー:" + e.Message;
            }
        }

        public void NotifyCanExecuteChanged()
        {
            if (CanExecuteChanged != null)
            {
                CanExecuteChanged(this, new EventArgs());
            }
        }

        protected abstract void OnExecute(object parameter);
    }
}
