﻿using System.Windows;
using Progressive.PecaStarter.ViewModel;
using Progressive.PecaStarter.View.WPF.Page;

namespace Progressive.PecaStarter.View.WPF.Dialog
{
    /// <summary>
    /// MessageBox.xaml の相互作用ロジック
    /// </summary>
    public partial class RelaySelectDialog : Window
    {
        public RelaySelectDialog(Broadcast owner, RelaySelectDialogViewModel viewModel)
        {
            Owner = owner;
            DataContext = viewModel;
            viewModel.ImportChannelCommand.Completed += () =>
            {
                ((Owner as Broadcast).yellowPages.Content as YellowPages).UpdateTarget();
                Owner.IsEnabled = true;
            };
            InitializeComponent();
        }

        protected override void OnClosing(System.ComponentModel.CancelEventArgs e)
        {
            base.OnClosing(e);
            Owner.IsEnabled = true;
        }

        private void Close_Click(object sender, RoutedEventArgs e)
        {
            Close();
        }
    }
}
